/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageserver.consumer;

import com.mongodb.DBObject;
import org.gcube.contentmanager.storageserver.accounting.Report;
import org.gcube.contentmanager.storageserver.accounting.ReportException;
import org.gcube.contentmanager.storageserver.accounting.ReportFactory;
import org.gcube.contentmanager.storageserver.data.CubbyHole;
import org.gcube.contentmanager.storageserver.parse.utils.ValidationUtils;
import org.gcube.contentmanager.storageserver.store.FolderStatusObject;
import org.gcube.contentmanager.storageserver.store.MongoDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderAccountingConsumer
extends Thread {
    static final Logger logger = LoggerFactory.getLogger(FolderAccountingConsumer.class);
    static final int MINUTE_DECREMENT = -2;
    private CubbyHole c;
    private int number;
    private Report report;
    private String op;
    private String filename;
    private String type;
    private String name;
    private String owner;
    private String creationTime;
    private String lastAccess;
    private String lastOperation;
    private String lastUser;
    private int linkCount;
    private String delete;
    private String callerIp;
    private String user;
    private String password;
    String[] server;
    private String from;

    public FolderAccountingConsumer(String[] srvs, CubbyHole c, int number) {
        this.c = c;
        this.number = number;
        this.server = srvs;
        try {
            this.init();
        }
        catch (ReportException e) {
            throw new RuntimeException("Accounting report Exception initialization");
        }
    }

    public FolderAccountingConsumer(String[] srvs, String user, String password, CubbyHole c, int number) {
        this.c = c;
        this.number = number;
        this.server = srvs;
        this.user = user;
        this.password = password;
        try {
            this.init();
        }
        catch (ReportException e) {
            throw new RuntimeException("Accounting report Exception initialization");
        }
    }

    private void init() throws ReportException {
        this.report = ReportFactory.getReport(1);
        this.report.init();
    }

    @Override
    public void run() {
        while (true) {
            DBObject x = null;
            MongoDB mongo = null;
            try {
                x = this.c.get();
                logger.debug("[FolderACCOUNTING] Consumer #" + this.number + " got: " + x);
                this.op = (String)x.get("op");
                DBObject obj = (DBObject)x.get("o");
                this.retrieveObjectFields(obj);
                long length = -1L;
                if (obj.get("length") != null) {
                    length = (Long)obj.get("length");
                }
                logger.info("[FolderACCOUNTING][recordCheck] operation: " + this.op + " name: " + this.name + " type: " + this.type + " path: " + this.filename + " length: " + length + " owner: " + this.owner + "\n\t cretionTime: " + this.creationTime + " lastOperation " + this.lastOperation + " lastUser: " + this.lastUser + " lastAccess: " + this.lastAccess);
                if (length > 0L && (this.filename != null && this.filename.contains("/") || this.linkCount > 0)) {
                    length /= 1024L;
                    String scope = null;
                    if (this.filename != null && this.filename.contains("/")) {
                        scope = this.retrieveScopeFromRemoteFilePath(this.filename);
                    } else {
                        String pathString = (String)obj.get("onScope");
                        scope = this.retrieveScopeFromRemoteFilePath(pathString);
                    }
                    logger.info("[FolderACCOUNTING] update edge: " + this.filename);
                    boolean validScope = ValidationUtils.validationScope(scope);
                    if (validScope) {
                        if (this.delete != null) {
                            this.lastOperation = "DELETE";
                        } else {
                            if (this.lastOperation != null && this.op != null && this.lastOperation.equalsIgnoreCase("LINK") && this.op.equalsIgnoreCase("u")) {
                                logger.info("[FolderACCOUNTING] update on link object is not accounted. Skip next ");
                                continue;
                            }
                            if (this.lastOperation == null || this.lastUser == null) {
                                logger.warn("[FolderACCOUNTING] lastOperation: " + this.lastOperation + " lastUser: " + this.lastUser + ". These values cannot be null. Skip next ");
                                continue;
                            }
                        }
                        logger.info("[FolderACCOUNTING] this is a valid record for folder accounting. build folder record  ");
                        this.print(scope, length);
                        FolderStatusObject fsr = null;
                        if (!this.isNeedFSReport(this.lastOperation)) continue;
                        try {
                            mongo = new MongoDB(this.server, this.user, this.password);
                            if (this.lastOperation.equalsIgnoreCase("COPY")) {
                                this.owner = this.lastUser;
                            }
                            String folder = this.filename.substring(0, this.filename.lastIndexOf("/"));
                            fsr = new FolderStatusObject(folder, length, 1, this.lastAccess, this.from);
                            fsr = mongo.updateFolderVolume(fsr, this.lastOperation);
                            if (this.lastOperation.equalsIgnoreCase("MOVE")) {
                                if (this.from != null) {
                                    fsr = new FolderStatusObject(this.from, length, 1, this.lastAccess, null);
                                    fsr = mongo.updateFolderVolume(fsr, "DELETE");
                                } else {
                                    logger.error("this is a move operation but the original path folder is missing. Maybe the storage-manager library is not update on the client. skip next");
                                }
                            }
                            mongo.close();
                        }
                        catch (Exception e) {
                            logger.error("Problem in updating folder status record: " + e.getMessage());
                        }
                        continue;
                    }
                    logger.error("invalid scope found" + scope + " skip next record");
                    continue;
                }
                logger.info("operation " + this.lastOperation + " is not accounted");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("ERROR Processing record: " + x + " Exception throws: " + e.getStackTrace());
                logger.info("skip to next record ");
                if (mongo == null) continue;
                mongo.close();
                continue;
            }
            break;
        }
    }

    private boolean isNeedSSReport(String lastOperation) {
        return lastOperation.equalsIgnoreCase("UPLOAD") || lastOperation.equalsIgnoreCase("COPY") || lastOperation.equalsIgnoreCase("DELETE");
    }

    public void runWithoutThread(DBObject x) {
        try {
            this.report = ReportFactory.getReport(1);
        }
        catch (ReportException e1) {
            e1.printStackTrace();
        }
        this.report.init();
        this.run();
    }

    private void retrieveObjectFields(DBObject obj) {
        this.filename = (String)obj.get("filename");
        this.type = (String)obj.get("type");
        this.name = (String)obj.get("name");
        this.owner = (String)obj.get("owner");
        this.creationTime = (String)obj.get("creationTime");
        this.lastAccess = null;
        this.from = (String)obj.get("from");
        if (obj.get("lastAccess") != null) {
            this.lastAccess = (String)obj.get("lastAccess");
        }
        this.callerIp = null;
        if (obj.get("callerIP") != null) {
            this.callerIp = (String)obj.get("callerIP");
        }
        this.lastOperation = null;
        if (obj.get("lastOperation") != null) {
            this.lastOperation = (String)obj.get("lastOperation");
        }
        this.lastUser = null;
        if (obj.get("lastUser") != null) {
            this.lastUser = (String)obj.get("lastUser");
        }
        this.linkCount = 0;
        if (obj.get("linkCount") != null) {
            this.linkCount = (Integer)obj.get("linkCount");
        }
        this.delete = null;
        if (obj.get("onDeleting") != null) {
            this.delete = (String)obj.get("onDeleting");
        }
    }

    private void print(String scope, long length) {
        logger.info(" Folder accounting properties: \n\t owner: " + this.owner + "\n\t scope: " + scope + "\n\t type  folder-status" + "\n\t file  " + this.filename + "\n\t size  " + length + "\n\t caller  " + this.callerIp + "\n\t consumer  " + this.lastUser + "\n\t lastAccess  " + this.lastAccess + "\n\t operation " + this.lastOperation);
    }

    private String retrieveScopeFromRemoteFilePath(String filename) {
        String[] split = filename.split("/");
        if (split.length > 0) {
            String scope = null;
            int i = 1;
            if (split[1].equals("VOLATILE")) {
                i = 2;
            }
            scope = "/" + split[i];
            ++i;
            while (!split[i].equals("home") && !split[i].equals("public")) {
                scope = scope + "/" + split[i];
                ++i;
            }
            logger.info("retieved scope: " + scope);
            return scope;
        }
        logger.error("Scope bad format: scope not retrieved from string: " + filename);
        return null;
    }

    private boolean isNeedFSReport(String lastOperation) {
        return lastOperation.equalsIgnoreCase("UPLOAD") || lastOperation.equalsIgnoreCase("COPY") || lastOperation.equalsIgnoreCase("DELETE") || lastOperation.equalsIgnoreCase("MOVE");
    }
}

