/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel.validations.validators;

import java.util.regex.Matcher;
import org.gcube.accounting.datamodel.validations.validators.MultiMatcher;
import org.gcube.accounting.datamodel.validations.validators.Replace;
import org.gcube.com.fasterxml.jackson.annotation.JsonSetter;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.records.DSMapper;

public class MatcherReplace {
    protected MultiMatcher multiMatcher;
    protected Replace replacementRegex;

    public MultiMatcher getMultiMatcher() {
        return this.multiMatcher;
    }

    @JsonSetter(value="match")
    public void setMultiMatcher(MultiMatcher multiMatcher) {
        this.multiMatcher = multiMatcher;
    }

    protected Replace getReplacementRegex() {
        return this.replacementRegex;
    }

    @JsonSetter(value="replace")
    public void setReplacementRegex(Replace replacementRegex) {
        this.replacementRegex = replacementRegex;
    }

    public Replace check(String serviceClass, String serviceName, String calledMethod) throws InvalidValueException {
        Replace replace;
        boolean matched = this.multiMatcher.match(serviceClass, serviceName, calledMethod);
        if (matched) {
            replace = new Replace();
            Matcher serviceClassMatcher = this.multiMatcher.getServiceClassPattern().matcher(serviceClass);
            String replacementServiceClass = this.replacementRegex.getServiceClass();
            String replaceServiceClass = serviceClassMatcher.replaceFirst(replacementServiceClass);
            replace.setServiceClass(replaceServiceClass);
            Matcher serviceNameMatcher = this.multiMatcher.getServiceNamePattern().matcher(serviceName);
            String replacementServiceName = this.replacementRegex.getServiceName();
            String replaceServiceName = serviceNameMatcher.replaceFirst(replacementServiceName);
            replace.setServiceName(replaceServiceName);
            Matcher calledMethodMatcher = this.multiMatcher.getCalledMethodPattern().matcher(calledMethod);
            String replacementCalledMethod = this.replacementRegex.getCalledMethod();
            String replaceCalledMethod = calledMethodMatcher.replaceFirst(replacementCalledMethod);
            replace.setCalledMethod(replaceCalledMethod);
        } else {
            replace = null;
        }
        return replace;
    }

    public String toString() {
        try {
            return DSMapper.getObjectMapper().writeValueAsString(this);
        }
        catch (Exception e) {
            return "MatcherReplace [multiMatcher=" + this.multiMatcher + ", replacer=" + this.replacementRegex + "]";
        }
    }
}

