/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageserver.startup;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gcube.common.encryption.encrypter.StringEncrypter;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanager.storageserver.parse.utils.ValidationUtils;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private String scope;
    private String[] server;
    private String username;
    private String password;
    private String backendType;
    private ArrayList<String> dtsHosts;
    private boolean activeDTSFilter;
    private static final String STORAGE_SE_CATEGORY = "DataStorage";
    private static final String STORAGE_SE_NAME = "StorageManager";
    private static final String SYSTEM_SE_CATEGORY = "SystemService";
    private static final String SYSTEM_SE_NAME = "storage-manager-trigger";
    private static final String ACCOUNTING_USERNAME = "accounting_user";
    private static final String ACCOUNTING_PASSWORDNAME = "accounting_pwd";
    private static final String AUTH_SE_CATEGORY = "Auth";
    private static final String AUTH_SE_NAME = "IAM";
    private static final Object AUTH_SE_AP_NAME = "d4science-oidc-token";
    protected String clientId;
    protected String secret;
    Logger logger = LoggerFactory.getLogger(Configuration.class);

    public Configuration(String scope, String user, String password, boolean dtsFilter) {
        this.activeDTSFilter = dtsFilter;
        this.scope = scope;
        if (!ValidationUtils.validationScope(scope)) {
            throw new IllegalArgumentException("invalid scope exception: " + scope);
        }
    }

    public Configuration(String scope, boolean dtsFilter) {
        this.activeDTSFilter = dtsFilter;
        this.scope = scope;
        if (!ValidationUtils.validationScope(scope)) {
            throw new IllegalArgumentException("invalid scope exception: " + scope);
        }
        ScopeProvider.instance.set(scope);
    }

    public String[] getServerAccess(List<ServiceEndpoint> resources) {
        String savedScope = null;
        if (this.scope != null) {
            savedScope = ScopeProvider.instance.get();
            ScopeProvider.instance.set(this.scope);
        }
        this.logger.debug("get server from IS ");
        this.getServerRRFws(resources);
        if (this.scope != null) {
            ScopeProvider.instance.set(savedScope);
        }
        this.logger.info("server found {} ", this.server);
        return this.server;
    }

    public String[] getServerRRFws(List<ServiceEndpoint> resources) {
        if (resources.size() > 1) {
            this.logger.info("found " + resources.size() + " RR ");
            return this.getServers(resources);
        }
        if (resources.size() == 1) {
            this.logger.info("found only one RR, take it");
            return this.getServers(resources.get(0));
        }
        this.logger.error("RUNTIME RESOURCE NOT FOUND IN THIS SCOPE " + ScopeProvider.instance.get());
        throw new RuntimeException("RUNTIME RESOURCE NOT FOUND IN SCOPE: " + ScopeProvider.instance.get());
    }

    protected String getAccountingUser(List<ServiceEndpoint> resources) {
        this.logger.trace("retrieving access point");
        for (ServiceEndpoint.AccessPoint ap : resources.get(0).profile().accessPoints()) {
            Map<String, ServiceEndpoint.Property> map = ap.propertyMap();
            ServiceEndpoint.Property user = map.get(ACCOUNTING_USERNAME);
            if (user == null) continue;
            this.logger.debug("accounting user found on SE");
            return user.value();
        }
        return null;
    }

    protected void setSecrets(ServiceEndpoint se) throws Exception {
        for (ServiceEndpoint.AccessPoint ap : se.profile().accessPoints()) {
            this.setClientId(ap.username());
            this.setSecret(StringEncrypter.getEncrypter().decrypt(ap.password()));
        }
    }

    protected String getAccountingPassword(List<ServiceEndpoint> resources) {
        for (ServiceEndpoint.AccessPoint ap : resources.get(0).profile().accessPoints()) {
            Map<String, ServiceEndpoint.Property> map = ap.propertyMap();
            ServiceEndpoint.Property pwd = map.get(ACCOUNTING_PASSWORDNAME);
            if (pwd == null) continue;
            this.logger.debug("password field found on SE");
            try {
                return StringEncrypter.getEncrypter().decrypt(pwd.value());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected List<ServiceEndpoint> getStorageServiceEndpoint() {
        this.logger.debug("query for serviceEndpoint ongoing...");
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq 'DataStorage' and $resource/Profile/Name eq 'StorageManager' ");
        DiscoveryClient<ServiceEndpoint> client = ICFactory.clientFor(ServiceEndpoint.class);
        List<ServiceEndpoint> resources = client.submit(query);
        if (resources.size() > 0) {
            this.logger.debug("resource found on IS");
        }
        return resources;
    }

    protected ServiceEndpoint getSystemServiceEndpoint() {
        this.logger.debug("query for serviceEndpoint ongoing...");
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq 'SystemService' and $resource/Profile/Name eq 'storage-manager-trigger' ");
        DiscoveryClient<ServiceEndpoint> client = ICFactory.clientFor(ServiceEndpoint.class);
        List<ServiceEndpoint> resources = client.submit(query);
        if (resources.size() > 0) {
            return resources.get(0);
        }
        throw new RuntimeException("System ServiceEndpoint not found");
    }

    private String[] getServers(ServiceEndpoint res) {
        ServiceEndpoint.AccessPoint ap2;
        this.server = new String[res.profile().accessPoints().size()];
        int i = 0;
        for (ServiceEndpoint.AccessPoint ap2 : res.profile().accessPoints()) {
            if (!ap2.name().equals("server" + (i + 1))) continue;
            this.server[i] = ap2.address();
            this.username = ap2.username();
            if (this.username != null && this.username.length() > 0) {
                try {
                    this.password = StringEncrypter.getEncrypter().decrypt(ap2.password());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        Iterator it = res.profile().accessPoints().iterator();
        ap2 = (ServiceEndpoint.AccessPoint)it.next();
        Map<String, ServiceEndpoint.Property> map = ap2.propertyMap();
        ServiceEndpoint.Property type = map.get("type");
        this.backendType = type.value();
        this.logger.debug("Type of backend found " + this.backendType);
        return this.server;
    }

    private String[] getServers(List<ServiceEndpoint> resources) {
        ServiceEndpoint defaultResource = null;
        this.logger.debug("search RR with priority ");
        for (ServiceEndpoint res : resources) {
            String priority = this.retrievePropertyValue(res, "priority");
            if (priority == null) continue;
            defaultResource = res;
            this.logger.debug("found a RR with priority: ");
            break;
        }
        if (defaultResource != null) {
            this.server = new String[defaultResource.profile().accessPoints().size()];
            int i = 0;
            for (ServiceEndpoint.AccessPoint ap : defaultResource.profile().accessPoints()) {
                if (!ap.name().equals("server" + (i + 1))) continue;
                this.server[i] = ap.address();
                this.username = ap.username();
                this.password = "";
                if (this.username != null && this.username.length() > 0) {
                    try {
                        this.password = StringEncrypter.getEncrypter().decrypt(ap.password());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
            this.backendType = this.retrievePropertyValue(defaultResource, "type");
            this.logger.debug("Type of backend found in RR is " + this.backendType);
            return this.server;
        }
        throw new IllegalStateException("Runtime Resource found are more than 1 but all without default priority setted");
    }

    private String retrievePropertyValue(ServiceEndpoint res, String name) {
        Iterator it = res.profile().accessPoints().iterator();
        ServiceEndpoint.AccessPoint ap = (ServiceEndpoint.AccessPoint)it.next();
        Map<String, ServiceEndpoint.Property> map = ap.propertyMap();
        ServiceEndpoint.Property type = map.get(name);
        if (type != null) {
            return type.value();
        }
        return null;
    }

    public List<String> retrieveDTSHosts() {
        if (this.activeDTSFilter) {
            ArrayList<String> scopes = ValidationUtils.getVOScopes(this.scope);
            this.dtsHosts = new ArrayList();
            for (String currentScope : scopes) {
                String host = this.getHosts("DataTransformation", "DataTransformationService", currentScope);
                this.logger.debug("host found: " + host + " in scope: " + currentScope);
                if (host == null) continue;
                this.dtsHosts.add(host);
            }
            for (String host : this.dtsHosts) {
                this.logger.debug("DTS host: " + host);
            }
            return this.dtsHosts;
        }
        return null;
    }

    public String getHosts(String serviceClass, String serviceName) {
        return this.getHosts(serviceClass, serviceName, this.scope);
    }

    public String getHosts(String serviceClass, String serviceName, String scope) {
        String host = null;
        String currentScope = ScopeProvider.instance.get();
        ScopeProvider.instance.set(scope);
        XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
        query.addCondition("$resource/Profile/ServiceClass eq '" + serviceClass + "' and $resource/Profile/ServiceName eq '" + serviceName + "' ");
        DiscoveryClient<GCoreEndpoint> client = ICFactory.clientFor(GCoreEndpoint.class);
        try {
            List<GCoreEndpoint> resources = client.submit(query);
            if (resources.size() > 0) {
                GCoreEndpoint.Profile.Endpoint endpoint;
                GCoreEndpoint res = resources.get(0);
                Iterator it = res.profile().endpoints().iterator();
                if (it.hasNext() && (host = (endpoint = (GCoreEndpoint.Profile.Endpoint)it.next()).uri().toString()).contains("//")) {
                    int begin = host.indexOf("//");
                    host = host.substring(begin + 2);
                    this.logger.debug("phase#1 " + host);
                    String[] uris = host.split(":");
                    this.logger.debug("phase#2 " + uris[0]);
                    host = uris[0];
                }
                ScopeProvider.instance.set(currentScope);
            }
        }
        catch (Exception e) {
            this.logger.error("FAIL to retrieve resource from scope " + scope + " cause: " + e.getMessage());
            ScopeProvider.instance.set(currentScope);
        }
        return host;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String[] getServer() {
        return this.server;
    }

    public void setServer(String[] server) {
        this.server = server;
    }

    public String getBackendType() {
        return this.backendType;
    }

    public void setBackendType(String backendType) {
        this.backendType = backendType;
    }

    public ArrayList<String> getDtsHosts() {
        return this.dtsHosts;
    }

    public void setDtsHosts(ArrayList<String> dtsHosts) {
        this.dtsHosts = dtsHosts;
    }

    public boolean isActiveDTSFilter() {
        return this.activeDTSFilter;
    }

    public void setActiveDTSFilter(boolean activeDTSFilter) {
        this.activeDTSFilter = activeDTSFilter;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.logger.debug("clientID " + clientId);
        this.clientId = clientId;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    String getOidcEndpoint() {
        this.logger.debug("query for Auth serviceEndpoint ongoing...");
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq 'Auth' and $resource/Profile/Name eq 'IAM' ");
        DiscoveryClient<ServiceEndpoint> client = ICFactory.clientFor(ServiceEndpoint.class);
        List<ServiceEndpoint> resources = client.submit(query);
        if (resources.size() > 0) {
            this.logger.debug("resource found on IS");
            for (ServiceEndpoint.AccessPoint ap : resources.get(0).profile().accessPoints()) {
                if (!ap.name().equals(AUTH_SE_AP_NAME)) continue;
                return ap.address();
            }
        }
        throw new RuntimeException("accessPoint " + AUTH_SE_AP_NAME + " not found on SE " + AUTH_SE_CATEGORY + " - " + AUTH_SE_NAME);
    }
}

