/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.persistence;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.gcube.documentstore.persistence.ExecutorUtils;
import org.gcube.documentstore.persistence.FallbackPersistenceBackend;
import org.gcube.documentstore.persistence.PersistenceBackend;
import org.gcube.documentstore.persistence.PersistenceBackendFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PersistenceBackendRediscover
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceBackendRediscover.class);
    protected final String context;
    protected final FallbackPersistenceBackend fallbackPersistenceBackend;
    private ScheduledFuture<?> scheduledThread;

    public PersistenceBackendRediscover(String context, FallbackPersistenceBackend fallbackPersistenceBackend, long initialDelay, long delay, TimeUnit timeUnit) {
        this.context = context;
        this.fallbackPersistenceBackend = fallbackPersistenceBackend;
        this.scheduledThread = ExecutorUtils.PERSISTENCE_BACKEND_REDISCOVERY_POOL.scheduleAtFixedRate(this, initialDelay, delay, timeUnit);
    }

    @Override
    public void run() {
        logger.trace("Going to rediscover {}", (Object)PersistenceBackend.class.getSimpleName());
        PersistenceBackend rediscovered = PersistenceBackendFactory.rediscoverPersistenceBackend(this.fallbackPersistenceBackend, this.context);
        if (!rediscovered.getClass().equals(this.fallbackPersistenceBackend.getClass())) {
            logger.trace("Another {} was found : {}. Shutting down {} Thread for context {}", PersistenceBackend.class.getSimpleName(), rediscovered.getClass().getSimpleName(), PersistenceBackendRediscover.class.getSimpleName(), this.context);
            this.scheduledThread.cancel(true);
        } else {
            logger.trace("{} for context {} is still a {}. We will see if next time we will be more lucky.", PersistenceBackend.class.getSimpleName(), this.context, FallbackPersistenceBackend.class.getSimpleName());
        }
    }
}

