/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.pojo.annotations.BsonProperty;

final class CreatorExecutable<T> {
    private final Class<T> clazz;
    private final Constructor<T> constructor;
    private final Method method;
    private final List<BsonProperty> properties = new ArrayList<BsonProperty>();
    private final List<Class<?>> parameterTypes = new ArrayList();

    CreatorExecutable(Class<T> clazz, Constructor<T> constructor) {
        this(clazz, constructor, null);
    }

    CreatorExecutable(Class<T> clazz, Method method) {
        this(clazz, null, method);
    }

    private CreatorExecutable(Class<T> clazz, Constructor<T> constructor, Method method) {
        this.clazz = clazz;
        this.constructor = constructor;
        this.method = method;
        if (constructor != null || method != null) {
            Annotation[][] parameterAnnotations;
            this.parameterTypes.addAll(Arrays.asList(constructor != null ? constructor.getParameterTypes() : method.getParameterTypes()));
            Annotation[][] annotationArray = parameterAnnotations = constructor != null ? constructor.getParameterAnnotations() : method.getParameterAnnotations();
            int n = annotationArray.length;
            block0: for (int i = 0; i < n; ++i) {
                Annotation[] parameterAnnotation;
                for (Annotation annotation : parameterAnnotation = annotationArray[i]) {
                    if (!annotation.annotationType().equals(BsonProperty.class)) continue;
                    this.properties.add((BsonProperty)annotation);
                    continue block0;
                }
            }
        }
    }

    public Class<T> getType() {
        return this.clazz;
    }

    List<BsonProperty> getProperties() {
        return this.properties;
    }

    public List<Class<?>> getParameterTypes() {
        return this.parameterTypes;
    }

    T getInstance() {
        this.checkHasAnExecutable();
        try {
            if (this.constructor != null) {
                return this.constructor.newInstance(new Object[0]);
            }
            return (T)this.method.invoke(this.clazz, new Object[0]);
        }
        catch (Exception e) {
            throw new CodecConfigurationException(e.getMessage(), e);
        }
    }

    T getInstance(Object[] params) {
        this.checkHasAnExecutable();
        try {
            if (this.constructor != null) {
                return this.constructor.newInstance(params);
            }
            return (T)this.method.invoke(this.clazz, params);
        }
        catch (Exception e) {
            throw new CodecConfigurationException(e.getMessage(), e);
        }
    }

    CodecConfigurationException getError(Class<?> clazz, String msg) {
        return CreatorExecutable.getError(clazz, this.constructor != null, msg);
    }

    void checkHasAnExecutable() {
        if (this.constructor == null && this.method == null) {
            throw new CodecConfigurationException(String.format("Cannot find a public constructor for '%s'.", this.clazz.getSimpleName()));
        }
    }

    private static CodecConfigurationException getError(Class<?> clazz, boolean isConstructor, String msg) {
        return new CodecConfigurationException(String.format("Invalid @BsonCreator %s in %s. %s", isConstructor ? "constructor" : "method", clazz.getSimpleName(), msg));
    }
}

