/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.security.authn.filter;

import java.io.IOException;
import java.security.cert.X509Certificate;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.gcube.accounting.security.SecurityManager;

public class X509Filter
implements Filter {
    private static Logger logger = Logger.getLogger(X509Filter.class);

    public void init(FilterConfig arg0) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)res;
        if (!SecurityManager.isAuthnEnabled()) {
            chain.doFilter(req, res);
            return;
        }
        if (!"x509".equals(SecurityManager.getAuthnType())) {
            chain.doFilter(req, res);
            return;
        }
        String requestDN = this.getUserDN(req);
        if (requestDN != null) {
            req.setAttribute("requestorDN", (Object)requestDN);
            req.setAttribute("userId", (Object)requestDN);
            chain.doFilter(req, res);
            return;
        }
        ((HttpServletResponse)res).sendError(401);
    }

    private String getUserDN(ServletRequest req) {
        X509Certificate[] certs = this.getCerts(req);
        if (certs != null && certs.length > 0) {
            return certs[0].getSubjectDN().getName();
        }
        return null;
    }

    private X509Certificate[] getCerts(ServletRequest req) {
        return (X509Certificate[])req.getAttribute("javax.servlet.request.X509Certificate");
    }

    public void destroy() {
    }
}

