/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire.tool;

import org.codehaus.jam.JAnnotation;
import org.codehaus.jam.JAnnotationValue;
import org.codehaus.jam.JClass;
import org.codehaus.jam.JField;
import org.codehaus.jam.JMethod;
import org.codehaus.jam.JProperty;
import org.codehaus.jam.JamClassIterator;
import org.codehaus.jam.JamService;

public abstract class OpenWireGenerator {
    protected int openwireVersion;
    protected String filePostFix = ".java";
    protected JamService jam;

    public boolean isValidProperty(JProperty it) {
        JMethod getter = it.getGetter();
        return getter != null && it.getSetter() != null && !getter.isStatic() && getter.getAnnotation("openwire:property") != null;
    }

    public boolean isCachedProperty(JProperty it) {
        JMethod getter = it.getGetter();
        if (!this.isValidProperty(it)) {
            return false;
        }
        JAnnotationValue value = getter.getAnnotation("openwire:property").getValue("cache");
        return value != null && value.asBoolean();
    }

    public boolean isAbstract(JClass j) {
        JField[] fields = j.getFields();
        for (int i = 0; i < fields.length; ++i) {
            JField field = fields[i];
            if (!field.isStatic() || !field.isPublic() || !field.isFinal() || !field.getSimpleName().equals("DATA_STRUCTURE_TYPE")) continue;
            return false;
        }
        return true;
    }

    public boolean isThrowable(JClass j) {
        if (j.getQualifiedName().equals(Throwable.class.getName())) {
            return true;
        }
        return j.getSuperclass() != null && this.isThrowable(j.getSuperclass());
    }

    public boolean isMarshallAware(JClass j) {
        if (this.filePostFix.endsWith("java")) {
            JClass[] interfaces = j.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!interfaces[i].getQualifiedName().equals("org.apache.activemq.command.MarshallAware")) continue;
                return true;
            }
            return false;
        }
        String simpleName = j.getSimpleName();
        return simpleName.equals("ActiveMQMessage") || simpleName.equals("WireFormatInfo");
    }

    public JamService getJam() {
        return this.jam;
    }

    public JamClassIterator getClasses() {
        return this.getJam().getClasses();
    }

    public int getOpenwireVersion() {
        return this.openwireVersion;
    }

    public void setOpenwireVersion(int openwireVersion) {
        this.openwireVersion = openwireVersion;
    }

    public String toCSharpType(JClass type) {
        String name = type.getSimpleName();
        if (name.equals("String")) {
            return "string";
        }
        if (name.equals("Throwable") || name.equals("Exception")) {
            return "BrokerError";
        }
        if (name.equals("ByteSequence")) {
            return "byte[]";
        }
        if (name.equals("boolean")) {
            return "bool";
        }
        return name;
    }

    public String getOpenWireOpCode(JClass element) {
        if (element != null) {
            JAnnotation annotation = element.getAnnotation("openwire:marshaller");
            return this.stringValue(annotation, "code", "0");
        }
        return "0";
    }

    protected String stringValue(JAnnotation annotation, String name) {
        return this.stringValue(annotation, name, null);
    }

    protected String stringValue(JAnnotation annotation, String name, String defaultValue) {
        JAnnotationValue value;
        if (annotation != null && (value = annotation.getValue(name)) != null) {
            return value.asString();
        }
        return defaultValue;
    }

    public void setJam(JamService jam) {
        this.jam = jam;
    }

    public String decapitalize(String text) {
        if (text == null) {
            return null;
        }
        return text.substring(0, 1).toLowerCase() + text.substring(1);
    }

    public String capitalize(String text) {
        if (text == null) {
            return null;
        }
        return text.substring(0, 1).toUpperCase() + text.substring(1);
    }
}

