/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageserver.startup;

import java.security.Key;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanager.storageserver.parse.utils.ValidationUtils;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private String scope;
    private String[] server;
    private String username;
    private String password;
    private String backendType;
    Logger logger = LoggerFactory.getLogger(Configuration.class);

    public Configuration(String scope, String user, String password) {
        this.scope = scope;
        if (!ValidationUtils.validationScope(scope)) {
            throw new IllegalArgumentException("invalid scope exception: " + scope);
        }
    }

    public String[] getServerAccess() {
        String savedScope = null;
        if (this.scope != null) {
            savedScope = ScopeProvider.instance.get();
            ScopeProvider.instance.set(this.scope);
        }
        this.logger.debug("get server from IS ");
        this.getServerRRFws();
        if (this.scope != null) {
            ScopeProvider.instance.set(savedScope);
        }
        this.logger.info("server found {} ", this.server);
        return this.server;
    }

    public String[] getServerRRFws() {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq 'DataStorage' and $resource/Profile/Name eq 'StorageManager' ");
        DiscoveryClient<ServiceEndpoint> client = ICFactory.clientFor(ServiceEndpoint.class);
        List<ServiceEndpoint> resources = client.submit(query);
        if (resources.size() > 1) {
            this.logger.info("found " + resources.size() + " RR ");
            return this.getServers(resources);
        }
        if (resources.size() == 1) {
            this.logger.info("found only one RR, take it");
            return this.getServers(resources.get(0));
        }
        this.logger.error("RUNTIME RESOURCE NOT FOUND IN THIS SCOPE " + ScopeProvider.instance.get());
        throw new RuntimeException("RUNTIME RESOURCE NOT FOUND IN SCOPE: " + ScopeProvider.instance.get());
    }

    private String[] getServers(ServiceEndpoint res) {
        this.server = new String[res.profile().accessPoints().size()];
        int i = 0;
        for (ServiceEndpoint.AccessPoint ap : res.profile().accessPoints()) {
            if (!ap.name().equals("server" + (i + 1))) continue;
            this.server[i] = ap.address();
            this.username = ap.username();
            if (this.username != null && this.username.length() > 0) {
                try {
                    this.password = StringEncrypter.getEncrypter().decrypt(ap.password(), new Key[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        Iterator it = res.profile().accessPoints().iterator();
        ServiceEndpoint.AccessPoint ap = (ServiceEndpoint.AccessPoint)it.next();
        Map<String, ServiceEndpoint.Property> map = ap.propertyMap();
        ServiceEndpoint.Property type = map.get("type");
        this.backendType = type.value();
        this.logger.info("Type of backend found " + this.backendType);
        return this.server;
    }

    private String[] getServers(List<ServiceEndpoint> resources) {
        ServiceEndpoint defaultResource = null;
        this.logger.info("search RR with priority ");
        for (ServiceEndpoint res : resources) {
            String priority = this.retrievePropertyValue(res, "priority");
            if (priority == null) continue;
            defaultResource = res;
            this.logger.info("found a RR with priority: ");
            break;
        }
        if (defaultResource != null) {
            this.server = new String[defaultResource.profile().accessPoints().size()];
            int i = 0;
            for (ServiceEndpoint.AccessPoint ap : defaultResource.profile().accessPoints()) {
                if (!ap.name().equals("server" + (i + 1))) continue;
                this.server[i] = ap.address();
                this.username = ap.username();
                this.password = "";
                if (this.username != null && this.username.length() > 0) {
                    try {
                        this.password = StringEncrypter.getEncrypter().decrypt(ap.password(), new Key[0]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
            this.backendType = this.retrievePropertyValue(defaultResource, "type");
            this.logger.info("Type of backend found in RR is " + this.backendType);
            return this.server;
        }
        throw new IllegalStateException("Runtime Resource found are more than 1 but all without default priority setted");
    }

    private String retrievePropertyValue(String name, String scope) {
        String savedScope = null;
        if (scope != null) {
            savedScope = ScopeProvider.instance.get();
            ScopeProvider.instance.set(scope);
        }
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq 'DataStorage' and $resource/Profile/Name eq 'StorageManager' ");
        DiscoveryClient<ServiceEndpoint> client = ICFactory.clientFor(ServiceEndpoint.class);
        List<ServiceEndpoint> resources = client.submit(query);
        ServiceEndpoint res = resources.get(0);
        Iterator it = res.profile().accessPoints().iterator();
        ServiceEndpoint.AccessPoint ap = (ServiceEndpoint.AccessPoint)it.next();
        Map<String, ServiceEndpoint.Property> map = ap.propertyMap();
        ServiceEndpoint.Property type = map.get(name);
        String value = type.value();
        if (scope != null) {
            ScopeProvider.instance.set(savedScope);
        }
        return value;
    }

    private String retrievePropertyValue(ServiceEndpoint res, String name) {
        Iterator it = res.profile().accessPoints().iterator();
        ServiceEndpoint.AccessPoint ap = (ServiceEndpoint.AccessPoint)it.next();
        Map<String, ServiceEndpoint.Property> map = ap.propertyMap();
        ServiceEndpoint.Property type = map.get(name);
        if (type != null) {
            return type.value();
        }
        return null;
    }
}

