/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageserver.accounting;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.gcube.accounting.datamodel.RawUsageRecord;
import org.gcube.accounting.messaging.ResourceAccounting;
import org.gcube.accounting.messaging.ResourceAccountingFactory;
import org.gcube.contentmanager.storageserver.accounting.Report;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportAccountingImpl
implements Report {
    final Logger logger = LoggerFactory.getLogger(ReportAccountingImpl.class);
    public RawUsageRecord ssr;
    public ResourceAccounting raFactory;

    @Override
    public void init() {
        this.raFactory = null;
        try {
            this.raFactory = ResourceAccountingFactory.getResourceAccountingInstance();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public RawUsageRecord setGenericProperties(String resourceType, String consumerId, String resourceScope, String creationTime, String lastAccess, String owner) {
        this.logger.info("set accounting generic properties: resourceType: " + resourceType + " consumerId " + consumerId + " scope: " + resourceScope + " creationTime " + creationTime + " lastAccess " + lastAccess + " owner " + owner);
        if (this.raFactory == null) {
            this.init();
        }
        RawUsageRecord sr = new RawUsageRecord();
        sr.setResourceType(resourceType);
        if (consumerId != null) {
            sr.setConsumerId(consumerId);
        }
        if (resourceScope != null) {
            sr.setResourceScope(resourceScope);
        }
        if (creationTime != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("dd MM yyyy 'at' hh:mm:ss z");
            Date date = null;
            try {
                date = formatter.parse(creationTime);
            }
            catch (ParseException e) {
                this.logger.error("Error in parsing date: " + creationTime + " exc msg: " + e.getMessage());
            }
            sr.setCreateTime(date);
            try {
                date = new SimpleDateFormat("dd MM yyyy 'at' hh:mm:ss z").parse(lastAccess);
                sr.setStartTime(date);
                sr.setEndTime(date);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (owner != null) {
                sr.setResourceOwner(owner);
            }
        }
        return sr;
    }

    @Override
    public RawUsageRecord setSpecificProperties(RawUsageRecord sur, String operation, String size, String filePath, String callerIP, String dataType, String dataCount) {
        this.logger.info("set accounting properties: operation: " + operation + " size: " + size + " remotePath: " + filePath + " callerIP " + callerIP + " dataType " + dataType + " dataCount " + dataCount);
        if (sur == null) {
            sur = new RawUsageRecord();
        }
        if (operation != null) {
            sur.setResourceSpecificProperty("operationType", operation);
        }
        if (size != null) {
            sur.setResourceSpecificProperty("dataVolume", size);
        }
        if (filePath != null) {
            sur.setResourceSpecificProperty("remotePath", filePath);
        }
        if (callerIP != null) {
            sur.setResourceSpecificProperty("callerIP", callerIP);
        }
        sur.setResourceSpecificProperty("dataType", dataType);
        sur.setResourceSpecificProperty("dataCount", dataCount);
        return sur;
    }

    @Override
    public void send(RawUsageRecord sur) {
        this.logger.info("report sending...");
        if (this.raFactory != null) {
            this.raFactory.sendAccountingMessage(sur);
        } else {
            this.logger.error("Problem on building accounting record: Factory Object is null ");
        }
    }
}

