/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.security.authz;

import org.gcube.accounting.security.authz.Action;
import org.gcube.accounting.security.authz.Role;

public class Permission {
    private String userId;
    private Role role;
    private String target;

    public Permission() {
    }

    public Permission(String userId, String target, Role role) {
        this();
        this.setUserId(userId);
        this.setTarget(target);
        this.setRole(role);
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        if (userId != null) {
            this.userId = userId.trim();
        }
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        if (target != null) {
            this.target = target.trim();
        }
    }

    public boolean isAllowed(Action a) {
        return this.role.isAllowed(a);
    }

    public boolean isAllowed(Action a, String object) {
        if (!this.isAllowed(a)) {
            return false;
        }
        return object != null && object.trim().startsWith(this.target);
    }

    public String toString() {
        return this.userId + ":" + this.role.getName() + ":" + this.target;
    }
}

