/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import org.apache.activemq.management.CountStatisticImpl;
import org.apache.activemq.management.PollCountStatisticImpl;
import org.apache.activemq.management.StatsImpl;
import org.apache.activemq.management.TimeStatisticImpl;

public class DestinationStatistics
extends StatsImpl {
    protected CountStatisticImpl enqueues = new CountStatisticImpl("enqueues", "The number of messages that have been sent to the destination");
    protected CountStatisticImpl dequeues;
    protected CountStatisticImpl consumers;
    protected CountStatisticImpl producers;
    protected CountStatisticImpl messages;
    protected PollCountStatisticImpl messagesCached;
    protected CountStatisticImpl dispatched = new CountStatisticImpl("dispatched", "The number of messages that have been dispatched from the destination");
    protected CountStatisticImpl inflight;
    protected TimeStatisticImpl processTime;

    public DestinationStatistics() {
        this.dequeues = new CountStatisticImpl("dequeues", "The number of messages that have been acknowledged from the destination");
        this.inflight = new CountStatisticImpl("inflight", "The number of messages dispatched but awaiting acknowledgement");
        this.consumers = new CountStatisticImpl("consumers", "The number of consumers that that are subscribing to messages from the destination");
        this.consumers.setDoReset(false);
        this.producers = new CountStatisticImpl("producers", "The number of producers that that are publishing messages to the destination");
        this.producers.setDoReset(false);
        this.messages = new CountStatisticImpl("messages", "The number of messages that that are being held by the destination");
        this.messagesCached = new PollCountStatisticImpl("messagesCached", "The number of messages that are held in the destination's memory cache");
        this.processTime = new TimeStatisticImpl("processTime", "information around length of time messages are held by a destination");
        this.addStatistic("enqueues", this.enqueues);
        this.addStatistic("dispatched", this.dispatched);
        this.addStatistic("dequeues", this.dequeues);
        this.addStatistic("inflight", this.inflight);
        this.addStatistic("consumers", this.consumers);
        this.addStatistic("producers", this.producers);
        this.addStatistic("messages", this.messages);
        this.addStatistic("messagesCached", this.messagesCached);
        this.addStatistic("processTime", this.processTime);
    }

    public CountStatisticImpl getEnqueues() {
        return this.enqueues;
    }

    public CountStatisticImpl getDequeues() {
        return this.dequeues;
    }

    public CountStatisticImpl getInflight() {
        return this.inflight;
    }

    public CountStatisticImpl getConsumers() {
        return this.consumers;
    }

    public CountStatisticImpl getProducers() {
        return this.producers;
    }

    public PollCountStatisticImpl getMessagesCached() {
        return this.messagesCached;
    }

    public CountStatisticImpl getMessages() {
        return this.messages;
    }

    public void setMessagesCached(PollCountStatisticImpl messagesCached) {
        this.messagesCached = messagesCached;
    }

    public CountStatisticImpl getDispatched() {
        return this.dispatched;
    }

    public TimeStatisticImpl getProcessTime() {
        return this.processTime;
    }

    public void reset() {
        if (this.isDoReset()) {
            super.reset();
            this.enqueues.reset();
            this.dequeues.reset();
            this.dispatched.reset();
            this.inflight.reset();
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.enqueues.setEnabled(enabled);
        this.dispatched.setEnabled(enabled);
        this.dequeues.setEnabled(enabled);
        this.inflight.setEnabled(enabled);
        this.consumers.setEnabled(enabled);
        this.producers.setEnabled(enabled);
        this.messages.setEnabled(enabled);
        this.messagesCached.setEnabled(enabled);
        this.processTime.setEnabled(enabled);
    }

    public void setParent(DestinationStatistics parent) {
        if (parent != null) {
            this.enqueues.setParent(parent.enqueues);
            this.dispatched.setParent(parent.dispatched);
            this.dequeues.setParent(parent.dequeues);
            this.inflight.setParent(parent.inflight);
            this.consumers.setParent(parent.consumers);
            this.producers.setParent(parent.producers);
            this.messagesCached.setParent(parent.messagesCached);
            this.messages.setParent(parent.messages);
            this.processTime.setParent(parent.processTime);
        } else {
            this.enqueues.setParent(null);
            this.dispatched.setParent(null);
            this.dequeues.setParent(null);
            this.inflight.setParent(null);
            this.consumers.setParent(null);
            this.producers.setParent(null);
            this.messagesCached.setParent(null);
            this.messages.setParent(null);
            this.processTime.setParent(null);
        }
    }
}

