/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.security.authz;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.gcube.accounting.security.authz.Action;

public class Role {
    private String name;
    private Set<Action> actions = new HashSet<Action>();

    private Role() {
    }

    public Role(String name) {
        this();
        this.setName(name);
    }

    public void setName(String name) {
        if (name != null) {
            this.name = name.trim();
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isAllowed(Action action) {
        return this.actions.contains((Object)action);
    }

    public void addAction(Action act) {
        this.actions.add(act);
    }

    public void addActions(Action ... acts) {
        for (Action a : acts) {
            this.actions.add(a);
        }
    }

    public void addActions(Collection<Action> actions) {
        this.actions.addAll(actions);
    }
}

