package org.gcube.contentmanager.storageserver.startup;

import java.util.Arrays;
import org.gcube.contentmanager.storageserver.data.CubbyHole;
import org.gcube.contentmanager.storageserver.data.ReadingMongoOplog;
import org.gcube.contentmanager.storageserver.parse.JsonParser;

public class Startup {
    
	public static void main(String[] args) {
		for (int i=0; i<args.length;i++){ 
			//NO show password
			if(i==2) 
				System.out.println("param N." +i + ": *********");
			else
				System.out.println("param N." +i + ": " + args[i]);			
		}
		if(args.length != 1 && args.length != 3){
			System.out.println("Usage:");
			System.out.println("\tjava  Startup ip user password\n\n");
			System.out.println("Example:");
			System.out.println("\tjava  Startup 127.0.0.1  pippo pluT0\n");
			System.out.println("or ");
			System.out.println("Usage:");
			System.out.println("\tjava  Startup ip \n\n");
			System.out.println("Example:");
			System.out.println("\tjava  Startup 127.0.0.1  \n\n");

			return;
		}
        CubbyHole c = new CubbyHole();
        ReadingMongoOplog producer=null;
        if(args.length == 3)
        	producer=new ReadingMongoOplog( Arrays.asList(args[0]), args[1], args[2], c, 1 );
        else
        	producer=new ReadingMongoOplog( Arrays.asList(args[0]), c, 1 );
        JsonParser consumer=new JsonParser(c, 1);
        producer.start();
        consumer.start();
    }
}
