/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel.query;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gcube.accounting.datamodel.query.QueryField;
import org.gcube.accounting.datamodel.query.QueryOperator;
import org.gcube.accounting.exception.NotFoundException;
import org.gcube.accounting.exception.QueryFormatException;

public class QueryClause {
    private String key;
    private QueryOperator operator;
    private String value;

    public QueryClause(String clause) throws QueryFormatException {
        this.parseClause(clause);
    }

    public QueryClause(String key, QueryOperator operator, String value) {
        this.key = key;
        this.operator = operator;
        this.value = value;
    }

    public QueryClause(QueryField key, QueryOperator operator, String value) {
        this(key.toString(), operator, value);
    }

    private void parseClause(String clause) throws QueryFormatException {
        Pattern pattern = Pattern.compile("^\\s*([:a-zA-Z0-9_]+)\\s*(=|!=|<>|<=|>=|>|<)\\s*(.+)\\s*$");
        Matcher matcher = pattern.matcher(clause);
        if (matcher.matches()) {
            this.key = matcher.group(1).trim();
            try {
                this.operator = QueryOperator.getOperator(matcher.group(2));
            }
            catch (NotFoundException e) {
                throw new QueryFormatException(e.getMessage());
            }
        } else {
            throw new QueryFormatException("unable to parse query clause: " + clause);
        }
        this.value = matcher.group(3).trim();
    }

    public String getKey() {
        return this.key;
    }

    public QueryOperator getOperator() {
        return this.operator;
    }

    public String getValue() {
        return this.value;
    }
}

