/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.ClusterDescription;
import com.mongodb.ServerAddress;
import com.mongodb.ServerDescription;
import java.util.List;

public class ReplicaSetStatus {
    private final ClusterDescription clusterDescription;

    ReplicaSetStatus(ClusterDescription clusterDescription) {
        this.clusterDescription = clusterDescription;
    }

    public String getName() {
        List<ServerDescription> any = this.clusterDescription.getAny();
        return any.isEmpty() ? null : any.get(0).getSetName();
    }

    public ServerAddress getMaster() {
        List<ServerDescription> primaries = this.clusterDescription.getPrimaries();
        return primaries.isEmpty() ? null : primaries.get(0).getAddress();
    }

    public boolean isMaster(ServerAddress serverAddress) {
        return this.getMaster().equals(serverAddress);
    }

    public int getMaxBsonObjectSize() {
        List<ServerDescription> primaries = this.clusterDescription.getPrimaries();
        return primaries.isEmpty() ? ServerDescription.getDefaultMaxDocumentSize() : primaries.get(0).getMaxDocumentSize();
    }

    public String toString() {
        return "ReplicaSetStatus{name=" + this.getName() + ", cluster=" + this.clusterDescription + '}';
    }
}

