/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.io.IOException;
import org.apache.activemq.command.BrokerId;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.NetworkBridgeFilter;
import org.apache.activemq.network.DemandForwardingBridgeSupport;
import org.apache.activemq.network.NetworkBridgeConfiguration;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.util.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DemandForwardingBridge
extends DemandForwardingBridgeSupport {
    private static final Log LOG = LogFactory.getLog(DemandForwardingBridge.class);
    protected final BrokerId[] remoteBrokerPath = new BrokerId[]{null};
    protected Object brokerInfoMutex = new Object();
    protected BrokerId remoteBrokerId;

    public DemandForwardingBridge(NetworkBridgeConfiguration configuration, Transport localBroker, Transport remoteBroker) {
        super(configuration, localBroker, remoteBroker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceRemoteBrokerInfo(Command command) throws IOException {
        Object object = this.brokerInfoMutex;
        synchronized (object) {
            BrokerInfo remoteBrokerInfo = (BrokerInfo)command;
            this.remoteBrokerPath[0] = this.remoteBrokerId = remoteBrokerInfo.getBrokerId();
            this.remoteBrokerName = remoteBrokerInfo.getBrokerName();
            if (this.localBrokerId != null && this.localBrokerId.equals(this.remoteBrokerId)) {
                LOG.info("Disconnecting loop back connection.");
                ServiceSupport.dispose(this);
            }
            LOG.debug("counting down remoteBrokerNameKnownLatch with: " + command);
            this.remoteBrokerNameKnownLatch.countDown();
        }
    }

    protected void addRemoteBrokerToBrokerPath(ConsumerInfo info) {
        info.setBrokerPath(this.appendToBrokerPath(info.getBrokerPath(), this.getRemoteBrokerPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceLocalBrokerInfo(Command command) throws InterruptedException {
        Object object = this.brokerInfoMutex;
        synchronized (object) {
            this.localBrokerPath[0] = this.localBrokerId = ((BrokerInfo)command).getBrokerId();
            if (this.remoteBrokerId != null && this.remoteBrokerId.equals(this.localBrokerId)) {
                LOG.info("Disconnecting loop back connection.");
                this.waitStarted();
                ServiceSupport.dispose(this);
            }
        }
    }

    protected NetworkBridgeFilter createNetworkBridgeFilter(ConsumerInfo info) throws IOException {
        return new NetworkBridgeFilter(this.remoteBrokerPath[0], this.configuration.getNetworkTTL());
    }

    protected BrokerId[] getRemoteBrokerPath() {
        return this.remoteBrokerPath;
    }
}

