/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.smsplugin.delegates.util;

import com.thoughtworks.xstream.XStream;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.field.StringField;
import java.net.URI;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.RemoteIterator;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.InfoObjectTree;

public class RSInfoObjectTreeIterator
implements RemoteIterator<InfoObjectTree> {
    protected GCUBELog logger = new GCUBELog(RSInfoObjectTreeIterator.class);
    protected Iterator<GenericRecord> rsIterator;
    protected XStream stream;
    protected String fieldName;
    protected ForwardReader<GenericRecord> reader;
    protected URI locator;

    public RSInfoObjectTreeIterator(String locator) throws GRS2ReaderException {
        this(URI.create(locator), "IO_TREE");
    }

    public RSInfoObjectTreeIterator(String locator, String fieldName) throws GRS2ReaderException {
        this(URI.create(locator), fieldName);
    }

    public RSInfoObjectTreeIterator(URI locator, String fieldName) throws GRS2ReaderException {
        this.locator = locator;
        this.reader = new ForwardReader(locator);
        this.reader.setIteratorTimeout(2L);
        this.reader.setIteratorTimeUnit(TimeUnit.MINUTES);
        this.rsIterator = this.reader.iterator();
        this.stream = new XStream();
        this.fieldName = fieldName;
    }

    public boolean hasNext() {
        boolean hasNext = this.rsIterator.hasNext();
        if (!hasNext) {
            this.close();
        }
        return hasNext;
    }

    public InfoObjectTree next() {
        GenericRecord record = this.rsIterator.next();
        try {
            StringField field = (StringField)record.getField(this.fieldName);
            String value = field.getPayload();
            return (InfoObjectTree)this.stream.fromXML(value);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error getting the record from RS", (Throwable)e);
            return null;
        }
    }

    public void close() {
        try {
            this.reader.close();
            this.logger.trace((Object)"closed SMS RS reader");
        }
        catch (GRS2ReaderException e) {
            this.logger.error((Object)"Error closing the SMS RS reader", (Throwable)e);
        }
    }

    public String locator() {
        return this.locator.toString();
    }
}

