/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.smsplugin.util;

import java.util.List;
import java.util.concurrent.Future;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.publisher.ISPublisher;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.GCUBESecurityManagerImpl;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.util.ISUtil;
import org.gcube.contentmanagement.contentmanager.smsplugin.util.SMSUtil;
import org.gcube.contentmanagement.contentmanager.stubs.CollectionReference;
import org.gcube.contentmanagement.contentmanager.stubs.calls.AdminCalls;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.NameAndType;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.PropertyDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.SMSPortType1PortType;

public class GCubeCollections {
    protected static final GCUBELog logger = new GCUBELog(GCubeCollections.class);

    public static List<CollectionReference> createGCubeCollection(boolean broadcast, String collectionName, String collectionDescription, boolean userCollection, boolean read, boolean write, GCUBEScope scope, GCUBESecurityManager ... securityManager) throws Exception {
        logger.trace((Object)"creating collection on sms");
        String collectionId = null;
        try {
            collectionId = GCubeCollections.createSMSCollection(collectionName, collectionDescription, scope, securityManager);
            logger.trace((Object)("collectionid: " + collectionId));
        }
        catch (Exception e) {
            logger.error((Object)"Failed collection creation on sms", (Throwable)e);
            throw new Exception("Failed collection creation on sms", e);
        }
        logger.trace((Object)"creating collection on CM");
        return SMSUtil.wrapCollection(scope, broadcast, collectionId, collectionDescription, userCollection, read, write);
    }

    protected static String createSMSCollection(String collectionName, String collectionDescription, GCUBEScope scope, GCUBESecurityManager ... securityManager) throws Exception {
        logger.debug((Object)("Creating new collection with name '" + collectionName + "'"));
        NameAndType createParameters = new NameAndType();
        createParameters.setName(collectionName);
        createParameters.setType("contentmanagement:collection");
        SMSPortType1PortType smsPortType1 = ISUtil.getStorageManagementPortType1(scope, GCubeCollections.getSecurityManager(securityManager));
        logger.trace((Object)"Calling the SMS service");
        String newCollectionID = smsPortType1.createInfoObject(createParameters);
        logger.trace((Object)("New collection id: " + newCollectionID));
        logger.trace((Object)"Setting flavour");
        smsPortType1.setStorageProperty(new PropertyDescription("contentmanagement:ObjectFlavour", newCollectionID, "xsd:string", "contentmanagement:Materialized"));
        smsPortType1.setStorageProperty(new PropertyDescription("contentmanagement:collectiondescription", newCollectionID, "xsd:string", collectionDescription));
        return newCollectionID;
    }

    public static List<Future<RPDocument>> deleteGCubeCollection(String collectionId, boolean deleteProfile, GCUBEScope scope, GCUBESecurityManager ... securityManager) throws Exception {
        GCubeCollections.deleteSMSCollection(collectionId, scope, securityManager);
        if (deleteProfile) {
            GCubeCollections.removeCollectionProfile(collectionId, scope, securityManager);
        }
        return AdminCalls.deleteAllManagers((String)collectionId, (GCUBEScope)scope, (GCUBESecurityManager[])securityManager);
    }

    protected static void deleteSMSCollection(String collectionId, GCUBEScope scope, GCUBESecurityManager ... securityManager) throws Exception {
        SMSPortType1PortType smsPortType1 = ISUtil.getStorageManagementPortType1(scope, GCubeCollections.getSecurityManager(securityManager));
        smsPortType1.removeInfoObject(collectionId);
    }

    protected static void removeCollectionProfile(String collectionId, GCUBEScope scope, GCUBESecurityManager ... securityManager) throws Exception {
        ISPublisher publisher = (ISPublisher)GHNContext.getImplementation(ISPublisher.class);
        publisher.removeGCUBEResource(collectionId, "GenericResource", scope, GCubeCollections.getSecurityManager(securityManager));
    }

    protected static GCUBESecurityManager getSecurityManager(GCUBESecurityManager ... securityManager) {
        if (securityManager != null && securityManager.length > 0) {
            return securityManager[0];
        }
        return new GCUBESecurityManagerImpl(){

            public boolean isSecurityEnabled() {
                return false;
            }
        };
    }
}

