/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.smsplugin.delegates;

import java.util.Timer;
import java.util.TimerTask;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.plugin.delegates.Collection;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.ReadManager;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.WriteManager;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.util.DynamicPropertyUpdateTask;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.util.SMSCollectionInfo;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.util.SMSInterface;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.util.SMSInterfaceImpl;
import org.gcube.contentmanagement.contentmanager.smsplugin.types.SMSDelegateType;
import org.gcube.contentmanagement.contentmanager.smsplugin.types.SMSWrapCollection;

public class SMSCollection
extends Collection {
    private static final long serialVersionUID = 558032201527763425L;
    protected static final int PROPERTIES_UPDATE_TASK_START_DELAY = 60000;
    protected static final int PROPERTIES_UPDATE_TASK_DELAY = 300000;
    protected transient GCUBELog logger;
    protected transient SMSInterface smsInterface;
    protected transient Timer propertiesUpdateTaskManager;
    protected transient SMSWrapCollection wrapCollectionParameters;

    public SMSCollection(String id, SMSWrapCollection wrapCollectionParameters) throws IllegalArgumentException {
        super(id);
        this.wrapCollectionParameters = wrapCollectionParameters;
        this.logger = new GCUBELog(SMSCollection.class);
    }

    public void initialise() throws Exception {
        this.getSMSInterface();
        this.createDelegates();
        this.setupCollectionProperties();
        this.initializePropertiesUpdater();
        this.logger.info((Object)("Collection " + this.getID() + " initialized."));
    }

    public void onLoad() throws Exception {
        this.logger = new GCUBELog(SMSCollection.class);
        this.getSMSInterface();
        this.initializePropertiesUpdater();
        this.logger.info((Object)("Collection " + this.getID() + " re-initialized."));
    }

    public SMSInterface getSmsInterface() {
        return this.smsInterface;
    }

    protected void getSMSInterface() throws Exception {
        this.logger.trace((Object)"getting the SMS interface");
        try {
            this.smsInterface = SMSInterfaceImpl.getInstance();
        }
        catch (Exception e) {
            this.logger.error((Object)"Error getting the SMS interface", (Throwable)e);
            throw new Exception("Error getting the SMS repository interface", e);
        }
    }

    protected void setupCollectionProperties() throws Exception {
        SMSCollectionInfo collectionInfo = this.getSMSCollectionInfo();
        this.setName(collectionInfo.getName());
        String description = this.wrapCollectionParameters.getCollectionDescription() != null ? this.wrapCollectionParameters.getCollectionDescription() : collectionInfo.getDescription();
        this.setDescription(description);
        this.setCreationTime(collectionInfo.getCreationTime());
        this.setUser(this.wrapCollectionParameters.isUserCollection());
        this.updateDynamicProperties(collectionInfo);
    }

    protected void createDelegates() throws Exception {
        SMSDelegateType delegateType = this.wrapCollectionParameters.getDelegateType();
        this.logger.trace((Object)("delegate type: " + (Object)((Object)delegateType)));
        switch (delegateType) {
            case READ: {
                this.createReader();
                break;
            }
            case WRITE: {
                this.createWriter();
                break;
            }
            case FULL: {
                this.createReader();
                this.createWriter();
            }
        }
        this.logger.debug((Object)"delegates created");
    }

    protected void createReader() {
        ReadManager readerManager = new ReadManager();
        this.setReader(readerManager);
    }

    protected void createWriter() {
        WriteManager writeManager = new WriteManager();
        this.setWriter(writeManager);
    }

    protected void initializePropertiesUpdater() {
        this.logger.trace((Object)"initializing properties updater");
        this.logger.warn((Object)"property updater disabled for debugging purpose");
        DynamicPropertyUpdateTask propertiesUpdater = new DynamicPropertyUpdateTask(this);
        this.propertiesUpdateTaskManager = new Timer();
        this.propertiesUpdateTaskManager.schedule((TimerTask)propertiesUpdater, 60000L, 300000L);
        this.logger.trace((Object)"Properties updater initializied START_DELAY:_60000 UPDATE_DELAY: 300000");
    }

    public void updateDynamicProperties() throws Exception {
        SMSCollectionInfo collectionInfo = this.getSMSCollectionInfo();
        this.updateDynamicProperties(collectionInfo);
    }

    public void updateDynamicProperties(SMSCollectionInfo collectionInfo) {
        this.setLastUpdate(collectionInfo.getLastUpdate());
        this.setCardinality(collectionInfo.getCardinality());
    }

    public SMSCollectionInfo getSMSCollectionInfo() throws Exception {
        return this.smsInterface.getCollectionInfo(this.getID());
    }
}

