/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.smsplugin.delegates;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.GDocConversionUtil;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Predicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.TreePredicate;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.AlternativeProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.AnnotationProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.DocumentProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.MetadataProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.PartProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projections;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.Property;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.PropertyTypes;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.OrCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.PropertyCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.StringPropertyValueCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.InformationObjectTreeResponse;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.TreeWalkRule;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.content.NoRawContent;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.content.RawContentInMessageConditional;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.content.RawContentLocationConfig;

public class ReadUtil {
    protected static final GCUBELog logger = new GCUBELog(ReadUtil.class);
    public static final InformationObjectTreeResponse COMPLETE_TREE = new InformationObjectTreeResponse((RawContentLocationConfig)NoRawContent.instance(), Collections.emptyList(), 1, Collections.emptyList());
    public static final TreeWalkRule PART_WALK_RULE = new TreeWalkRule("contentmanagement:has-part", null);
    public static final TreeWalkRule ALTERNATIVE_WALK_RULE = new TreeWalkRule("contentmanagement:is-represented-by", null);
    public static final TreeWalkRule METADATA_WALK_RULE = new TreeWalkRule("contentmanagement:is-described-by", "is-described-by");
    public static final TreeWalkRule ANNOTATION_WALK_RULE = new TreeWalkRule("contentmanagement:is-described-by", "contentmanagement:is-annotated-by");

    public static InformationObjectTreeResponse createResponseConfig(DocumentProjection projection) {
        logger.trace((Object)"createResponseConfig");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("projection: " + projection));
        }
        if (projection == null) {
            return COMPLETE_TREE;
        }
        projection = ReadUtil.makePositive(projection);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("positive projection: " + projection));
        }
        List<TreeWalkRule> rules = ReadUtil.calculateWalkingRules(projection);
        PropertyCondition propertyCondition = ReadUtil.calculatePropertyConditionForContentLocation(projection);
        NoRawContent contentLocation = NoRawContent.instance();
        if (propertyCondition != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("propertyCondition not null: " + propertyCondition));
            }
            contentLocation = new RawContentInMessageConditional(propertyCondition);
        }
        return new InformationObjectTreeResponse((RawContentLocationConfig)contentLocation, rules, 1, Collections.emptyList());
    }

    protected static DocumentProjection makePositive(DocumentProjection projection) {
        Predicate predicate;
        if (projection.equals((Object)Projections.document())) {
            return (DocumentProjection)((DocumentProjection)((DocumentProjection)((DocumentProjection)((DocumentProjection)projection.with((Property)Projections.PART, (Projection)Projections.part().etc())).with((Property)Projections.ALTERNATIVE, (Projection)Projections.alternative().etc())).with((Property)Projections.METADATA, (Projection)Projections.metadata().etc())).with((Property)Projections.ANNOTATION, (Projection)Projections.annotation().etc())).etc();
        }
        if (projection.isConstrained((Property)Projections.PART)) {
            predicate = (Predicate)projection.constraints().get(Projections.PART);
            if (Projections.part().predicate().equals((Object)predicate)) {
                projection = (DocumentProjection)projection.with((Property)Projections.PART, (Projection)Projections.part().etc());
            }
        }
        if (projection.isConstrained((Property)Projections.ALTERNATIVE)) {
            predicate = (Predicate)projection.constraints().get(Projections.ALTERNATIVE);
            if (Projections.alternative().predicate().equals((Object)predicate)) {
                projection = (DocumentProjection)projection.with((Property)Projections.ALTERNATIVE, (Projection)Projections.alternative().etc());
            }
        }
        if (projection.isConstrained((Property)Projections.METADATA)) {
            predicate = (Predicate)projection.constraints().get(Projections.METADATA);
            if (Projections.metadata().predicate().equals((Object)predicate)) {
                projection = (DocumentProjection)projection.with((Property)Projections.METADATA, (Projection)Projections.metadata().etc());
            }
        }
        if (projection.isConstrained((Property)Projections.ANNOTATION)) {
            predicate = (Predicate)projection.constraints().get(Projections.ANNOTATION);
            if (Projections.annotation().predicate().equals((Object)predicate)) {
                projection = (DocumentProjection)projection.with((Property)Projections.ANNOTATION, (Projection)Projections.annotation().etc());
            }
        }
        return projection;
    }

    public static List<TreeWalkRule> calculateWalkingRules(DocumentProjection projection) {
        logger.trace((Object)"Calculating walking rules");
        if (projection == null) {
            return Collections.emptyList();
        }
        LinkedList<TreeWalkRule> rules = new LinkedList<TreeWalkRule>();
        if (projection.isConstrained((Property)Projections.PART)) {
            rules.add(PART_WALK_RULE);
        }
        if (projection.isConstrained((Property)Projections.ALTERNATIVE)) {
            rules.add(ALTERNATIVE_WALK_RULE);
        }
        if (projection.isConstrained((Property)Projections.METADATA)) {
            rules.add(METADATA_WALK_RULE);
        }
        if (projection.isConstrained((Property)Projections.ANNOTATION)) {
            rules.add(ANNOTATION_WALK_RULE);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Rules:");
            for (TreeWalkRule rule : rules) {
                logger.trace((Object)("Rule: " + rule));
            }
        }
        return rules;
    }

    public static PropertyCondition calculatePropertyConditionForContentLocation(DocumentProjection projection) {
        AnnotationProjection annotationProjection;
        MetadataProjection metadataProjection;
        AlternativeProjection alternativeProjection;
        Predicate predicate;
        PartProjection partProjection;
        logger.trace((Object)"Calculating property conditions");
        PropertyCondition propertyCondition = null;
        LinkedList<Object> conditions = new LinkedList<Object>();
        if (projection.isConstrained((Property)Projections.PART) && (partProjection = new PartProjection((TreePredicate)(predicate = (Predicate)projection.constraints().get(Projections.PART)))).isIncluded((Property)Projections.BYTESTREAM)) {
            conditions.add(ReadUtil.calculatePropertyCondition(Projections.PART));
        }
        if (projection.isConstrained((Property)Projections.ALTERNATIVE) && (alternativeProjection = new AlternativeProjection((TreePredicate)(predicate = (Predicate)projection.constraints().get(Projections.ALTERNATIVE)))).isIncluded((Property)Projections.BYTESTREAM)) {
            conditions.add(ReadUtil.calculatePropertyCondition(Projections.ALTERNATIVE));
        }
        if (projection.isConstrained((Property)Projections.METADATA) && (metadataProjection = new MetadataProjection((TreePredicate)(predicate = (Predicate)projection.constraints().get(Projections.METADATA)))).isIncluded((Property)Projections.BYTESTREAM)) {
            conditions.add(ReadUtil.calculatePropertyCondition(Projections.METADATA));
        }
        if (projection.isConstrained((Property)Projections.ANNOTATION) && (annotationProjection = new AnnotationProjection((TreePredicate)(predicate = (Predicate)projection.constraints().get(Projections.ANNOTATION)))).isIncluded((Property)Projections.BYTESTREAM)) {
            conditions.add(ReadUtil.calculatePropertyCondition(Projections.ANNOTATION));
        }
        if (projection.isIncluded((Property)Projections.BYTESTREAM)) {
            conditions.add(new StringPropertyValueCondition("contentmanagement:ObjectType", "contentmanagement:document"));
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Conditions:");
            for (PropertyCondition propertyCondition2 : conditions) {
                logger.trace((Object)("Condition: " + propertyCondition2));
            }
        }
        for (PropertyCondition propertyCondition3 : conditions) {
            if (propertyCondition != null) {
                propertyCondition = new OrCondition(propertyCondition, propertyCondition3);
                continue;
            }
            propertyCondition = propertyCondition3;
        }
        return propertyCondition;
    }

    public static PropertyCondition calculatePropertyCondition(PropertyTypes.DocumentProperty label) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("label: " + label));
        }
        String documentType = GDocConversionUtil.getDocumentType(label);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("documentType: " + documentType));
        }
        return new StringPropertyValueCondition("contentmanagement:ObjectType", documentType);
    }
}

