/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.oaiplugin.delegates;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.contentmanagement.contentmanager.oaiplugin.GCUBEDocumentIterator;
import org.gcube.contentmanagement.contentmanager.oaiplugin.MetadataFormat;
import org.gcube.contentmanagement.contentmanager.oaiplugin.delegates.ReadManager;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.RemoteIterator;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Predicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.GDoc;
import uiuc.oai.OAIRecord;
import uiuc.oai.OAIRecordList;

public class ReadManagerFromListOfSets
extends ReadManager {
    private static final long serialVersionUID = 517340467744352137L;
    private List<String> listSets;

    public ReadManagerFromListOfSets(String oid, String repositoryURI, MetadataFormat metadataFormat, String contentXpath, List<String> listSets, String ... alternativesXPath) {
        super(repositoryURI, metadataFormat, contentXpath, alternativesXPath);
        this.listSets = listSets;
    }

    @Override
    public RemoteIterator<GDoc> get(Predicate projection) throws Exception, GCUBEException {
        final ArrayList<GCUBEDocumentIterator> listIterators = new ArrayList<GCUBEDocumentIterator>(this.listSets.size());
        for (String set : this.listSets) {
            listIterators.add(new GCUBEDocumentIterator(this.getOAIHarvester().listRecords(this.getDefaultMdFormat().getPrefix(), null, null, set), this, projection));
        }
        return new RemoteIterator<GDoc>(){
            int listIteratorIndex = 0;

            public boolean hasNext() {
                if (((GCUBEDocumentIterator)listIterators.get(this.listIteratorIndex)).hasNext()) {
                    return true;
                }
                if (this.listIteratorIndex < listIterators.size() - 1) {
                    ++this.listIteratorIndex;
                    return this.hasNext();
                }
                return false;
            }

            public GDoc next() {
                return ((GCUBEDocumentIterator)listIterators.get(this.listIteratorIndex)).next();
            }

            public void remove() {
            }

            public void close() {
            }

            public String locator() {
                return "locator";
            }
        };
    }

    @Override
    public GDoc internalGet(String id) throws Exception {
        OAIRecord record = this.getOAIHarvester().getRecord(id, this.getDefaultMdFormat().getPrefix());
        boolean containsSet = false;
        for (int i = 0; i < record.getSetSpecCount(); ++i) {
            if (!this.listSets.contains(record.getSetSpec(i))) continue;
            containsSet = true;
            break;
        }
        if (!containsSet) {
            throw new Exception("the object is not in the collection");
        }
        return this.extractDoc(record, null);
    }

    @Override
    protected Iterator<OAIRecord> getList() throws Exception {
        return new Iterator<OAIRecord>(){
            boolean first = true;
            int listIndex = 0;
            OAIRecordList listRecord;

            @Override
            public boolean hasNext() {
                try {
                    if (this.first) {
                        this.listRecord = ReadManagerFromListOfSets.this.getOAIHarvester().listIdentifiers(null, null, (String)ReadManagerFromListOfSets.this.listSets.get(0), ReadManagerFromListOfSets.this.getDefaultMdFormat().getPrefix());
                        this.first = false;
                    }
                    if (this.listRecord.moreItems()) {
                        this.listRecord.moveNext();
                        return true;
                    }
                    if (this.listIndex < ReadManagerFromListOfSets.this.listSets.size() - 1) {
                        ++this.listIndex;
                        this.listRecord = ReadManagerFromListOfSets.this.getOAIHarvester().listIdentifiers(null, null, (String)ReadManagerFromListOfSets.this.listSets.get(this.listIndex), ReadManagerFromListOfSets.this.getDefaultMdFormat().getPrefix());
                        return this.hasNext();
                    }
                    return false;
                }
                catch (Exception e) {
                    ReadManager.logger.error((Object)"error getting list of record");
                    return false;
                }
            }

            @Override
            public OAIRecord next() {
                return this.listRecord.getCurrentItem();
            }

            @Override
            public void remove() {
            }
        };
    }
}

