/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.oaiplugin.delegates;

import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.axis.encoding.Base64;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.oaiplugin.GetIDsIterator;
import org.gcube.contentmanagement.contentmanager.oaiplugin.MetadataFormat;
import org.gcube.contentmanagement.contentmanager.oaiplugin.tasks.UpdatePair;
import org.gcube.contentmanagement.contentmanager.plugin.delegates.ReadDelegate;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.RemoteIterator;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Predicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Edge;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.GDoc;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.InnerNode;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Node;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Nodes;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import uiuc.oai.OAIException;
import uiuc.oai.OAIRecord;
import uiuc.oai.OAIRepository;

public abstract class ReadManager
extends ReadDelegate {
    private static final long serialVersionUID = 1L;
    private String repositoryURI;
    private MetadataFormat defaultMdFormat;
    private String contentXpath;
    private String[] alternativesXPath;
    private String titleNameXPath;
    transient OAIRepository oaiRepository = null;
    protected static GCUBELog logger = new GCUBELog(ReadManager.class);
    private transient DocumentBuilder documentBuilder = null;
    private transient Transformer transformer = null;

    public ReadManager(String repositoryURI, MetadataFormat metadataFormat, String contentXpath, String[] alternativesXPath) {
        this.repositoryURI = repositoryURI;
        this.defaultMdFormat = metadataFormat;
        this.contentXpath = contentXpath;
        this.alternativesXPath = alternativesXPath;
        this.titleNameXPath = null;
    }

    private DocumentBuilder getDocumentBuilder() throws Exception {
        if (this.documentBuilder == null) {
            this.documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        return this.documentBuilder;
    }

    public String getTitleNameXPath() {
        return this.titleNameXPath;
    }

    public void setTitleNameXPath(String titleNameXPath) {
        this.titleNameXPath = titleNameXPath;
    }

    private Transformer getTransformer() throws Exception {
        if (this.transformer == null) {
            this.transformer = TransformerFactory.newInstance().newTransformer();
            this.transformer.setOutputProperty("encoding", "utf-8");
            this.transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        return this.transformer;
    }

    public OAIRepository getOAIHarvester() {
        if (this.oaiRepository == null) {
            this.oaiRepository = new OAIRepository();
            this.oaiRepository.setValidation(2);
            try {
                this.oaiRepository.setBaseURL(this.repositoryURI);
            }
            catch (OAIException e) {
                logger.error((Object)"something failed retrieving the OAIHarvester", (Throwable)e);
                return null;
            }
        }
        return this.oaiRepository;
    }

    public Iterator<GDoc> get(Iterator<String> iterator, Predicate projection) throws Exception, GCUBEException {
        try {
            return new GetIDsIterator(iterator, this, projection);
        }
        catch (Exception e) {
            logger.error((Object)"error in getDocuments", (Throwable)e);
            throw e;
        }
    }

    protected abstract Iterator<OAIRecord> getList() throws Exception;

    public abstract RemoteIterator<GDoc> get(Predicate var1) throws Exception, GCUBEException;

    public UpdatePair computeUpdate() throws Exception {
        Iterator<OAIRecord> recordIterator = this.getList();
        Calendar lastUpdate = null;
        long cardinality = 0L;
        while (recordIterator.hasNext()) {
            OAIRecord record = recordIterator.next();
            if (record == null || !record.isRecordValid() || record.deleted()) continue;
            ++cardinality;
            Calendar tempUpdate = this.getDate(record.getDatestamp());
            if (lastUpdate != null && !tempUpdate.after(lastUpdate)) continue;
            lastUpdate = tempUpdate;
        }
        return new UpdatePair(lastUpdate, cardinality);
    }

    public GDoc get(String id, Predicate projection) throws Exception, GCUBEException {
        logger.trace((Object)("retrieving document with id " + id + " and projection " + projection));
        GDoc doc = this.get(this.idDecoder(id));
        if (projection != null) {
            projection.prune((Node)doc);
        }
        return doc;
    }

    public MetadataFormat getDefaultMdFormat() {
        return this.defaultMdFormat;
    }

    public void setDefaultMdFormat(MetadataFormat defaultMdFormat) {
        this.defaultMdFormat = defaultMdFormat;
    }

    public GDoc get(String id) throws Exception {
        return this.internalGet(this.idDecoder(id));
    }

    protected abstract GDoc internalGet(String var1) throws Exception;

    public GDoc extractDoc(OAIRecord record, Predicate projection) throws Exception {
        NodeList nl;
        XPath xPath;
        XPathFactory factory;
        Edge nameEdge;
        Edge contentEdge;
        Edge lengthEdge;
        Edge mimeTypeEdge;
        Document metadataDocument;
        Edge lastUpdateTimeEdge;
        Edge creationTimeEdge;
        GDoc doc;
        long start;
        block19: {
            start = System.currentTimeMillis();
            String recordIdentifier = this.idEncoder(record.getIdentifier());
            doc = new GDoc(recordIdentifier);
            doc.collectionID(this.getCollection().getID());
            try {
                creationTimeEdge = Nodes.e((String)"creationTime", (Object)this.getDate(record.getDatestamp()));
                lastUpdateTimeEdge = Nodes.e((String)"lastUpdateTime", (Object)this.getDate(record.getDatestamp()));
            }
            catch (Exception e) {
                logger.error((Object)"cannot retrieve the CreationTime", (Throwable)e);
                creationTimeEdge = Nodes.e((String)"creationTime", null);
                lastUpdateTimeEdge = Nodes.e((String)"lastUpdateTime", null);
            }
            doc.add(new Edge[]{creationTimeEdge, lastUpdateTimeEdge});
            long startmetadata = System.currentTimeMillis();
            StringWriter metadataString = new StringWriter();
            this.getTransformer().transform(new DOMSource(record.getMetadata()), new StreamResult(metadataString));
            try {
                doc.add(Arrays.asList(this.createMetadataEdge(metadataString.toString(), this.defaultMdFormat.getPrefix(), this.defaultMdFormat.getSchema(), recordIdentifier, creationTimeEdge, lastUpdateTimeEdge)));
            }
            catch (Exception te) {
                logger.warn((Object)"error retrieving the metadata", (Throwable)te);
            }
            long startparse = System.currentTimeMillis();
            metadataDocument = this.getDocumentBuilder().parse(new InputSource(new StringReader(metadataString.toString())));
            logger.trace((Object)("time spent to parse the doc " + (System.currentTimeMillis() - startparse)));
            mimeTypeEdge = Nodes.e((String)"mimeType", (Object)"");
            lengthEdge = Nodes.e((String)"length", (Object)0);
            contentEdge = Nodes.e((String)"url", (Object)"");
            nameEdge = Nodes.e((String)"name", (Object)recordIdentifier);
            if (this.contentXpath != null) {
                try {
                    long startcontent = System.currentTimeMillis();
                    factory = XPathFactory.newInstance();
                    xPath = factory.newXPath();
                    nl = (NodeList)xPath.evaluate(this.contentXpath, metadataDocument, XPathConstants.NODESET);
                    if (nl.item(0) == null) break block19;
                    long starttxtContent = System.currentTimeMillis();
                    String contentUri = nl.item(0).getTextContent();
                    logger.trace((Object)("time spent to get text content " + (System.currentTimeMillis() - starttxtContent)));
                    logger.trace((Object)(" content uri is " + contentUri));
                    long startrest = System.currentTimeMillis();
                    try {
                        mimeTypeEdge = Nodes.e((String)"mimeType", (Object)"text/uri-list");
                    }
                    catch (Exception e) {
                        logger.warn((Object)("impossible to retrieve the mimeType for doc " + record.getIdentifier()));
                    }
                    try {
                        lengthEdge = Nodes.e((String)"length", (Object)contentUri.getBytes("utf-8").length);
                    }
                    catch (Exception e) {
                        logger.warn((Object)("impossible to retrieve the content length for doc " + record.getIdentifier()));
                    }
                    contentEdge = Nodes.e((String)"bytestream", (Object)Base64.encode((byte[])contentUri.getBytes()));
                }
                catch (Throwable e) {
                    logger.error((Object)("impossible to retrieve content for document " + record.getIdentifier()), e);
                }
            }
        }
        long starttitle = System.currentTimeMillis();
        if (this.titleNameXPath != null) {
            try {
                factory = XPathFactory.newInstance();
                xPath = factory.newXPath();
                nl = (NodeList)xPath.evaluate(this.titleNameXPath, metadataDocument, XPathConstants.NODESET);
                if (nl.item(0) != null) {
                    String recordName = nl.item(0).getTextContent();
                    nameEdge = Nodes.e((String)"name", (Object)recordName);
                }
            }
            catch (Exception e) {
                logger.warn((Object)"cannot calculate the title of the record", (Throwable)e);
            }
        }
        doc.add(new Edge[]{mimeTypeEdge, lengthEdge, contentEdge, nameEdge});
        long startalternatives = System.currentTimeMillis();
        logger.trace((Object)("alternativeXPath is null?" + (this.alternativesXPath == null)));
        logger.trace((Object)("alternativeXPath is more than 0?" + (this.alternativesXPath != null && this.alternativesXPath.length > 0)));
        if (this.alternativesXPath != null && this.alternativesXPath.length > 0) {
            for (int i = 0; i < this.alternativesXPath.length; ++i) {
                try {
                    doc.add(this.createAlternatives(metadataDocument, i, this.alternativesXPath[i], creationTimeEdge, lastUpdateTimeEdge));
                    continue;
                }
                catch (Exception te) {
                    logger.warn((Object)("error retrieving the alternatives with path " + this.alternativesXPath[i]), (Throwable)te);
                }
            }
        }
        logger.trace((Object)("time spent to retrieve alternatives " + (System.currentTimeMillis() - startalternatives)));
        logger.trace((Object)("time spent to extract the doc is " + (System.currentTimeMillis() - start)));
        return doc;
    }

    private Edge createMetadataEdge(String metadata, String prefix, String schema, String identifier, Edge createTimeEdge, Edge lastUpdateTimeEdge) throws Exception {
        return Nodes.e((String)"isDescribedBy", (Node)new InnerNode(identifier + "-" + prefix, new Edge[]{Nodes.e((String)"mimeType", (Object)"text/xml"), Nodes.e((String)"length", (Object)metadata.length()), Nodes.e((String)"language", (Object)"unknown"), Nodes.e((String)"schemaName", (Object)prefix), Nodes.e((String)"schemaURI", (Object)schema), Nodes.e((String)"bytestream", (Object)Base64.encode((byte[])metadata.getBytes("utf-8"))), createTimeEdge, lastUpdateTimeEdge}));
    }

    private List<Edge> createAlternatives(Document metadataDocument, int identifier, String xPathExpression, Edge createTimeEdge, Edge lastUpdateTimeEdge) throws Exception {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        NodeList nl = (NodeList)xPath.evaluate(xPathExpression, metadataDocument, XPathConstants.NODESET);
        ArrayList<Edge> edgeList = new ArrayList<Edge>();
        for (int i = 0; i < nl.getLength(); ++i) {
            String alternativeUri = nl.item(i).getTextContent();
            Edge mimeTypeEdge = Nodes.e((String)"mimeType", (Object)"none");
            Edge lengthEdge = Nodes.e((String)"length", (Object)"none");
            URI uri = new URI(alternativeUri);
            URLConnection urlConnection = uri.toURL().openConnection();
            try {
                mimeTypeEdge = Nodes.e((String)"mimeType", (Object)urlConnection.getContentType());
            }
            catch (Exception e) {
                logger.warn((Object)"impossible to retrieve the mimeType for alternative");
            }
            try {
                lengthEdge = Nodes.e((String)"length", (Object)urlConnection.getContentLength());
            }
            catch (Exception e) {
                logger.warn((Object)"impossible to retrieve the content length for alternative");
            }
            edgeList.add(Nodes.e((String)"hasAlternative", (Node)Nodes.n((String)(identifier + "-alternative-" + i), (Edge[])new Edge[]{mimeTypeEdge, lengthEdge, Nodes.e((String)"name", (Object)(identifier + "-" + i)), Nodes.e((String)"url", (Object)alternativeUri), createTimeEdge, lastUpdateTimeEdge})));
        }
        return edgeList;
    }

    private Calendar getDate(String datestamp) throws Exception {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            dateFormat.parse(datestamp);
            return dateFormat.getCalendar();
        }
        catch (Exception e) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            dateFormat.parse(datestamp);
            return dateFormat.getCalendar();
        }
    }

    protected String idEncoder(String original) {
        return original.replaceAll("/", "124sep47sep35");
    }

    protected String idDecoder(String original) {
        return original.replaceAll("124sep47sep35", "/");
    }
}

