/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.lexicalmatcher.utils;

public class DistanceCalculator {
    private int Minimum(int a, int b, int c) {
        int mi = a;
        if (b < mi) {
            mi = b;
        }
        if (c < mi) {
            mi = c;
        }
        return mi;
    }

    public int LD(String s, String t) {
        int j;
        int i;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            char s_i = s.charAt(i - 1);
            for (j = 1; j <= m; ++j) {
                char t_j = t.charAt(j - 1);
                int cost = s_i == t_j ? 0 : 1;
                d[i][j] = this.Minimum(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + cost);
            }
        }
        return d[n][m];
    }

    public double CD(boolean useSimpleDistance, String h, String t) {
        return this.CD(useSimpleDistance, h, t, false, false);
    }

    public double CD(boolean useSimpleDistance, String h, String t, boolean ignoreCase, boolean boostMatch) {
        double distance = 0.0;
        if (h == null && t == null) {
            distance = 1.0;
        } else if (h != null && t != null) {
            h = this.treatString(h, ignoreCase);
            t = this.treatString(t, ignoreCase);
            int lt = t.length();
            int lh = h.length();
            double matchFactor = 1.5;
            if (boostMatch) {
                matchFactor = 2.0;
            }
            if (lt == 0 && lh != 0 || lt != 0 && lh == 0) {
                distance = 0.0;
            } else if (h.equalsIgnoreCase(t)) {
                distance = 1.0;
            } else if (useSimpleDistance) {
                distance = 0.0;
            } else if (t.contains(h)) {
                String treatedT = t.replace(h, "");
                double percentage = 1.0 - (double)treatedT.length() / (double)lt;
                distance = percentage = Math.min(percentage * matchFactor, 0.98);
            } else if (h.contains(t)) {
                String treatedH = h.replace(t, "");
                double percentage = 1.0 - (double)treatedH.length() / (double)lh;
                distance = percentage = Math.min(percentage * matchFactor, 0.98);
            } else {
                int levenDist = this.LD(h, t);
                int maxlen = Math.max(lh, lt);
                distance = 1.0 - (double)levenDist / (double)maxlen;
            }
        }
        return distance;
    }

    private String treatString(String h, boolean ignoreCase) {
        h = h.replaceAll("[!\"#$%&'()*+,./:;<=>?@\\^_`{|}~-]", "");
        h = h.replaceAll("[ ]+", " ");
        h = h.trim();
        if (ignoreCase) {
            h = h.toLowerCase();
        }
        return h;
    }

    public static void main(String[] args) {
        String h = "Mediteranean";
        String t = "Mediterranean horse mackerel";
        DistanceCalculator d = new DistanceCalculator();
        double cd = d.CD(false, h, t, true, true);
        System.out.println("Distance between " + h + " and " + t + " : " + cd);
    }
}

