/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.widget;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class PLAF {
    private static UIManager.LookAndFeelInfo[] plafInfo = UIManager.getInstalledLookAndFeels();
    private JComponent tree;
    private boolean debug = false;

    public PLAF(JComponent tree) {
        this.tree = tree;
    }

    public void addToMenu(JMenu menu) {
        if (this.debug) {
            System.out.println("PLAF LookAndFeelInfo  ");
        }
        for (int i = 0; i < plafInfo.length; ++i) {
            this.addToMenu(plafInfo[i].getName(), plafInfo[i].getClassName(), menu);
        }
        this.addToMenu("Plastic", "com.jgoodies.plaf.plastic.PlasticLookAndFeel", menu);
        this.addToMenu("Plastic3D", "com.jgoodies.plaf.plastic.Plastic3DLookAndFeel", menu);
        this.addToMenu("PlasticXP", "com.jgoodies.plaf.plastic.PlasticXPLookAndFeel", menu);
        this.addToMenu("JGoodiesWindows", "com.jgoodies.plaf.windows.ExtWindowsLookAndFeel", menu);
    }

    private void addToMenu(String name, String className, JMenu menu) {
        if (this.debug) {
            System.out.println("PLAF LookAndFeelInfo  " + className);
        }
        boolean isSupported = true;
        try {
            Class<?> cl = Class.forName(className);
            LookAndFeel lf = (LookAndFeel)cl.newInstance();
            if (!lf.isSupportedLookAndFeel()) {
                isSupported = false;
            }
        }
        catch (Throwable t) {
            isSupported = false;
        }
        PLAFAction act = new PLAFAction(name, className);
        JMenuItem mi = menu.add(act);
        if (!isSupported) {
            mi.setEnabled(false);
        }
    }

    private void configureLF() {
    }

    private class PLAFAction
    extends AbstractAction {
        String plafClassName;

        PLAFAction(String name, String plafClassName) {
            this.plafClassName = plafClassName;
            this.putValue("Name", name);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                UIManager.setLookAndFeel(this.plafClassName);
            }
            catch (Exception ex) {
                System.out.println(ex);
                return;
            }
            SwingUtilities.updateComponentTreeUI(PLAF.this.tree);
        }
    }
}

