/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.nexrad2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.nexrad2.Level2Record;
import ucar.nc2.iosp.nexrad2.Level2VolumeScan;
import ucar.nc2.iosp.nexrad2.NexradStationDB;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.io.RandomAccessFile;

public class Nexrad2IOServiceProvider
extends AbstractIOServiceProvider {
    private static Logger logger = LoggerFactory.getLogger(Nexrad2IOServiceProvider.class);
    private static final int MISSING_INT = -9999;
    private static final float MISSING_FLOAT = Float.NaN;
    private Level2VolumeScan volScan;
    private double radarRadius;
    private Variable v0;
    private Variable v1;
    private DateFormatter formatter = new DateFormatter();
    private boolean overMidNight = false;

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        try {
            raf.seek(0L);
            byte[] b = new byte[8];
            raf.read(b);
            String test = new String(b);
            return test.equals("ARCHIVE2") || test.equals("AR2V0001") || test.equals("AR2V0003") || test.equals("AR2V0004") || test.equals("AR2V0002") || test.equals("AR2V0006") || test.equals("AR2V0007");
        }
        catch (IOException ioe) {
            return false;
        }
    }

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        List<List<Level2Record>> gps;
        NexradStationDB.init();
        this.volScan = new Level2VolumeScan(raf, cancelTask);
        if (this.volScan.hasDifferentDopplarResolutions()) {
            throw new IllegalStateException("volScan.hasDifferentDopplarResolutions");
        }
        if (this.volScan.hasHighResolutions(0)) {
            if (this.volScan.getHighResReflectivityGroups() != null) {
                this.makeVariable2(ncfile, 5, "Reflectivity", "Reflectivity", "R", this.volScan);
            }
            if (this.volScan.getHighResVelocityGroups() != null) {
                this.makeVariable2(ncfile, 6, "RadialVelocity", "Radial Velocity", "V", this.volScan);
            }
            if (this.volScan.getHighResSpectrumGroups() != null) {
                gps = this.volScan.getHighResSpectrumGroups();
                List<Level2Record> gp = gps.get(0);
                Level2Record record = gp.get(0);
                if (this.v1 != null) {
                    this.makeVariableNoCoords(ncfile, 7, "SpectrumWidth_HI", "Radial Spectrum_HI", this.v1, record);
                }
                if (this.v0 != null) {
                    this.makeVariableNoCoords(ncfile, 7, "SpectrumWidth", "Radial Spectrum", this.v0, record);
                }
            }
        }
        if ((gps = this.volScan.getHighResDiffReflectGroups()) != null) {
            this.makeVariable2(ncfile, 8, "DifferentialReflectivity", "Differential Reflectivity", "D", this.volScan);
        }
        if ((gps = this.volScan.getHighResCoeffocientGroups()) != null) {
            this.makeVariable2(ncfile, 10, "CorrelationCoefficient", "Correlation Coefficient", "C", this.volScan);
        }
        if ((gps = this.volScan.getHighResDiffPhaseGroups()) != null) {
            this.makeVariable2(ncfile, 9, "DifferentialPhase", "Differential Phase", "P", this.volScan);
        }
        if ((gps = this.volScan.getReflectivityGroups()) != null) {
            this.makeVariable(ncfile, 1, "Reflectivity", "Reflectivity", "R", this.volScan.getReflectivityGroups(), 0);
            int velocity_type = this.volScan.getDopplarResolution() == 2 ? 2 : 4;
            Variable v = this.makeVariable(ncfile, velocity_type, "RadialVelocity", "Radial Velocity", "V", this.volScan.getVelocityGroups(), 0);
            gps = this.volScan.getVelocityGroups();
            List<Level2Record> gp = gps.get(0);
            Level2Record record = gp.get(0);
            this.makeVariableNoCoords(ncfile, 3, "SpectrumWidth", "Spectrum Width", v, record);
        }
        if (this.volScan.getStationId() != null) {
            ncfile.addAttribute(null, new Attribute("Station", this.volScan.getStationId()));
            ncfile.addAttribute(null, new Attribute("StationName", this.volScan.getStationName()));
            ncfile.addAttribute(null, new Attribute("StationLatitude", this.volScan.getStationLatitude()));
            ncfile.addAttribute(null, new Attribute("StationLongitude", this.volScan.getStationLongitude()));
            ncfile.addAttribute(null, new Attribute("StationElevationInMeters", this.volScan.getStationElevation()));
            double latRadiusDegrees = Math.toDegrees(this.radarRadius / Earth.getRadius());
            ncfile.addAttribute(null, new Attribute("geospatial_lat_min", this.volScan.getStationLatitude() - latRadiusDegrees));
            ncfile.addAttribute(null, new Attribute("geospatial_lat_max", this.volScan.getStationLatitude() + latRadiusDegrees));
            double cosLat = Math.cos(Math.toRadians(this.volScan.getStationLatitude()));
            double lonRadiusDegrees = Math.toDegrees(this.radarRadius / cosLat / Earth.getRadius());
            ncfile.addAttribute(null, new Attribute("geospatial_lon_min", this.volScan.getStationLongitude() - lonRadiusDegrees));
            ncfile.addAttribute(null, new Attribute("geospatial_lon_max", this.volScan.getStationLongitude() + lonRadiusDegrees));
        }
        DateFormatter formatter = new DateFormatter();
        ncfile.addAttribute(null, new Attribute("Conventions", "_Coordinates"));
        ncfile.addAttribute(null, new Attribute("format", this.volScan.getDataFormat()));
        ncfile.addAttribute(null, new Attribute("cdm_data_type", FeatureType.RADIAL.toString()));
        Date d = Level2Record.getDate(this.volScan.getTitleJulianDays(), 0);
        ncfile.addAttribute(null, new Attribute("base_date", formatter.toDateOnlyString(d)));
        ncfile.addAttribute(null, new Attribute("time_coverage_start", formatter.toDateTimeStringISO(d)));
        ncfile.addAttribute(null, new Attribute("time_coverage_end", formatter.toDateTimeStringISO(this.volScan.getEndDate())));
        ncfile.addAttribute(null, new Attribute("history", "Direct read of Nexrad Level 2 file into NetCDF-Java 2.2 API"));
        ncfile.addAttribute(null, new Attribute("DataType", "Radial"));
        ncfile.addAttribute(null, new Attribute("Title", "Nexrad Level 2 Station " + this.volScan.getStationId() + " from " + formatter.toDateTimeStringISO(this.volScan.getStartDate()) + " to " + formatter.toDateTimeStringISO(this.volScan.getEndDate())));
        ncfile.addAttribute(null, new Attribute("Summary", "Weather Surveillance Radar-1988 Doppler (WSR-88D) Level II data are the three meteorological base data quantities: reflectivity, mean radial velocity, and spectrum width."));
        ncfile.addAttribute(null, new Attribute("keywords", "WSR-88D; NEXRAD; Radar Level II; reflectivity; mean radial velocity; spectrum width"));
        ncfile.addAttribute(null, new Attribute("VolumeCoveragePatternName", Level2Record.getVolumeCoveragePatternName(this.volScan.getVCP())));
        ncfile.addAttribute(null, new Attribute("VolumeCoveragePattern", this.volScan.getVCP()));
        ncfile.addAttribute(null, new Attribute("HorizontalBeamWidthInDegrees", 1.5));
        ncfile.finish();
    }

    public void makeVariable2(NetcdfFile ncfile, int datatype, String shortName, String longName, String abbrev, Level2VolumeScan vScan) throws IOException {
        List<List<Level2Record>> groups = null;
        if (shortName.startsWith("Reflectivity")) {
            groups = vScan.getHighResReflectivityGroups();
        } else if (shortName.startsWith("RadialVelocity")) {
            groups = vScan.getHighResVelocityGroups();
        } else if (shortName.startsWith("DifferentialReflectivity")) {
            groups = vScan.getHighResDiffReflectGroups();
        } else if (shortName.startsWith("CorrelationCoefficient")) {
            groups = vScan.getHighResCoeffocientGroups();
        } else if (shortName.startsWith("DifferentialPhase")) {
            groups = vScan.getHighResDiffPhaseGroups();
        }
        int nscans = groups.size();
        if (nscans == 0) {
            throw new IllegalStateException("No data for " + shortName);
        }
        ArrayList<List<Level2Record>> firstGroup = new ArrayList<List<Level2Record>>(groups.size());
        ArrayList<List<Level2Record>> secondGroup = new ArrayList<List<Level2Record>>(groups.size());
        for (int i = 0; i < nscans; ++i) {
            List<Level2Record> o = groups.get(i);
            Level2Record firstRecord = o.get(0);
            int ol = o.size();
            if (ol >= 720) {
                firstGroup.add(o);
                continue;
            }
            if (ol <= 360) {
                secondGroup.add(o);
                continue;
            }
            if (firstRecord.getGateCount(5) > 500 || firstRecord.getGateCount(6) > 1000) {
                firstGroup.add(o);
                continue;
            }
            secondGroup.add(o);
        }
        if (firstGroup != null && firstGroup.size() > 0) {
            this.v1 = this.makeVariable(ncfile, datatype, shortName + "_HI", longName + "_HI", abbrev + "_HI", firstGroup, 1);
        }
        if (secondGroup != null && secondGroup.size() > 0) {
            this.v0 = this.makeVariable(ncfile, datatype, shortName, longName, abbrev, secondGroup, 0);
        }
    }

    public int getMaxRadials(List groups) {
        int maxRadials = 0;
        for (int i = 0; i < groups.size(); ++i) {
            ArrayList group = (ArrayList)groups.get(i);
            maxRadials = Math.max(maxRadials, group.size());
        }
        return maxRadials;
    }

    public Variable makeVariable(NetcdfFile ncfile, int datatype, String shortName, String longName, String abbrev, List<List<Level2Record>> groups, int rd) throws IOException {
        int nscans = groups.size();
        if (nscans == 0) {
            throw new IllegalStateException("No data for " + shortName + " file= " + ncfile.getLocation());
        }
        List<Level2Record> firstGroup = groups.get(0);
        Level2Record firstRecord = firstGroup.get(0);
        int ngates = firstRecord.getGateCount(datatype);
        String scanDimName = "scan" + abbrev;
        String gateDimName = "gate" + abbrev;
        String radialDimName = "radial" + abbrev;
        Dimension scanDim = new Dimension(scanDimName, nscans);
        Dimension gateDim = new Dimension(gateDimName, ngates);
        Dimension radialDim = new Dimension(radialDimName, this.volScan.getMaxRadials(rd), true);
        ncfile.addDimension(null, scanDim);
        ncfile.addDimension(null, gateDim);
        ncfile.addDimension(null, radialDim);
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        dims.add(scanDim);
        dims.add(radialDim);
        dims.add(gateDim);
        Variable v = new Variable(ncfile, null, null, shortName);
        if (datatype == 9) {
            v.setDataType(DataType.SHORT);
        } else {
            v.setDataType(DataType.BYTE);
        }
        v.setDimensions(dims);
        ncfile.addVariable(null, v);
        v.addAttribute(new Attribute("units", Level2Record.getDatatypeUnits(datatype)));
        v.addAttribute(new Attribute("long_name", longName));
        byte[] b = new byte[]{1, 0};
        Array missingArray = Array.factory(DataType.BYTE.getPrimitiveClassType(), new int[]{2}, (Object)b);
        v.addAttribute(new Attribute("missing_value", missingArray));
        v.addAttribute(new Attribute("signal_below_threshold", (byte)0));
        v.addAttribute(new Attribute("scale_factor", Float.valueOf(firstRecord.getDatatypeScaleFactor(datatype))));
        v.addAttribute(new Attribute("add_offset", Float.valueOf(firstRecord.getDatatypeAddOffset(datatype))));
        v.addAttribute(new Attribute("_Unsigned", "true"));
        if (rd == 1) {
            v.addAttribute(new Attribute("SNR_threshold", firstRecord.getDatatypeSNRThreshhold(datatype)));
        }
        v.addAttribute(new Attribute("range_folding_threshold", firstRecord.getDatatypeRangeFoldingThreshhold(datatype)));
        ArrayList<Dimension> dim2 = new ArrayList<Dimension>();
        dim2.add(scanDim);
        dim2.add(radialDim);
        String timeCoordName = "time" + abbrev;
        Variable timeVar = new Variable(ncfile, null, null, timeCoordName);
        timeVar.setDataType(DataType.INT);
        timeVar.setDimensions(dim2);
        ncfile.addVariable(null, timeVar);
        Date d = Level2Record.getDate(this.volScan.getTitleJulianDays(), 0);
        String units = "msecs since " + this.formatter.toDateTimeStringISO(d);
        timeVar.addAttribute(new Attribute("long_name", "time since base date"));
        timeVar.addAttribute(new Attribute("units", units));
        timeVar.addAttribute(new Attribute("missing_value", -9999));
        timeVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
        String elevCoordName = "elevation" + abbrev;
        Variable elevVar = new Variable(ncfile, null, null, elevCoordName);
        elevVar.setDataType(DataType.FLOAT);
        elevVar.setDimensions(dim2);
        ncfile.addVariable(null, elevVar);
        elevVar.addAttribute(new Attribute("units", "degrees"));
        elevVar.addAttribute(new Attribute("long_name", "elevation angle in degres: 0 = parallel to pedestal base, 90 = perpendicular"));
        elevVar.addAttribute(new Attribute("missing_value", Float.valueOf(Float.NaN)));
        elevVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.RadialElevation.toString()));
        String aziCoordName = "azimuth" + abbrev;
        Variable aziVar = new Variable(ncfile, null, null, aziCoordName);
        aziVar.setDataType(DataType.FLOAT);
        aziVar.setDimensions(dim2);
        ncfile.addVariable(null, aziVar);
        aziVar.addAttribute(new Attribute("units", "degrees"));
        aziVar.addAttribute(new Attribute("long_name", "azimuth angle in degrees: 0 = true north, 90 = east"));
        aziVar.addAttribute(new Attribute("missing_value", Float.valueOf(Float.NaN)));
        aziVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.RadialAzimuth.toString()));
        String gateCoordName = "distance" + abbrev;
        Variable gateVar = new Variable(ncfile, null, null, gateCoordName);
        gateVar.setDataType(DataType.FLOAT);
        gateVar.setDimensions(gateDimName);
        Array data = Array.makeArray(DataType.FLOAT, ngates, firstRecord.getGateStart(datatype), firstRecord.getGateSize(datatype));
        gateVar.setCachedData(data, false);
        ncfile.addVariable(null, gateVar);
        this.radarRadius = firstRecord.getGateStart(datatype) + ngates * firstRecord.getGateSize(datatype);
        gateVar.addAttribute(new Attribute("units", "m"));
        gateVar.addAttribute(new Attribute("long_name", "radial distance to start of gate"));
        gateVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.RadialDistance.toString()));
        String nradialsName = "numRadials" + abbrev;
        Variable nradialsVar = new Variable(ncfile, null, null, nradialsName);
        nradialsVar.setDataType(DataType.INT);
        nradialsVar.setDimensions(scanDim.getName());
        nradialsVar.addAttribute(new Attribute("long_name", "number of valid radials in this scan"));
        ncfile.addVariable(null, nradialsVar);
        String ngateName = "numGates" + abbrev;
        Variable ngateVar = new Variable(ncfile, null, null, ngateName);
        ngateVar.setDataType(DataType.INT);
        ngateVar.setDimensions(scanDim.getName());
        ngateVar.addAttribute(new Attribute("long_name", "number of valid gates in this scan"));
        ncfile.addVariable(null, ngateVar);
        this.makeCoordinateDataWithMissing(datatype, timeVar, elevVar, aziVar, nradialsVar, ngateVar, groups);
        String coordinates = timeCoordName + " " + elevCoordName + " " + aziCoordName + " " + gateCoordName;
        v.addAttribute(new Attribute("_CoordinateAxes", coordinates));
        int nradials = radialDim.getLength();
        Level2Record[][] map = new Level2Record[nscans][nradials];
        for (int i = 0; i < groups.size(); ++i) {
            Level2Record[] mapScan = map[i];
            List<Level2Record> group = groups.get(i);
            for (Level2Record r : group) {
                int radial = r.radial_num - 1;
                mapScan[radial] = r;
            }
        }
        Vgroup vg = new Vgroup(datatype, map);
        v.setSPobject(vg);
        return v;
    }

    private void makeVariableNoCoords(NetcdfFile ncfile, int datatype, String shortName, String longName, Variable from, Level2Record record) {
        Variable v = new Variable(ncfile, null, null, shortName);
        v.setDataType(DataType.BYTE);
        v.setDimensions(from.getDimensions());
        ncfile.addVariable(null, v);
        v.addAttribute(new Attribute("units", Level2Record.getDatatypeUnits(datatype)));
        v.addAttribute(new Attribute("long_name", longName));
        byte[] b = new byte[]{1, 0};
        Array missingArray = Array.factory(DataType.BYTE.getPrimitiveClassType(), new int[]{2}, (Object)b);
        Attribute scale = from.findAttribute("scale_factor");
        Attribute offset = from.findAttribute("add_offset");
        v.addAttribute(new Attribute("missing_value", missingArray));
        v.addAttribute(new Attribute("signal_below_threshold", (byte)0));
        v.addAttribute(new Attribute("scale_factor", Float.valueOf(record.getDatatypeScaleFactor(datatype))));
        v.addAttribute(new Attribute("add_offset", Float.valueOf(record.getDatatypeAddOffset(datatype))));
        v.addAttribute(new Attribute("_Unsigned", "true"));
        if (datatype == 7) {
            v.addAttribute(new Attribute("SNR_threshold", record.getDatatypeSNRThreshhold(datatype)));
        }
        v.addAttribute(new Attribute("range_folding_threshold", record.getDatatypeRangeFoldingThreshhold(datatype)));
        Attribute fromAtt = from.findAttribute("_CoordinateAxes");
        v.addAttribute(new Attribute("_CoordinateAxes", fromAtt));
        Vgroup vgFrom = (Vgroup)from.getSPobject();
        Vgroup vg = new Vgroup(datatype, vgFrom.map);
        v.setSPobject(vg);
    }

    private void makeCoordinateData(int datatype, Variable time, Variable elev, Variable azi, Variable nradialsVar, Variable ngatesVar, List groups) {
        Array timeData = Array.factory(time.getDataType().getPrimitiveClassType(), time.getShape());
        IndexIterator timeDataIter = timeData.getIndexIterator();
        Array elevData = Array.factory(elev.getDataType().getPrimitiveClassType(), elev.getShape());
        IndexIterator elevDataIter = elevData.getIndexIterator();
        Array aziData = Array.factory(azi.getDataType().getPrimitiveClassType(), azi.getShape());
        IndexIterator aziDataIter = aziData.getIndexIterator();
        Array nradialsData = Array.factory(nradialsVar.getDataType().getPrimitiveClassType(), nradialsVar.getShape());
        IndexIterator nradialsIter = nradialsData.getIndexIterator();
        Array ngatesData = Array.factory(ngatesVar.getDataType().getPrimitiveClassType(), ngatesVar.getShape());
        IndexIterator ngatesIter = ngatesData.getIndexIterator();
        int last_msecs = Integer.MIN_VALUE;
        int nscans = groups.size();
        int maxRadials = this.volScan.getMaxRadials(0);
        for (int i = 0; i < nscans; ++i) {
            int j;
            List scanGroup = (List)groups.get(i);
            int nradials = scanGroup.size();
            Level2Record first = null;
            for (j = 0; j < nradials; ++j) {
                Level2Record r = (Level2Record)scanGroup.get(j);
                if (first == null) {
                    first = r;
                }
                timeDataIter.setIntNext(r.data_msecs);
                elevDataIter.setFloatNext(r.getElevation());
                aziDataIter.setFloatNext(r.getAzimuth());
                if (r.data_msecs < last_msecs) {
                    logger.warn("makeCoordinateData time out of order " + r.data_msecs);
                }
                last_msecs = r.data_msecs;
            }
            for (j = nradials; j < maxRadials; ++j) {
                timeDataIter.setIntNext(-9999);
                elevDataIter.setFloatNext(Float.NaN);
                aziDataIter.setFloatNext(Float.NaN);
            }
            nradialsIter.setIntNext(nradials);
            if (first == null) continue;
            ngatesIter.setIntNext(first.getGateCount(datatype));
        }
        time.setCachedData(timeData, false);
        elev.setCachedData(elevData, false);
        azi.setCachedData(aziData, false);
        nradialsVar.setCachedData(nradialsData, false);
        ngatesVar.setCachedData(ngatesData, false);
    }

    private void makeCoordinateDataWithMissing(int datatype, Variable time, Variable elev, Variable azi, Variable nradialsVar, Variable ngatesVar, List groups) {
        Array timeData = Array.factory(time.getDataType().getPrimitiveClassType(), time.getShape());
        Index timeIndex = timeData.getIndex();
        Array elevData = Array.factory(elev.getDataType().getPrimitiveClassType(), elev.getShape());
        Index elevIndex = elevData.getIndex();
        Array aziData = Array.factory(azi.getDataType().getPrimitiveClassType(), azi.getShape());
        Index aziIndex = aziData.getIndex();
        Array nradialsData = Array.factory(nradialsVar.getDataType().getPrimitiveClassType(), nradialsVar.getShape());
        IndexIterator nradialsIter = nradialsData.getIndexIterator();
        Array ngatesData = Array.factory(ngatesVar.getDataType().getPrimitiveClassType(), ngatesVar.getShape());
        IndexIterator ngatesIter = ngatesData.getIndexIterator();
        IndexIterator ii = timeData.getIndexIterator();
        while (ii.hasNext()) {
            ii.setIntNext(-9999);
        }
        ii = elevData.getIndexIterator();
        while (ii.hasNext()) {
            ii.setFloatNext(Float.NaN);
        }
        ii = aziData.getIndexIterator();
        while (ii.hasNext()) {
            ii.setFloatNext(Float.NaN);
        }
        int last_msecs = Integer.MIN_VALUE;
        int nscans = groups.size();
        for (int scan = 0; scan < nscans; ++scan) {
            List scanGroup = (List)groups.get(scan);
            int nradials = scanGroup.size();
            Level2Record first = null;
            for (int j = 0; j < nradials; ++j) {
                Level2Record r = (Level2Record)scanGroup.get(j);
                if (first == null) {
                    first = r;
                }
                int radial = r.radial_num - 1;
                if (last_msecs != Integer.MIN_VALUE && last_msecs - r.data_msecs > 80000000) {
                    this.overMidNight = true;
                }
                if (this.overMidNight) {
                    timeData.setInt(timeIndex.set(scan, radial), r.data_msecs + 86400000);
                } else {
                    timeData.setInt(timeIndex.set(scan, radial), r.data_msecs);
                }
                elevData.setFloat(elevIndex.set(scan, radial), r.getElevation());
                aziData.setFloat(aziIndex.set(scan, radial), r.getAzimuth());
                if (r.data_msecs < last_msecs) {
                    logger.warn("makeCoordinateData time out of order " + r.data_msecs);
                }
                last_msecs = r.data_msecs;
            }
            nradialsIter.setIntNext(nradials);
            if (first == null) continue;
            ngatesIter.setIntNext(first.getGateCount(datatype));
        }
        time.setCachedData(timeData, false);
        elev.setCachedData(elevData, false);
        azi.setCachedData(aziData, false);
        nradialsVar.setCachedData(nradialsData, false);
        ngatesVar.setCachedData(ngatesData, false);
    }

    @Override
    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        Vgroup vgroup = (Vgroup)v2.getSPobject();
        Range scanRange = section.getRange(0);
        Range radialRange = section.getRange(1);
        Range gateRange = section.getRange(2);
        Array data = Array.factory(v2.getDataType().getPrimitiveClassType(), section.getShape());
        IndexIterator ii = data.getIndexIterator();
        for (int i = scanRange.first(); i <= scanRange.last(); i += scanRange.stride()) {
            Level2Record[] mapScan = vgroup.map[i];
            this.readOneScan(mapScan, radialRange, gateRange, vgroup.datatype, ii);
        }
        return data;
    }

    private void readOneScan(Level2Record[] mapScan, Range radialRange, Range gateRange, int datatype, IndexIterator ii) throws IOException {
        for (int i = radialRange.first(); i <= radialRange.last(); i += radialRange.stride()) {
            Level2Record r = mapScan[i];
            this.readOneRadial(r, datatype, gateRange, ii);
        }
    }

    private void readOneRadial(Level2Record r, int datatype, Range gateRange, IndexIterator ii) throws IOException {
        if (r == null) {
            for (int i = gateRange.first(); i <= gateRange.last(); i += gateRange.stride()) {
                ii.setByteNext((byte)1);
            }
            return;
        }
        r.readData(this.volScan.raf, datatype, gateRange, ii);
    }

    @Override
    public void close() throws IOException {
        this.volScan.raf.close();
    }

    @Override
    public String getFileTypeId() {
        return "NEXRAD-2";
    }

    @Override
    public String getFileTypeDescription() {
        return "NEXRAD Level-II Base Data";
    }

    private class Vgroup {
        Level2Record[][] map;
        int datatype;

        Vgroup(int datatype, Level2Record[][] map) {
            this.datatype = datatype;
            this.map = map;
        }
    }
}

