/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.constants;

import ucar.nc2.NetcdfFile;

public interface CF {
    public static final String POSITIVE_UP = "up";
    public static final String POSITIVE_DOWN = "down";
    public static final String featureTypeAtt4 = "CF:featureType";
    public static final String featureTypeAtt2 = "CF-featureType";
    public static final String featureTypeAtt3 = "CFfeatureType";
    public static final String featureTypeAtt = "featureType";
    public static final String ADD_OFFSET = "add_offset";
    public static final String CF_ROLE = "cf_role";
    public static final String COORDINATES = "coordinates";
    public static final String GRID_MAPPING = "grid_mapping";
    public static final String GRID_MAPPING_NAME = "grid_mapping_name";
    public static final String MISSING_VALUE = "missing_value";
    public static final String SCALE_FACTOR = "scale_factor";
    public static final String STANDARD_NAME = "standard_name";
    public static final String UNITS = "units";
    public static final String RAGGED_ROWSIZE = "CF:ragged_row_count";
    public static final String RAGGED_PARENTINDEX = "CF:ragged_parent_index";
    public static final String STATION_ID = "station_id";
    public static final String STATION_DESC = "station_description";
    public static final String STATION_ALTITUDE = "surface_altitude";
    public static final String STATION_WMOID = "station_WMO_id";
    public static final String TRAJ_ID = "trajectory_id";
    public static final String PROFILE_ID = "profile_id";

    public static enum CellMethods {
        point,
        sum,
        mean,
        maximum,
        minimum,
        mid_range,
        standard_deviation,
        variance,
        mode,
        median;


        public static CellMethods convertGribCodeTable4_10(int code) {
            switch (code) {
                case 0: {
                    return mean;
                }
                case 1: {
                    return sum;
                }
                case 2: {
                    return maximum;
                }
                case 3: {
                    return minimum;
                }
                case 6: {
                    return standard_deviation;
                }
                case 7: {
                    return variance;
                }
            }
            return null;
        }
    }

    public static enum FeatureType {
        point,
        timeSeries,
        profile,
        trajectory,
        timeSeriesProfile,
        trajectoryProfile;


        public static FeatureType convert(ucar.nc2.constants.FeatureType ft) {
            switch (ft) {
                case POINT: {
                    return point;
                }
                case STATION: {
                    return timeSeries;
                }
                case PROFILE: {
                    return profile;
                }
                case TRAJECTORY: {
                    return trajectory;
                }
                case STATION_PROFILE: {
                    return timeSeriesProfile;
                }
                case SECTION: {
                    return trajectoryProfile;
                }
            }
            return null;
        }

        public static FeatureType getFeatureType(String s) {
            if (s.equalsIgnoreCase("point")) {
                return point;
            }
            if (s.equalsIgnoreCase("timeSeries")) {
                return timeSeries;
            }
            if (s.equalsIgnoreCase("stationTimeSeries")) {
                return timeSeries;
            }
            if (s.equalsIgnoreCase("station")) {
                return timeSeries;
            }
            if (s.equalsIgnoreCase("profile")) {
                return profile;
            }
            if (s.equalsIgnoreCase("trajectory")) {
                return trajectory;
            }
            if (s.equalsIgnoreCase("timeSeriesProfile")) {
                return timeSeriesProfile;
            }
            if (s.equalsIgnoreCase("stationProfile")) {
                return timeSeriesProfile;
            }
            if (s.equalsIgnoreCase("stationProfileTimeSeries")) {
                return timeSeriesProfile;
            }
            if (s.equalsIgnoreCase("trajectoryProfile")) {
                return trajectoryProfile;
            }
            if (s.equalsIgnoreCase("section")) {
                return trajectoryProfile;
            }
            return null;
        }

        public static FeatureType getFeatureTypeFromGlobalAttribute(NetcdfFile ds) {
            String ftypeS = ds.findAttValueIgnoreCase(null, CF.featureTypeAtt, null);
            if (ftypeS == null) {
                ftypeS = ds.findAttValueIgnoreCase(null, CF.featureTypeAtt2, null);
            }
            if (ftypeS == null) {
                ftypeS = ds.findAttValueIgnoreCase(null, CF.featureTypeAtt3, null);
            }
            if (ftypeS == null) {
                ftypeS = ds.findAttValueIgnoreCase(null, CF.featureTypeAtt4, null);
            }
            if (ftypeS == null) {
                return null;
            }
            return FeatureType.getFeatureType(ftypeS);
        }
    }
}

