/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.grib.GribGridRecord;
import ucar.grib.GribPds;
import ucar.grib.grib1.Grib1Data;
import ucar.grib.grib1.Grib1Dump;
import ucar.grib.grib1.Grib1Pds;
import ucar.grib.grib1.Grib1Tables;
import ucar.grib.grib1.GribPDSLevel;
import ucar.grib.grib2.Grib2Data;
import ucar.grib.grib2.Grib2GridDefinitionSection;
import ucar.grib.grib2.Grib2Pds;
import ucar.grib.grib2.Grib2Tables;
import ucar.grid.GridIndex;
import ucar.grid.GridRecord;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.iosp.grib.GribGridServiceProvider;
import ucar.nc2.iosp.grib.tables.GribTemplate;
import ucar.nc2.iosp.grid.GridServiceProvider;
import ucar.nc2.iosp.grid.GridVariable;
import ucar.nc2.ui.GribRawPanel;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class GribIndexPanel
extends JPanel {
    private PreferencesExt prefs;
    private BeanTableSorted recordTable;
    private BeanTableSorted gdsTable;
    private BeanTableSorted productTable;
    private JSplitPane split;
    private JSplitPane split2;
    private TextHistoryPane infoPopup;
    private TextHistoryPane infoPopup2;
    private TextHistoryPane infoPopup3;
    private IndependentWindow infoWindow;
    private IndependentWindow infoWindow2;
    private IndependentWindow infoWindow3;
    private Map<String, GribTemplate> templates = null;
    private NetcdfFile ncd;

    public GribIndexPanel(PreferencesExt prefs) {
        this.prefs = prefs;
        this.productTable = new BeanTableSorted(Product.class, (PreferencesExt)prefs.node("Product"), false, "GribGridRecord group", "same param / levelType");
        this.productTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Product pb = (Product)GribIndexPanel.this.productTable.getSelectedBean();
                if (pb != null) {
                    GribIndexPanel.this.recordTable.setBeans(pb.list);
                }
            }
        });
        PopupMenu varPopup = new PopupMenu(this.productTable.getJTable(), "Options");
        varPopup.addAction("Show record -> variable data assignments", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Product pb = (Product)GribIndexPanel.this.productTable.getSelectedBean();
                if (pb != null) {
                    Formatter f = new Formatter();
                    GribIndexPanel.this.showRecords(pb, f);
                    GribIndexPanel.this.infoPopup2.setText(f.toString());
                    GribIndexPanel.this.infoPopup2.gotoTop();
                    GribIndexPanel.this.infoWindow2.showIfNotIconified();
                }
            }
        });
        this.recordTable = new BeanTableSorted(GribGridRecordBean.class, (PreferencesExt)prefs.node("IndexRecordBean"), false, "GribGridRecord", "one record");
        varPopup = new PopupMenu(this.recordTable.getJTable(), "Options");
        varPopup.addAction("Show GridRecords", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList list = GribIndexPanel.this.recordTable.getSelectedBeans();
                GribIndexPanel.this.infoPopup2.clear();
                for (int i = 0; i < list.size(); ++i) {
                    GribGridRecordBean bean = (GribGridRecordBean)list.get(i);
                    GribIndexPanel.this.infoPopup2.appendLine(bean.ggr.toString2());
                    GribIndexPanel.this.infoPopup2.appendLine("");
                }
                GribIndexPanel.this.infoPopup2.gotoTop();
                GribIndexPanel.this.infoWindow2.showIfNotIconified();
            }
        });
        varPopup.addAction("Compare GridRecords", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList list = GribIndexPanel.this.recordTable.getSelectedBeans();
                if (list.size() == 2) {
                    GribGridRecordBean bean1 = (GribGridRecordBean)list.get(0);
                    GribGridRecordBean bean2 = (GribGridRecordBean)list.get(1);
                    Formatter f = new Formatter();
                    GribIndexPanel.this.compare(bean1, bean2, f);
                    GribIndexPanel.this.infoPopup2.setText(f.toString());
                    GribIndexPanel.this.infoPopup2.gotoTop();
                    GribIndexPanel.this.infoWindow2.showIfNotIconified();
                }
            }
        });
        varPopup.addAction("Show record -> variable data assignments", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Formatter f = new Formatter();
                ArrayList list = GribIndexPanel.this.recordTable.getSelectedBeans();
                for (int i = 0; i < list.size(); ++i) {
                    GribGridRecordBean bean = (GribGridRecordBean)list.get(i);
                    GribIndexPanel.this.showRecordBelongs(bean.ggr, f);
                }
                GribIndexPanel.this.infoPopup2.setText(f.toString());
                GribIndexPanel.this.infoPopup2.gotoTop();
                GribIndexPanel.this.infoWindow2.showIfNotIconified();
            }
        });
        varPopup.addAction("Show raw PDS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Formatter f = new Formatter();
                ArrayList list = GribIndexPanel.this.recordTable.getSelectedBeans();
                for (int i = 0; i < list.size(); ++i) {
                    GribGridRecordBean bean = (GribGridRecordBean)list.get(i);
                    GribIndexPanel.this.showRawPds(bean.ggr, f);
                }
                GribIndexPanel.this.infoPopup2.setText(f.toString());
                GribIndexPanel.this.infoPopup2.gotoTop();
                GribIndexPanel.this.infoWindow2.showIfNotIconified();
            }
        });
        varPopup.addAction("Compare Data", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList list = GribIndexPanel.this.recordTable.getSelectedBeans();
                if (list.size() == 2) {
                    GribGridRecordBean bean1 = (GribGridRecordBean)list.get(0);
                    GribGridRecordBean bean2 = (GribGridRecordBean)list.get(1);
                    Formatter f = new Formatter();
                    GribIndexPanel.this.compareData(bean1, bean2, f);
                    GribIndexPanel.this.infoPopup2.setText(f.toString());
                    GribIndexPanel.this.infoPopup2.gotoTop();
                    GribIndexPanel.this.infoWindow2.showIfNotIconified();
                }
            }
        });
        varPopup.addAction("Show Data", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Formatter f = new Formatter();
                ArrayList list = GribIndexPanel.this.recordTable.getSelectedBeans();
                for (int i = 0; i < list.size(); ++i) {
                    GribGridRecordBean bean = (GribGridRecordBean)list.get(i);
                    GribIndexPanel.this.showData(bean, f);
                }
                GribIndexPanel.this.infoPopup2.setText(f.toString());
                GribIndexPanel.this.infoPopup2.gotoTop();
                GribIndexPanel.this.infoWindow2.showIfNotIconified();
            }
        });
        this.gdsTable = new BeanTableSorted(GdsBean.class, (PreferencesExt)prefs.node("GdsBean"), false, "Grib2GridDefinitionSection", "unique from Grib2Records");
        this.gdsTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GdsBean bean = (GdsBean)GribIndexPanel.this.gdsTable.getSelectedBean();
                GribIndexPanel.this.infoPopup.setText(bean.gds.toString());
                GribIndexPanel.this.infoWindow.setVisible(true);
                GribIndexPanel.this.gdsTable.clearSelection();
            }
        });
        this.infoPopup = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoPopup);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.infoPopup2 = new TextHistoryPane();
        this.infoWindow2 = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoPopup2);
        this.infoWindow2.setBounds((Rectangle)prefs.getBean("InfoWindowBounds2", new Rectangle(300, 300, 500, 300)));
        this.infoPopup3 = new TextHistoryPane();
        this.infoWindow3 = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoPopup3);
        this.infoWindow3.setBounds((Rectangle)prefs.getBean("InfoWindowBounds3", new Rectangle(300, 300, 500, 300)));
        this.setLayout(new BorderLayout());
        this.split2 = new JSplitPane(0, false, this.productTable, this.recordTable);
        this.split2.setDividerLocation(prefs.getInt("splitPos2", 800));
        this.add((Component)this.split2, "Center");
    }

    public void save() {
        this.recordTable.saveState(false);
        this.gdsTable.saveState(false);
        this.productTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        this.prefs.putBeanObject("InfoWindowBounds2", this.infoWindow2.getBounds());
        this.prefs.putBeanObject("InfoWindowBounds3", this.infoWindow3.getBounds());
        if (this.split != null) {
            this.prefs.putInt("splitPos", this.split.getDividerLocation());
        }
        if (this.split2 != null) {
            this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
        }
    }

    public void closeOpenFiles() throws IOException {
        if (this.ncd != null) {
            this.ncd.close();
        }
        this.ncd = null;
    }

    public void setGribFile(String filename) throws IOException {
        if (this.ncd != null) {
            this.ncd.close();
        }
        GridServiceProvider.debugOpen = true;
        this.ncd = NetcdfFile.open(filename);
        GribGridServiceProvider iosp = (GribGridServiceProvider)this.ncd.getIosp();
        GridIndex index = (GridIndex)iosp.sendIospMessage("GridIndex");
        HashMap<Integer, Product> pdsSet = new HashMap<Integer, Product>();
        ArrayList<Product> products = new ArrayList<Product>();
        List grList = index.getGridRecords();
        for (GridRecord gr : grList) {
            GribGridRecord ggr = (GribGridRecord)gr;
            Product bean = (Product)pdsSet.get(ggr.cdmVariableHash());
            if (bean == null) {
                bean = new Product(ggr);
                pdsSet.put(ggr.cdmVariableHash(), bean);
                products.add(bean);
            }
            bean.list.add(new GribGridRecordBean(ggr));
        }
        ArrayList sortList = new ArrayList();
        sortList.addAll(pdsSet.values());
        Collections.sort(sortList);
        for (Product p : sortList) {
            p.sort();
        }
        GridServiceProvider.debugOpen = false;
        System.out.printf("GribIndexPanel Products = %d GridRecords = %d%n", sortList.size(), grList.size());
        this.productTable.setBeans(products);
        this.recordTable.setBeans(new ArrayList());
    }

    public void showInfo(Formatter f) {
        if (this.ncd == null) {
            return;
        }
        int missing = 0;
        for (Variable v : this.ncd.getVariables()) {
            GridVariable pv = (GridVariable)v.getSPobject();
            if (pv == null) {
                f.format("%s has no GridVariable%n", v.getShortName());
                continue;
            }
            missing += pv.showMissingSummary(f);
        }
        f.format("Toal Missing = %d%n", missing);
    }

    private void showRecords(Product bean, Formatter f) {
        for (GribGridRecordBean ibean : bean.list) {
            this.showRecordBelongs(ibean.ggr, f);
        }
    }

    private void showRecordBelongs(GribGridRecord ggr, Formatter f) {
        GridVariable.Belongs b = (GridVariable.Belongs)ggr.getBelongs();
        f.format("%s == %s : ", ggr.toString(), ggr.getBelongs());
        b.gv.showRecord(b.recnum, f);
        f.format("%n", new Object[0]);
    }

    void compareData(GribGridRecordBean bean1, GribGridRecordBean bean2, Formatter f) {
        RandomAccessFile raf = (RandomAccessFile)this.ncd.sendIospMessage("RandomAccessFile");
        if (raf == null) {
            return;
        }
        GribGridRecord ggr1 = bean1.ggr;
        GribGridRecord ggr2 = bean2.ggr;
        float[] data1 = null;
        float[] data2 = null;
        try {
            if (ggr1.getEdition() == 2) {
                Grib2Data g2read = new Grib2Data(raf);
                data1 = g2read.getData(ggr1.getGdsOffset(), ggr1.getPdsOffset(), ggr1.getReferenceTimeInMsecs());
                data2 = g2read.getData(ggr2.getGdsOffset(), ggr2.getPdsOffset(), ggr2.getReferenceTimeInMsecs());
            } else {
                Grib1Data g1read = new Grib1Data(raf);
                data1 = g1read.getData(ggr1.getGdsOffset(), ggr1.getPdsOffset(), ggr1.getDecimalScale(), ggr1.isBmsExists());
                data2 = g1read.getData(ggr2.getGdsOffset(), ggr2.getPdsOffset(), ggr2.getDecimalScale(), ggr2.isBmsExists());
            }
        }
        catch (IOException e) {
            f.format("IOException %s", e.getMessage());
            return;
        }
        GribRawPanel.compare(data1, data2, f);
    }

    void showData(GribGridRecordBean bean, Formatter f) {
        RandomAccessFile raf = (RandomAccessFile)this.ncd.sendIospMessage("RandomAccessFile");
        if (raf == null) {
            return;
        }
        GribGridRecord ggr = bean.ggr;
        float[] data = null;
        try {
            if (ggr.getEdition() == 2) {
                Grib2Data g2read = new Grib2Data(raf);
                data = g2read.getData(ggr.getGdsOffset(), ggr.getPdsOffset(), ggr.getReferenceTimeInMsecs());
            } else {
                Grib1Data g1read = new Grib1Data(raf);
                data = g1read.getData(ggr.getGdsOffset(), ggr.getPdsOffset(), ggr.getDecimalScale(), ggr.isBmsExists());
            }
        }
        catch (IOException e) {
            f.format("IOException %s", e.getMessage());
            return;
        }
        for (float fd : data) {
            f.format("%f%n", Float.valueOf(fd));
        }
    }

    void compare(GribGridRecordBean bean1, GribGridRecordBean bean2, Formatter f) {
        GribGridRecord ggr1 = bean1.ggr;
        GribGridRecord ggr2 = bean2.ggr;
        boolean ok = true;
        if (ggr1.getGdsKey() != ggr2.getGdsKey()) {
            f.format("gds differs %d != %d %n", ggr1.getGdsKey(), ggr2.getGdsKey());
            ok = false;
        }
        ggr1.getGridDefRecordId();
        if (ok) {
            f.format("All OK!%n", new Object[0]);
        }
        f.format("Compare PDS bytes %n", new Object[0]);
        byte[] raw1 = ggr1.getPds().getPDSBytes();
        byte[] raw2 = ggr2.getPds().getPDSBytes();
        GribRawPanel.compare(raw1, raw2, f);
    }

    private void showRawPds(GribGridRecord ggr, Formatter f) {
        if (ggr.getEdition() == 1) {
            Grib1Dump.printPDS((Grib1Pds)((Grib1Pds)ggr.getPds()), (Formatter)f);
            byte[] raw = ggr.getPds().getPDSBytes();
            f.format("%n", new Object[0]);
            for (int i = 28; i < raw.length; ++i) {
                f.format(" %3d : %3d%n", i + 1, raw[i]);
            }
            return;
        }
        Grib2Pds pds2 = (Grib2Pds)ggr.getPds();
        int template = pds2.getProductDefinitionTemplate();
        byte[] raw = ggr.getPds().getPDSBytes();
        if (raw == null) {
            f.format("PDS bytes not available template=%d%n", template);
            return;
        }
        this.showRawTemplate("4." + template, raw, f);
    }

    private void showRawTemplate(String key, byte[] raw, Formatter f) {
        GribTemplate gt;
        if (this.templates == null) {
            try {
                this.templates = GribTemplate.getParameterTemplates();
            }
            catch (IOException e) {
                f.format("Read template failed = %s%n", e.getMessage());
                return;
            }
        }
        if ((gt = this.templates.get(key)) == null) {
            f.format("Cant find template %s%n", key);
        } else {
            gt.showInfo(raw, f);
        }
    }

    public class GdsBean {
        Grib2GridDefinitionSection gds;
        int key;

        public GdsBean() {
        }

        public GdsBean(int key, Grib2GridDefinitionSection m) {
            this.key = key;
            this.gds = m;
        }

        public int getKey() {
            return this.key;
        }

        public int getHashCode() {
            return this.gds.hashCode();
        }

        public int getGridNo() {
            return this.gds.getGdtn();
        }

        public String getGridName() {
            return Grib2Tables.codeTable3_1((int)this.gds.getGdtn());
        }

        public String getScanMode() {
            return Long.toBinaryString(this.gds.getScanMode());
        }

        public String getResolution() {
            return Long.toBinaryString(this.gds.getResolution());
        }
    }

    public class GribGridRecordBean {
        GribGridRecord ggr;
        GribPds pds;

        public GribGridRecordBean() {
        }

        public GribGridRecordBean(GribGridRecord ggr) {
            this.ggr = ggr;
            this.pds = ggr.getPds();
        }

        public final String getTimeUdunit() {
            return this.ggr.getTimeUdunitName();
        }

        public final String getSurfaceType() {
            if (this.ggr.getEdition() == 2) {
                String s = Grib2Tables.getTypeSurfaceNameShort((int)this.ggr.getLevelType1());
                int lev2 = this.ggr.getLevelType2();
                if (lev2 != -9999 && lev2 != 255) {
                    s = s + "/" + Grib2Tables.getTypeSurfaceNameShort((int)lev2);
                }
                return s;
            }
            String s = GribPDSLevel.getLevelDescription((int)this.ggr.getLevelType1());
            int lev2 = this.ggr.getLevelType2();
            if (lev2 != -9999 && lev2 != 255) {
                s = s + "/" + GribPDSLevel.getLevelDescription((int)lev2);
            }
            return s;
        }

        public String getSurfaceValue() {
            return this.ggr.getLevel1() + "-" + this.ggr.getLevel2();
        }

        public String getInterval() {
            if (this.pds.isInterval()) {
                int[] intv = this.pds.getForecastTimeInterval();
                return intv[0] + "-" + intv[1];
            }
            return "";
        }

        public Date getIntervalEnd() {
            long msecs;
            if (this.pds.isInterval() && (msecs = this.pds.getIntervalTimeEnd()) >= 0L) {
                return new Date(msecs);
            }
            return null;
        }

        public Date getValidTime() {
            return this.pds.getForecastDate();
        }

        public int getForecastTime() {
            return this.pds.getForecastTime();
        }

        public final int getPertNumber() {
            if (this.pds.isEnsemble()) {
                return this.pds.getPerturbationNumber();
            }
            return -1;
        }

        public int getPertType() {
            if (this.pds.isEnsemble()) {
                return this.pds.getPerturbationType();
            }
            return -1;
        }

        public String getProbability() {
            if (this.pds.isProbability()) {
                return this.pds.getProbabilityLowerLimit() + "-" + this.pds.getProbabilityUpperLimit();
            }
            return "";
        }

        public final int getGenProcType() {
            if (this.ggr.getEdition() == 2) {
                Grib2Pds pds = (Grib2Pds)this.ggr.getPds();
                return pds.getGenProcessType();
            }
            return -1;
        }

        public final int getGenProcId() {
            return this.pds.getGenProcessId();
        }

        public final String getStatType() {
            int code = this.pds.getStatisticalProcessType();
            return code >= 0 ? Grib2Tables.codeTable4_10((int)this.pds.getStatisticalProcessType()) : "";
        }

        public long getGdsOffset() {
            return this.ggr.getGdsOffset();
        }

        public long getPdsOffset() {
            return this.ggr.getPdsOffset();
        }
    }

    public class Product
    implements Comparable<Product> {
        GribGridRecord ggr;
        List<GribGridRecordBean> list = new ArrayList<GribGridRecordBean>();
        String name;

        Product() {
        }

        Product(GribGridRecord ggr) {
            this.ggr = ggr;
            this.name = ggr.getParameterDescription();
        }

        public String getDesc() {
            return this.name;
        }

        public String getParamNo() {
            if (this.ggr.getEdition() == 1) {
                return this.ggr.getParameterNumber() + " ";
            }
            Grib2Pds pds2 = (Grib2Pds)this.ggr.getPds();
            return this.ggr.getDiscipline() + "-" + pds2.getParameterCategory() + "-" + this.ggr.getParameterNumber();
        }

        public int getLevelType() {
            return this.ggr.getLevelType1();
        }

        public String getSuffix() {
            return this.ggr.makeSuffix();
        }

        public int getTemplate() {
            if (this.ggr.getEdition() == 1) {
                return -1;
            }
            Grib2Pds pds2 = (Grib2Pds)this.ggr.getPds();
            return pds2.getProductDefinitionTemplate();
        }

        public final Date getRefTime() {
            return this.ggr.getReferenceTime();
        }

        public final String getLevelName() {
            if (this.ggr.getEdition() == 2) {
                return Grib2Tables.codeTable4_5((int)this.ggr.getLevelType1());
            }
            return Grib1Tables.getLevelDescription((int)this.ggr.getLevelType1());
        }

        public final String getGenProc() {
            return Grib1Tables.getTypeGenProcessName((int)this.ggr.getCenter(), (int)this.ggr.getPds().getGenProcessId());
        }

        public final String getGenProcType() {
            if (this.ggr.getEdition() == 2) {
                Grib2Pds pds = (Grib2Pds)this.ggr.getPds();
                return Grib2Tables.codeTable4_3((int)pds.getGenProcessType());
            }
            return "";
        }

        public final String getStatType() {
            if (this.ggr.getPds().isInterval()) {
                return Grib2Tables.codeTable4_10((int)this.ggr.getPds().getStatisticalProcessType());
            }
            return "";
        }

        public int getN() {
            return this.list.size();
        }

        public final int getNEns() {
            if (this.isEnsemble() || this.isDerived()) {
                return this.ggr.getPds().getNumberEnsembleForecasts();
            }
            return -1;
        }

        public final boolean isEnsemble() {
            return this.ggr.getPds().isEnsemble();
        }

        public final boolean isDerived() {
            return this.ggr.getPds().isEnsembleDerived();
        }

        void sort() {
            Collections.sort(this.list, new Comparator<GribGridRecordBean>(){

                @Override
                public int compare(GribGridRecordBean o1, GribGridRecordBean o2) {
                    if (Product.this.getNEns() >= 0 && o1.getForecastTime() == o2.getForecastTime()) {
                        return o1.getPertNumber() - o2.getPertNumber();
                    }
                    return o1.getForecastTime() - o2.getForecastTime();
                }
            });
        }

        @Override
        public int compareTo(Product o) {
            return this.name.compareTo(o.name);
        }
    }
}

