/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.ma2.Array;
import ucar.ma2.IndexIterator;
import ucar.nc2.Dimension;
import ucar.nc2.NCdumpW;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.dt.grid.GridCoordSys;
import ucar.nc2.dt.radial.RadialCoordSys;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateUnit;
import ucar.unidata.util.Parameter;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class CoordSysTable
extends JPanel {
    private PreferencesExt prefs;
    private NetcdfDataset ds;
    private BeanTableSorted varTable;
    private BeanTableSorted csTable;
    private BeanTableSorted axisTable;
    private JSplitPane split;
    private JSplitPane split2;
    private TextHistoryPane infoTA;
    private IndependentWindow infoWindow;
    private Formatter parseInfo = new Formatter();

    public CoordSysTable(PreferencesExt prefs) {
        this.prefs = prefs;
        this.varTable = new BeanTableSorted(VariableBean.class, (PreferencesExt)prefs.node("VariableBeans"), false);
        this.varTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                VariableBean vb = (VariableBean)CoordSysTable.this.varTable.getSelectedBean();
                if (null != vb.firstCoordSys) {
                    CoordSysTable.this.setSelectedCoordinateSystem(vb.firstCoordSys);
                }
            }
        });
        this.csTable = new BeanTableSorted(CoordinateSystemBean.class, (PreferencesExt)prefs.node("CoordinateSystemBean"), false);
        this.csTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CoordinateSystemBean csb = (CoordinateSystemBean)CoordSysTable.this.csTable.getSelectedBean();
                CoordSysTable.this.setSelectedCoordinateAxes(csb.coordSys);
            }
        });
        this.axisTable = new BeanTableSorted(AxisBean.class, (PreferencesExt)prefs.node("CoordinateAxisBean"), false);
        PopupMenu varPopup = new PopupMenu(this.varTable.getJTable(), "Options");
        varPopup.addAction("Show Declaration", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VariableBean vb = (VariableBean)CoordSysTable.this.varTable.getSelectedBean();
                VariableDS v = (VariableDS)CoordSysTable.this.ds.findVariable(vb.getName());
                if (v == null) {
                    return;
                }
                CoordSysTable.this.infoTA.clear();
                CoordSysTable.this.infoTA.appendLine(v.toString());
                CoordSysTable.this.infoTA.appendLine(CoordSysTable.this.showMissing(v));
                CoordSysTable.this.infoTA.gotoTop();
                CoordSysTable.this.infoWindow.showIfNotIconified();
            }
        });
        varPopup.addAction("Try as Grid", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VariableBean vb = (VariableBean)CoordSysTable.this.varTable.getSelectedBean();
                VariableEnhanced v = (VariableEnhanced)((Object)CoordSysTable.this.ds.findVariable(vb.getName()));
                if (v == null) {
                    return;
                }
                CoordSysTable.this.infoTA.clear();
                CoordSysTable.this.infoTA.appendLine(CoordSysTable.this.tryGrid(v));
                CoordSysTable.this.infoTA.gotoTop();
                CoordSysTable.this.infoWindow.showIfNotIconified();
            }
        });
        PopupMenu csPopup = new PopupMenu(this.csTable.getJTable(), "Options");
        csPopup.addAction("Show CoordSys", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordinateSystemBean csb = (CoordinateSystemBean)CoordSysTable.this.csTable.getSelectedBean();
                CoordinateSystem coordSys = csb.coordSys;
                CoordSysTable.this.infoTA.clear();
                CoordSysTable.this.infoTA.appendLine("Coordinate System = " + coordSys.getName());
                for (CoordinateAxis axis : coordSys.getCoordinateAxes()) {
                    CoordSysTable.this.infoTA.appendLine("  " + (Object)((Object)axis.getAxisType()) + " " + axis);
                }
                CoordSysTable.this.infoTA.appendLine(" Coordinate Transforms");
                for (CoordinateTransform ct : coordSys.getCoordinateTransforms()) {
                    ProjectionCT pct;
                    CoordSysTable.this.infoTA.appendLine("  " + ct.getName() + " type=" + (Object)((Object)ct.getTransformType()));
                    for (Parameter p : ct.getParameters()) {
                        CoordSysTable.this.infoTA.appendLine("    " + p);
                    }
                    if (ct instanceof ProjectionCT && (pct = (ProjectionCT)ct).getProjection() != null) {
                        CoordSysTable.this.infoTA.appendLine("    impl.class= " + pct.getProjection().getClass().getName());
                        pct.getProjection();
                    }
                    if (!(ct instanceof VerticalCT)) continue;
                    VerticalCT vct = (VerticalCT)ct;
                    CoordSysTable.this.infoTA.appendLine("  VerticalCT= " + vct);
                }
                CoordSysTable.this.infoTA.gotoTop();
                CoordSysTable.this.infoWindow.showIfNotIconified();
            }
        });
        PopupMenu axisPopup = new PopupMenu(this.axisTable.getJTable(), "Options");
        axisPopup.addAction("Show Declaration", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AxisBean bean = (AxisBean)CoordSysTable.this.axisTable.getSelectedBean();
                VariableDS axis = (VariableDS)CoordSysTable.this.ds.findVariable(bean.getName());
                if (axis == null) {
                    return;
                }
                CoordSysTable.this.infoTA.clear();
                CoordSysTable.this.infoTA.appendLine(axis.toString());
                CoordSysTable.this.infoTA.appendLine(CoordSysTable.this.showMissing(axis));
                CoordSysTable.this.infoTA.gotoTop();
                CoordSysTable.this.infoWindow.showIfNotIconified();
            }
        });
        axisPopup.addAction("Show Values", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AxisBean bean = (AxisBean)CoordSysTable.this.axisTable.getSelectedBean();
                CoordinateAxis axis = bean.axis;
                CoordSysTable.this.infoTA.clear();
                try {
                    CoordSysTable.this.infoTA.appendLine(NCdumpW.printVariableData(axis, null));
                    if (axis instanceof CoordinateAxis1D && axis.isNumeric()) {
                        CoordinateAxis1D axis1D = (CoordinateAxis1D)axis;
                        if (axis1D.isContiguous()) {
                            CoordSysTable.this.printArray("edges=", axis1D.getCoordEdges());
                        } else {
                            CoordSysTable.this.printArray("bound1=", axis1D.getBound1());
                            CoordSysTable.this.printArray("bound2=", axis1D.getBound2());
                            Formatter f = new Formatter();
                            double[] b1 = axis1D.getBound1();
                            double[] b2 = axis1D.getBound2();
                            for (int i = 0; i < b1.length; ++i) {
                                f.format("(%f,%f)%n", b1[i], b2[i]);
                            }
                            CoordSysTable.this.infoTA.appendLine(f.toString());
                        }
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    CoordSysTable.this.infoTA.appendLine(e1.getMessage());
                }
                CoordSysTable.this.infoTA.gotoTop();
                CoordSysTable.this.infoWindow.showIfNotIconified();
            }
        });
        axisPopup.addAction("Show Value Differences", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AxisBean bean = (AxisBean)CoordSysTable.this.axisTable.getSelectedBean();
                CoordinateAxis axis = (CoordinateAxis)CoordSysTable.this.ds.findVariable(bean.getName());
                CoordSysTable.this.infoTA.clear();
                try {
                    if (axis instanceof CoordinateAxis1D && axis.isNumeric()) {
                        CoordinateAxis1D axis1D = (CoordinateAxis1D)axis;
                        double[] mids = axis1D.getCoordValues();
                        for (int i = 0; i < mids.length - 1; ++i) {
                            mids[i] = mids[i + 1] - mids[i];
                        }
                        mids[mids.length - 1] = 0.0;
                        CoordSysTable.this.printArray("midpoint differences=", mids);
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    CoordSysTable.this.infoTA.appendLine(e1.getMessage());
                }
                CoordSysTable.this.infoTA.gotoTop();
                CoordSysTable.this.infoWindow.showIfNotIconified();
            }
        });
        axisPopup.addAction("Show Values as Date", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AxisBean bean = (AxisBean)CoordSysTable.this.axisTable.getSelectedBean();
                VariableEnhanced axis = (VariableEnhanced)((Object)CoordSysTable.this.ds.findVariable(bean.getName()));
                String units = axis.getUnitsString();
                CoordSysTable.this.infoTA.clear();
                try {
                    CoordSysTable.this.infoTA.appendLine(units);
                    CoordSysTable.this.infoTA.appendLine(NCdumpW.printVariableData(axis, null));
                    if (axis.getDataType().isNumeric()) {
                        DateFormatter format = new DateFormatter();
                        DateUnit du = new DateUnit(units);
                        Array data = axis.read();
                        IndexIterator ii = data.getIndexIterator();
                        while (ii.hasNext()) {
                            double val = ii.getDoubleNext();
                            if (Double.isNaN(val)) {
                                CoordSysTable.this.infoTA.appendLine(" N/A");
                                continue;
                            }
                            Date date = du.makeDate(val);
                            CoordSysTable.this.infoTA.appendLine(" " + format.toDateTimeString(date));
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    CoordSysTable.this.infoTA.appendLine(ex.getMessage());
                }
                CoordSysTable.this.infoTA.gotoTop();
                CoordSysTable.this.infoWindow.showIfNotIconified();
            }
        });
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.split = new JSplitPane(0, false, this.varTable, this.csTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.split2 = new JSplitPane(0, false, this.split, this.axisTable);
        this.split2.setDividerLocation(prefs.getInt("splitPos2", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split2, "Center");
    }

    private void printArray(String title, double[] vals) {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append(" ").append(title);
        for (int i = 0; i < vals.length; ++i) {
            sbuff.append(" ").append(vals[i]);
        }
        sbuff.append("\n");
        this.infoTA.appendLine(sbuff.toString());
    }

    public PreferencesExt getPrefs() {
        return this.prefs;
    }

    public void save() {
        this.varTable.saveState(false);
        this.csTable.saveState(false);
        this.axisTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
        this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
    }

    public void setDataset(NetcdfDataset ds) {
        this.ds = ds;
        this.parseInfo = new Formatter();
        ArrayList<VariableBean> beanList = new ArrayList<VariableBean>();
        ArrayList<AxisBean> axisList = new ArrayList<AxisBean>();
        this.setVariables(ds.getVariables(), axisList, beanList);
        this.varTable.setBeans(beanList);
        this.axisTable.setBeans(axisList);
        this.csTable.setBeans(this.getCoordinateSystemBeans(ds));
    }

    private void setVariables(List<Variable> varList, List<AxisBean> axisList, List<VariableBean> beanList) {
        for (int i = 0; i < varList.size(); ++i) {
            VariableEnhanced v = (VariableEnhanced)((Object)varList.get(i));
            if (v instanceof CoordinateAxis) {
                axisList.add(new AxisBean((CoordinateAxis)v));
            } else {
                beanList.add(new VariableBean(v));
            }
            if (!(v instanceof Structure)) continue;
            List<Variable> nested = ((Structure)((Object)v)).getVariables();
            this.setVariables(nested, axisList, beanList);
        }
    }

    public List<CoordinateSystemBean> getCoordinateSystemBeans(NetcdfDataset ds) {
        ArrayList<CoordinateSystemBean> vlist = new ArrayList<CoordinateSystemBean>();
        List<CoordinateSystem> list = ds.getCoordinateSystems();
        for (int i = 0; i < list.size(); ++i) {
            CoordinateSystem elem = list.get(i);
            vlist.add(new CoordinateSystemBean(elem));
        }
        return vlist;
    }

    private void setSelectedCoordinateSystem(CoordinateSystem coordSys) {
        List beans = this.csTable.getBeans();
        for (int i = 0; i < beans.size(); ++i) {
            CoordinateSystemBean bean = (CoordinateSystemBean)beans.get(i);
            if (bean.coordSys != coordSys) continue;
            this.csTable.setSelectedBean(bean);
            return;
        }
    }

    private void setSelectedCoordinateAxes(CoordinateSystem cs) {
        List<CoordinateAxis> axesList = cs.getCoordinateAxes();
        if (axesList.size() == 0) {
            return;
        }
        CoordinateAxis axis = axesList.get(0);
        List beans = this.axisTable.getBeans();
        for (int i = 0; i < beans.size(); ++i) {
            AxisBean bean = (AxisBean)beans.get(i);
            if (bean.axis != axis) continue;
            this.axisTable.setSelectedBean(bean);
            return;
        }
    }

    private String tryGrid(VariableEnhanced v) {
        Formatter buff = new Formatter();
        buff.format("%s:", v.getFullName());
        List<CoordinateSystem> csList = v.getCoordinateSystems();
        if (csList.size() == 0) {
            buff.format(" No Coord System found", new Object[0]);
        } else {
            for (CoordinateSystem cs : csList) {
                buff.format("%s:", cs.getName());
                if (GridCoordSys.isGridCoordSys(buff, cs, v)) {
                    buff.format("GRID OK%n", new Object[0]);
                    continue;
                }
                buff.format(" NOT GRID", new Object[0]);
            }
        }
        return buff.toString();
    }

    private String showMissing(VariableDS v) {
        Formatter buff = new Formatter();
        buff.format("%s:", v.getFullName());
        EnumSet<NetcdfDataset.Enhance> enhanceMode = v.getEnhanceMode();
        buff.format("enhanceMode= %s%n", enhanceMode);
        v.showScaleMissingProxy(buff);
        return buff.toString();
    }

    public class AxisBean {
        CoordinateAxis axis;
        CoordinateSystem firstCoordSys = null;
        String name;
        String desc;
        String units;
        String axisType = "";
        String positive = "";
        String incr = "";
        String dims;
        String shape;
        boolean isCoordVar;
        boolean isLayer;
        boolean isInterval;

        public AxisBean() {
        }

        public AxisBean(CoordinateAxis v) {
            String p;
            this.axis = v;
            this.setName(v.getFullName());
            this.setCoordVar(v.isCoordinateVariable());
            this.setDescription(v.getDescription());
            this.setUnits(v.getUnitsString());
            StringBuilder lens = new StringBuilder();
            StringBuilder names = new StringBuilder();
            List<Dimension> dims = v.getDimensions();
            for (int j = 0; j < dims.size(); ++j) {
                Dimension dim = dims.get(j);
                if (j > 0) {
                    lens.append(",");
                    names.append(",");
                }
                String name = dim.isShared() ? dim.getName() : "anon";
                names.append(name);
                lens.append(dim.getLength());
            }
            this.setDims(names.toString());
            this.setShape(lens.toString());
            AxisType at = v.getAxisType();
            if (at != null) {
                this.setAxisType(at.toString());
            }
            if ((p = v.getPositive()) != null) {
                this.setPositive(p);
            }
            if (v instanceof CoordinateAxis1D) {
                CoordinateAxis1D v1 = (CoordinateAxis1D)v;
                if (v1.isRegular()) {
                    this.setRegular(Double.toString(v1.getIncrement()));
                }
                this.isLayer = null != this.axis.findAttribute("_CoordinateZisLayer");
                this.isInterval = v1.isInterval();
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isCoordVar() {
            return this.isCoordVar;
        }

        public void setCoordVar(boolean isCoordVar) {
            this.isCoordVar = isCoordVar;
        }

        public boolean isContig() {
            return this.axis.isContiguous();
        }

        public boolean isLayer() {
            return this.isLayer;
        }

        public boolean isInterval() {
            return this.isInterval;
        }

        public String getShape() {
            return this.shape;
        }

        public void setShape(String shape) {
            this.shape = shape;
        }

        public String getAxisType() {
            return this.axisType;
        }

        public void setAxisType(String axisType) {
            this.axisType = axisType;
        }

        public String getDims() {
            return this.dims;
        }

        public void setDims(String dims) {
            this.dims = dims;
        }

        public String getDescription() {
            return this.desc;
        }

        public void setDescription(String desc) {
            this.desc = desc;
        }

        public String getUnits() {
            return this.units;
        }

        public void setUnits(String units) {
            this.units = units == null ? "null" : units;
        }

        public String getPositive() {
            return this.positive;
        }

        public void setPositive(String positive) {
            this.positive = positive;
        }

        public String getRegular() {
            return this.incr;
        }

        public void setRegular(String incr) {
            this.incr = incr;
        }
    }

    public class CoordinateSystemBean {
        CoordinateSystem coordSys;
        private String name;
        private String ctNames;
        private String dataType = "";
        private int domainRank;
        private int rangeRank;
        private boolean isGeoXY;
        private boolean isLatLon;
        private boolean isProductSet;
        private boolean isRegular;

        public CoordinateSystemBean() {
        }

        public CoordinateSystemBean(CoordinateSystem cs) {
            this.coordSys = cs;
            this.setCoordSys(cs.getName());
            this.setGeoXY(cs.isGeoXY());
            this.setLatLon(cs.isLatLon());
            this.setProductSet(cs.isProductSet());
            this.setRegular(cs.isRegular());
            this.setDomainRank(cs.getDomain().size());
            this.setRangeRank(cs.getCoordinateAxes().size());
            if (GridCoordSys.isGridCoordSys(CoordSysTable.this.parseInfo, cs, null)) {
                this.addDataType("grid");
            }
            if (RadialCoordSys.isRadialCoordSys(CoordSysTable.this.parseInfo, cs)) {
                this.addDataType("radial");
            }
            StringBuilder buff = new StringBuilder();
            List<CoordinateTransform> ctList = cs.getCoordinateTransforms();
            for (int i = 0; i < ctList.size(); ++i) {
                ProjectionCT pct;
                CoordinateTransform ct = ctList.get(i);
                if (i > 0) {
                    buff.append(" ");
                }
                buff.append((Object)ct.getTransformType());
                if (ct instanceof VerticalCT) {
                    buff.append("(").append(((VerticalCT)ct).getVerticalTransformType()).append(")");
                }
                if (!(ct instanceof ProjectionCT) || (pct = (ProjectionCT)ct).getProjection() == null) continue;
                buff.append("(").append(pct.getProjection().getClassName()).append(")");
            }
            this.setCoordTransforms(buff.toString());
        }

        public String getCoordSys() {
            return this.name;
        }

        public void setCoordSys(String name) {
            this.name = name;
        }

        public boolean isGeoXY() {
            return this.isGeoXY;
        }

        public void setGeoXY(boolean isGeoXY) {
            this.isGeoXY = isGeoXY;
        }

        public boolean getLatLon() {
            return this.isLatLon;
        }

        public void setLatLon(boolean isLatLon) {
            this.isLatLon = isLatLon;
        }

        public boolean isProductSet() {
            return this.isProductSet;
        }

        public void setProductSet(boolean isProductSet) {
            this.isProductSet = isProductSet;
        }

        public boolean isRegular() {
            return this.isRegular;
        }

        public void setRegular(boolean isRegular) {
            this.isRegular = isRegular;
        }

        public int getDomainRank() {
            return this.domainRank;
        }

        public void setDomainRank(int domainRank) {
            this.domainRank = domainRank;
        }

        public int getRangeRank() {
            return this.rangeRank;
        }

        public void setRangeRank(int rangeRank) {
            this.rangeRank = rangeRank;
        }

        public String getCoordTransforms() {
            return this.ctNames;
        }

        public void setCoordTransforms(String ctNames) {
            this.ctNames = ctNames;
        }

        public String getDataType() {
            return this.dataType;
        }

        void addDataType(String dt) {
            this.dataType = this.dataType + " " + dt;
        }

        public boolean isImplicit() {
            return this.coordSys.isImplicit();
        }
    }

    public class VariableBean {
        VariableEnhanced ve;
        CoordinateSystem firstCoordSys = null;
        String name;
        String desc;
        String units;
        String axisType = "";
        String positive = "";
        String dims;
        String shape;
        String csNames;
        String dataType = "";
        boolean isCoordVar;
        boolean axis;

        public VariableBean() {
        }

        public VariableBean(VariableEnhanced v) {
            this.ve = v;
            this.setName(v.getFullName());
            this.setDescription(v.getDescription());
            this.setUnits(v.getUnitsString());
            StringBuilder lens = new StringBuilder();
            StringBuilder names = new StringBuilder();
            List<Dimension> dims = v.getDimensions();
            for (int j = 0; j < dims.size(); ++j) {
                Dimension dim = dims.get(j);
                if (j > 0) {
                    lens.append(",");
                    names.append(",");
                }
                String name = dim.isShared() ? dim.getName() : "anon";
                names.append(name);
                lens.append(dim.getLength());
            }
            this.setDims(names.toString());
            this.setShape(lens.toString());
            StringBuilder buff = new StringBuilder();
            List<CoordinateSystem> csList = v.getCoordinateSystems();
            for (CoordinateSystem cs : csList) {
                if (this.firstCoordSys == null) {
                    this.firstCoordSys = cs;
                } else {
                    buff.append("; ");
                }
                buff.append(cs.getName());
                Formatter gridBuff = new Formatter();
                if (!GridCoordSys.isGridCoordSys(gridBuff, cs, v)) continue;
                this.addDataType("grid");
            }
            this.setCoordSys(buff.toString());
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDataType() {
            return this.dataType;
        }

        void addDataType(String dt) {
            this.dataType = this.dataType + " " + dt;
        }

        public String getDims() {
            return this.dims;
        }

        public void setDims(String dims) {
            this.dims = dims;
        }

        public String getShape() {
            return this.shape;
        }

        public void setShape(String shape) {
            this.shape = shape;
        }

        public String getDescription() {
            return this.desc;
        }

        public void setDescription(String desc) {
            this.desc = desc;
        }

        public String getUnits() {
            return this.units;
        }

        public void setUnits(String units) {
            this.units = units == null ? "null" : units;
        }

        public String getCoordSys() {
            return this.csNames;
        }

        public void setCoordSys(String csNames) {
            this.csNames = csNames;
        }
    }
}

