/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dods;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import opendap.dap.Attribute;
import opendap.dap.AttributeTable;
import opendap.dap.BaseType;
import opendap.dap.BaseTypePrimitiveVector;
import opendap.dap.DAP2Exception;
import opendap.dap.DAS;
import opendap.dap.DArray;
import opendap.dap.DArrayDimension;
import opendap.dap.DConnect;
import opendap.dap.DConstructor;
import opendap.dap.DDS;
import opendap.dap.DGrid;
import opendap.dap.DList;
import opendap.dap.DSequence;
import opendap.dap.DStructure;
import opendap.dap.DataDDS;
import opendap.dap.NoSuchVariableException;
import opendap.dap.PrimitiveVector;
import opendap.dap.parsers.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.dods.DODSAttribute;
import ucar.nc2.dods.DODSNetcdfFile;

class DodsV
implements Comparable {
    private static Logger logger = LoggerFactory.getLogger(DodsV.class);
    private static boolean debugAttributes = false;
    DodsV parent;
    BaseType bt;
    BaseType elemType;
    List<DodsV> children = new ArrayList<DodsV>();
    DArray darray;
    List<DArrayDimension> dimensions = new ArrayList<DArrayDimension>();
    List<DArrayDimension> dimensionsAll = new ArrayList<DArrayDimension>();
    List<DODSAttribute> attributes = new ArrayList<DODSAttribute>();
    Array data;
    boolean isDone;
    int seq;
    private int nextInSequence = 0;

    static DodsV parseDDS(DDS dds) {
        DodsV root = new DodsV(null, null);
        Enumeration variables = dds.getVariables();
        DodsV.parseVariables(root, variables);
        root.assignSequence(root);
        return root;
    }

    private static void parseVariables(DodsV parent, Enumeration children) {
        while (children.hasMoreElements()) {
            BaseType bt = (BaseType)children.nextElement();
            if (bt instanceof DList) {
                String mess = "Variables of type " + bt.getClass().getName() + " are not supported.";
                logger.warn(mess);
                continue;
            }
            DodsV dodsV = new DodsV(parent, bt);
            if (bt instanceof DConstructor) {
                DConstructor dcon = (DConstructor)bt;
                Enumeration enumerate2 = dcon.getVariables();
                DodsV.parseVariables(dodsV, enumerate2);
            } else if (bt instanceof DArray) {
                BaseType elemType;
                DArray da = (DArray)bt;
                Enumeration e = da.getDimensions();
                while (e.hasMoreElements()) {
                    DArrayDimension dim = (DArrayDimension)e.nextElement();
                    if (dim.getSize() > 0) continue;
                    return;
                }
                dodsV.bt = elemType = da.getPrimitiveVector().getTemplate();
                dodsV.darray = da;
                if (elemType instanceof DGrid || elemType instanceof DSequence || elemType instanceof DList) {
                    String mess = "Arrays of type " + elemType.getClass().getName() + " are not supported.";
                    logger.warn(mess);
                    continue;
                }
                if (elemType instanceof DStructure) {
                    DConstructor dcon = (DConstructor)elemType;
                    Enumeration nestedVariables = dcon.getVariables();
                    DodsV.parseVariables(dodsV, nestedVariables);
                }
            }
            parent.children.add(dodsV);
        }
    }

    static DodsV parseDataDDS(DataDDS dds) throws NoSuchVariableException {
        DodsV root = new DodsV(null, null);
        Enumeration variables = dds.getVariables();
        DodsV.parseDataVariables(root, variables);
        root.assignSequence(root);
        return root;
    }

    private static void parseDataVariables(DodsV parent, Enumeration children) throws NoSuchVariableException {
        while (children.hasMoreElements()) {
            DStructure dcon;
            Enumeration enumerate2;
            BaseType bt = (BaseType)children.nextElement();
            DodsV dodsV = new DodsV(parent, bt);
            parent.children.add(dodsV);
            if (bt instanceof DGrid) {
                DGrid dgrid = (DGrid)bt;
                if (dodsV.parent.bt == null) {
                    dodsV.darray = (DArray)dgrid.getVar(0);
                    DodsV.processDArray(dodsV);
                } else {
                    dodsV.makeAllDimensions();
                }
                enumerate2 = dgrid.getVariables();
                DodsV.parseDataVariables(dodsV, enumerate2);
                continue;
            }
            if (bt instanceof DSequence) {
                DSequence dseq = (DSequence)bt;
                int seqlen = dseq.getRowCount();
                if (seqlen > 0) {
                    DArrayDimension ddim = new DArrayDimension(seqlen, null);
                    dodsV.dimensions.add(ddim);
                }
                dodsV.makeAllDimensions();
                Enumeration enumerate22 = dseq.getVariables();
                DodsV.parseDataVariables(dodsV, enumerate22);
                continue;
            }
            if (bt instanceof DConstructor) {
                dcon = (DStructure)bt;
                dodsV.makeAllDimensions();
                enumerate2 = dcon.getVariables();
                DodsV.parseDataVariables(dodsV, enumerate2);
                continue;
            }
            if (bt instanceof DArray) {
                dodsV.darray = (DArray)bt;
                DodsV.processDArray(dodsV);
                dodsV.bt = dodsV.elemType;
                if (!(dodsV.elemType instanceof DStructure)) continue;
                dcon = (DStructure)dodsV.elemType;
                Enumeration nestedVariables = dcon.getVariables();
                DodsV.parseDataVariables(dodsV, nestedVariables);
                continue;
            }
            dodsV.makeAllDimensions();
        }
    }

    private static void processDArray(DodsV dodsV) {
        BaseType elemType;
        DArray da = dodsV.darray;
        Enumeration dims = da.getDimensions();
        while (dims.hasMoreElements()) {
            DArrayDimension dim = (DArrayDimension)dims.nextElement();
            dodsV.dimensions.add(dim);
        }
        dodsV.makeAllDimensions();
        PrimitiveVector pv = da.getPrimitiveVector();
        if (pv instanceof BaseTypePrimitiveVector) {
            BaseTypePrimitiveVector bpv = (BaseTypePrimitiveVector)pv;
            elemType = bpv.getValue(0);
        } else {
            elemType = da.getPrimitiveVector().getTemplate();
        }
        dodsV.elemType = elemType;
        if (dodsV.elemType instanceof DGrid || dodsV.elemType instanceof DSequence || dodsV.elemType instanceof DList) {
            String mess = "Arrays of type " + dodsV.bt.getClass().getName() + " are not supported.";
            logger.error(mess);
            throw new IllegalArgumentException(mess);
        }
    }

    DodsV(DodsV parent, BaseType bt) {
        this.parent = parent;
        this.bt = bt;
        this.elemType = bt;
    }

    public int compareTo(Object o) {
        return this.seq - ((DodsV)o).seq;
    }

    void show(PrintStream out, String space) {
        out.print(space + "DodsV.show " + this.getName() + " " + this.getType());
        out.print("(");
        int count = 0;
        for (DArrayDimension dim : this.dimensionsAll) {
            String name;
            String string = name = dim.getEncodedName() == null ? "" : dim.getEncodedName() + "=";
            if (count > 0) {
                out.print(",");
            }
            out.print(name + dim.getSize());
            ++count;
        }
        out.println(")");
        for (DodsV dodsV : this.children) {
            dodsV.show(out, space + "  ");
        }
    }

    String getName() {
        return this.bt == null ? " root" : this.bt.getEncodedName();
    }

    String getType() {
        return this.bt == null ? "" : this.bt.getTypeName();
    }

    DataType getDataType() {
        if (this.bt == null) {
            return null;
        }
        if (this.bt instanceof DGrid) {
            DODSNetcdfFile.convertToNCType(this.elemType);
        }
        return DODSNetcdfFile.convertToNCType(this.bt);
    }

    int[] getShape() {
        int[] shape = new int[this.dimensions.size()];
        for (int i = 0; i < this.dimensions.size(); ++i) {
            DArrayDimension dim = this.dimensions.get(i);
            shape[i] = dim.getSize();
        }
        return shape;
    }

    int[] getShapeAll() {
        if (this.bt instanceof DSequence) {
            DSequence dseq = (DSequence)this.bt;
            int seqlen = dseq.getRowCount();
            return new int[]{seqlen};
        }
        int[] shape = new int[this.dimensionsAll.size()];
        for (int i = 0; i < this.dimensionsAll.size(); ++i) {
            DArrayDimension dim = this.dimensionsAll.get(i);
            shape[i] = dim.getSize();
        }
        return shape;
    }

    void addAttribute(DODSAttribute att) {
        this.attributes.add(att);
    }

    void makeAllDimensions() {
        this.dimensionsAll = new ArrayList<DArrayDimension>();
        if (this.parent != null) {
            this.dimensionsAll.addAll(this.parent.dimensionsAll);
        }
        this.dimensionsAll.addAll(this.dimensions);
    }

    String getFullName() {
        if (this.parent != null && this.parent.bt != null) {
            return this.parent.getFullName() + "." + this.bt.getEncodedName();
        }
        return this.bt == null ? "root" : this.bt.getEncodedName();
    }

    String getNetcdfShortName() {
        return DODSNetcdfFile.makeNetcdfName(this.getName());
    }

    private void assignSequence(DodsV root) {
        for (DodsV nested : this.children) {
            nested.assignSequence(root);
            nested.seq = root.nextInSequence;
            ++this.nextInSequence;
        }
    }

    void parseDAS(DAS das) throws IOException {
        Enumeration tableNames = das.getNames();
        while (tableNames.hasMoreElements()) {
            String tableName = (String)tableNames.nextElement();
            AttributeTable attTable = das.getAttributeTableN(tableName);
            if (tableName.equals("NC_GLOBAL") || tableName.equals("HDF_GLOBAL")) {
                this.addAttributeTable(this, attTable, tableName, true);
                continue;
            }
            if (tableName.equals("DODS_EXTRA") || tableName.equals("EXTRA_DIMENSION")) continue;
            DodsV dodsV = this.findDodsV(tableName, false);
            if (dodsV != null) {
                this.addAttributeTable(dodsV, attTable, tableName, true);
                continue;
            }
            dodsV = this.findTableDotDelimited(tableName);
            if (dodsV != null) {
                this.addAttributeTable(dodsV, attTable, tableName, true);
                continue;
            }
            if (debugAttributes) {
                System.out.println("DODSNetcdf getAttributes CANT find <" + tableName + "> add to globals");
            }
            this.addAttributeTable(this, attTable, tableName, false);
        }
    }

    private void addAttributeTable(DodsV dodsV, AttributeTable attTable, String fullName, boolean match) {
        if (attTable == null) {
            return;
        }
        Enumeration attNames = attTable.getNames();
        while (attNames.hasMoreElements()) {
            String attName = (String)attNames.nextElement();
            Attribute att = attTable.getAttribute(attName);
            if (att == null) {
                logger.error("Attribute not found=" + attName + " in table=" + attTable.getEncodedName());
                continue;
            }
            this.addAttribute(dodsV, att, fullName, match);
        }
    }

    private void addAttribute(DodsV dodsV, Attribute att, String fullName, boolean match) {
        if (att == null) {
            return;
        }
        fullName = fullName + "." + att.getEncodedName();
        if (!att.isContainer()) {
            DODSAttribute ncatt = new DODSAttribute(match ? att.getEncodedName() : fullName, att);
            dodsV.addAttribute(ncatt);
            if (debugAttributes) {
                System.out.println(" addAttribute " + ncatt.getName() + " to " + dodsV.getFullName());
            }
        } else if (att.getEncodedName() == null) {
            logger.info("DODS attribute name is null = " + att);
        } else {
            DodsV child = dodsV.findDodsV(att.getEncodedName(), false);
            if (child != null) {
                this.addAttributeTable(child, att.getContainerN(), fullName, match);
            } else {
                if (att.getEncodedName().equals("DODS")) {
                    return;
                }
                if (debugAttributes) {
                    System.out.println(" Cant find nested Variable " + att.getEncodedName() + " in " + dodsV.getFullName());
                }
                this.addAttributeTable(this, att.getContainerN(), fullName, false);
            }
        }
    }

    DodsV findDodsV(String name, boolean useDone) {
        for (DodsV dodsV : this.children) {
            if (useDone && dodsV.isDone) continue;
            if (name == null || dodsV == null || dodsV.bt == null) {
                logger.warn("Corrupted structure");
                continue;
            }
            if (!name.equals(dodsV.bt.getEncodedName())) continue;
            return dodsV;
        }
        return null;
    }

    DodsV findByNetcdfShortName(String ncname) {
        for (DodsV child : this.children) {
            if (!ncname.equals(child.getNetcdfShortName())) continue;
            return child;
        }
        return null;
    }

    DodsV findByDodsShortName(String dodsname) {
        for (DodsV child : this.children) {
            if (!dodsname.equals(child.getName())) continue;
            return child;
        }
        for (DodsV child : this.children) {
            DodsV d = child.findByDodsShortName(dodsname);
            if (null == d) continue;
            return d;
        }
        return null;
    }

    DodsV findDataV(DodsV ddsV) {
        if (ddsV.parent.bt != null) {
            DodsV parentV = this.findDataV(ddsV.parent);
            if (parentV == null) {
                return this.findDodsV(ddsV.bt.getEncodedName(), true);
            }
            return parentV.findDodsV(ddsV.bt.getEncodedName(), true);
        }
        DodsV dataV = this.findDodsV(ddsV.bt.getEncodedName(), true);
        return dataV;
    }

    DodsV findTableDotDelimited(String tableName) {
        DodsV dodsV = this;
        StringTokenizer toker = new StringTokenizer(tableName, ".");
        while (toker.hasMoreTokens()) {
            String name = toker.nextToken();
            if ((dodsV = dodsV.findDodsV(name, false)) != null) continue;
            return null;
        }
        return dodsV;
    }

    private static void doit(String urlName) throws IOException, DAP2Exception, ParseException {
        System.out.println("DODSV read =" + urlName);
        DConnect dodsConnection = new DConnect(urlName, true);
        DDS dds = dodsConnection.getDDS();
        dds.print((OutputStream)System.out);
        DodsV root = DodsV.parseDDS(dds);
        DAS das = dodsConnection.getDAS();
        das.print((OutputStream)System.out);
        root.parseDAS(das);
        root.show(System.out, "");
    }

    public static void main(String[] args) throws IOException, ParseException, DAP2Exception {
        DodsV.doit("http://iridl.ldeo.columbia.edu/SOURCES/.CAYAN/dods");
    }
}

