/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui.monitor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import thredds.filesystem.CacheManager;
import thredds.ui.monitor.CacheTable;
import thredds.ui.monitor.TdsDownloader;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.FileManager;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.XMLStore;
import ucar.util.prefs.ui.ComboBox;
import ucar.util.prefs.ui.Debug;

public class CacheViewer
extends JPanel {
    private static final String FRAME_SIZE = "FrameSize";
    private static JFrame frame;
    private static PreferencesExt prefs;
    private static XMLStore store;
    private PreferencesExt mainPrefs;
    private JTabbedPane tabbedPane;
    private CachePanel cachePanel;
    private JFrame parentFrame;
    private FileManager fileChooser;
    private static CacheViewer ui;
    private static boolean done;

    public CacheViewer(PreferencesExt prefs, JFrame parentFrame) {
        this.mainPrefs = prefs;
        this.parentFrame = parentFrame;
        this.fileChooser = new FileManager(parentFrame, null, null, (PreferencesExt)prefs.node("FileManager"));
        this.fileChooser.getFileChooser().setFileSelectionMode(2);
        this.fileChooser.getFileChooser().setDialogTitle("Ehcache Directory");
        this.tabbedPane = new JTabbedPane(1);
        this.cachePanel = new CachePanel((PreferencesExt)this.mainPrefs.node("LogTable"));
        this.tabbedPane.addTab("ehcache", this.cachePanel);
        this.tabbedPane.setSelectedIndex(0);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
    }

    public void exit() {
        CacheManager.shutdown();
        this.fileChooser.save();
        this.cachePanel.save();
        Rectangle bounds = frame.getBounds();
        prefs.putBeanObject(FRAME_SIZE, bounds);
        try {
            store.save();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        done = true;
        System.exit(0);
    }

    public static void main(String[] args) {
        try {
            String prefStore = XMLStore.makeStandardFilename(".unidata", "CacheViewer.xml");
            store = XMLStore.createFromFile(prefStore, null);
            prefs = store.getPreferences();
            Debug.setStore(prefs.node("Debug"));
        }
        catch (IOException e) {
            System.out.println("XMLStore Creation failed " + e);
        }
        BAMutil.setResourcePath("/resources/nj22/ui/icons/");
        frame = new JFrame("Cache Viewer");
        ui = new CacheViewer(prefs, frame);
        frame.setIconImage(BAMutil.getImage("netcdfUI"));
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!done) {
                    ui.exit();
                }
            }
        });
        frame.getContentPane().add(ui);
        Rectangle bounds = (Rectangle)prefs.getBean(FRAME_SIZE, new Rectangle(50, 50, 800, 450));
        frame.setBounds(bounds);
        frame.pack();
        frame.setBounds(bounds);
        frame.setVisible(true);
    }

    static {
        done = false;
    }

    private class CachePanel
    extends OpPanel {
        CacheTable cacheTable;
        TdsDownloader logManager;

        CachePanel(PreferencesExt p) {
            super(p);
            this.logManager = null;
            this.cacheTable = new CacheTable((PreferencesExt)CacheViewer.this.mainPrefs.node("CacheTable"), this.buttPanel);
            this.cacheTable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("UrlDump")) {
                        String string = (String)e.getNewValue();
                    }
                }
            });
            this.add((Component)this.cacheTable, "Center");
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            try {
                CacheManager.makeReadOnlyCacheManager(command, "directories");
                this.cacheTable.setCache(CacheManager.getEhcache());
            }
            catch (Exception e) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(5000);
                e.printStackTrace();
                e.printStackTrace(new PrintStream(bos));
                this.ta.setText(bos.toString());
                err = true;
            }
            return !err;
        }

        @Override
        void save() {
            this.cacheTable.exit();
            super.save();
        }
    }

    private abstract class OpPanel
    extends JPanel {
        PreferencesExt prefs;
        TextHistoryPane ta;
        ComboBox fileCB;
        JPanel buttPanel;
        boolean addCoords;
        boolean defer;
        boolean busy;
        long lastEvent = -1L;
        boolean eventOK = true;
        IndependentWindow detailWindow;
        TextHistoryPane detailTA;

        OpPanel(PreferencesExt prefs) {
            this.prefs = prefs;
            this.ta = new TextHistoryPane(true);
            this.fileCB = new ComboBox((PreferencesExt)prefs.node("files"));
            this.fileCB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getWhen() != OpPanel.this.lastEvent && OpPanel.this.eventOK) {
                        OpPanel.this.doit(OpPanel.this.fileCB.getSelectedItem());
                        OpPanel.this.lastEvent = e.getWhen();
                    }
                }
            });
            this.buttPanel = new JPanel(new FlowLayout(0, 5, 0));
            AbstractAction fileAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File[] files = CacheViewer.this.fileChooser.chooseFiles();
                    if (files == null || files.length == 0) {
                        return;
                    }
                    if (files.length == 1) {
                        OpPanel.this.fileCB.setSelectedItem(files[0].getPath());
                    }
                }
            };
            BAMutil.setActionProperties(fileAction, "FileChooser", "open Local dataset...", false, 76, -1);
            BAMutil.addActionToContainer(this.buttPanel, fileAction);
            JPanel flowPanel = new JPanel(new FlowLayout());
            flowPanel.add(new JLabel("server:"));
            flowPanel.add(new JLabel("file:"));
            flowPanel.add(this.fileCB);
            JPanel topPanel = new JPanel(new BorderLayout());
            topPanel.add((Component)flowPanel, "Center");
            topPanel.add((Component)this.buttPanel, "East");
            this.setLayout(new BorderLayout());
            this.add((Component)topPanel, "North");
            this.add((Component)this.ta, "Center");
            this.detailTA = new TextHistoryPane();
            this.detailTA.setFont(new Font("Monospaced", 0, 12));
            this.detailWindow = new IndependentWindow("Details", BAMutil.getImage("netcdfUI"), new JScrollPane(this.detailTA));
            Rectangle bounds = (Rectangle)prefs.getBean(CacheViewer.FRAME_SIZE, new Rectangle(200, 50, 500, 700));
            this.detailWindow.setBounds(bounds);
        }

        void doit(Object command) {
            if (this.busy) {
                return;
            }
            if (command == null) {
                return;
            }
            if (command instanceof String) {
                command = ((String)command).trim();
            }
            this.busy = true;
            if (this.process(command) && !this.defer) {
                this.fileCB.addItem(command);
            }
            this.busy = false;
        }

        abstract boolean process(Object var1);

        void save() {
            this.fileCB.save();
            if (this.detailWindow != null) {
                this.prefs.putBeanObject(CacheViewer.FRAME_SIZE, this.detailWindow.getBounds());
            }
        }

        void setSelectedItem(Object item) {
            this.eventOK = false;
            this.fileCB.setSelectedItem(item);
            this.eventOK = true;
        }
    }
}

