/*
 * Decompiled with CFR 0.152.
 */
package scalala.tensor.dense;

import scala.Function1$class;
import scala.PartialFunction$class;
import scala.Tuple2;
import scala.runtime.ScalaRunTime$;
import scalala.operators.MatrixOps$class;
import scalala.operators.MutableNumericOps$class;
import scalala.operators.NumericOps$class;
import scalala.scalar.Scalar;
import scalala.tensor.DomainFunction$class;
import scalala.tensor.MatrixLike$class;
import scalala.tensor.Tensor2Like$class;
import scalala.tensor.TensorLike$class;
import scalala.tensor.dense.DenseArrayTensor;
import scalala.tensor.dense.DenseArrayTensorLike;
import scalala.tensor.dense.DenseArrayTensorLike$class;
import scalala.tensor.domain.TableDomain;
import scalala.tensor.mutable.Matrix;
import scalala.tensor.mutable.MatrixLike;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DenseMatrix<V>
implements DenseArrayTensor<Tuple2<Object, Object>, V>,
DenseArrayTensorLike<Tuple2<Object, Object>, V, TableDomain, DenseMatrix<V>>,
Matrix<V>,
MatrixLike<V, DenseMatrix<V>> {
    private final int numRows;
    private final int numCols;
    private final Scalar<V> scalar;
    private final Object data;

    @Override
    public int numRows() {
        return this.numRows;
    }

    @Override
    public int numCols() {
        return this.numCols;
    }

    @Override
    public Scalar<V> scalar() {
        return this.scalar;
    }

    @Override
    public Object data() {
        return this.data;
    }

    public final int index(int row, int col) {
        this.checkKey(row, col);
        return row + col * this.numRows();
    }

    @Override
    public V apply(int row, int col) {
        return (V)ScalaRunTime$.MODULE$.array_apply(this.data(), this.index(row, col));
    }

    @Override
    public void update(int row, int col, V value) {
        ScalaRunTime$.MODULE$.array_update(this.data(), this.index(row, col), value);
    }

    public DenseMatrix(int numRows, int numCols, Object data_, Scalar<V> scalar) {
        this.numRows = numRows;
        this.numCols = numCols;
        this.scalar = scalar;
        Function1$class.$init$(this);
        PartialFunction$class.$init$(this);
        DomainFunction$class.$init$(this);
        NumericOps$class.$init$(this);
        TensorLike$class.$init$(this);
        MutableNumericOps$class.$init$(this);
        scalala.tensor.mutable.TensorLike$class.$init$(this);
        DenseArrayTensorLike$class.$init$(this);
        MatrixOps$class.$init$(this);
        Tensor2Like$class.$init$(this);
        MatrixLike$class.$init$(this);
        scalala.tensor.mutable.Tensor2Like$class.$init$(this);
        scalala.tensor.mutable.MatrixLike$class.$init$(this);
        this.data = data_;
        if (numRows * numCols != ScalaRunTime$.MODULE$.array_length(data_)) {
            throw new IllegalArgumentException("data.length must equal numRows*numCols");
        }
    }
}

