/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.util.Arrays;
import scala.Function1;
import scala.collection.GenTraversableOnce$class;
import scala.collection.Iterator;
import scala.collection.Iterator$class;
import scala.collection.TraversableOnce$class;
import scala.collection.mutable.HashEntry;
import scala.collection.mutable.HashTable;
import scala.collection.mutable.HashTable$;
import scala.runtime.BoxesRunTime;

public abstract class HashTable$class {
    public static HashEntry findEntry(HashTable $this, Object key) {
        int h = $this.index($this.elemHashCode(key));
        HashEntry e = $this.table()[h];
        while (e != null && !$this.elemEquals(e.key(), key)) {
            e = (HashEntry)e.next();
        }
        return e;
    }

    public static void addEntry(HashTable $this, HashEntry e) {
        int h = $this.index($this.elemHashCode(e.key()));
        e.next_$eq($this.table()[h]);
        $this.table()[h] = e;
        $this.tableSize_$eq($this.tableSize() + 1);
        $this.nnSizeMapAdd(h);
        if ($this.tableSize() > $this.threshold()) {
            HashTable$class.resize($this, 2 * $this.table().length);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HashEntry removeEntry(HashTable $this, Object key) {
        int h = $this.index($this.elemHashCode(key));
        HashEntry e = $this.table()[h];
        if (e == null) return null;
        if ($this.elemEquals(e.key(), key)) {
            $this.table()[h] = (HashEntry)e.next();
            $this.tableSize_$eq($this.tableSize() - 1);
            $this.nnSizeMapRemove(h);
            return e;
        }
        HashEntry e1 = (HashEntry)e.next();
        while (true) {
            if (e1 == null || $this.elemEquals(e1.key(), key)) {
                if (e1 == null) {
                    return null;
                }
                e.next_$eq(e1.next());
                $this.tableSize_$eq($this.tableSize() - 1);
                $this.nnSizeMapRemove(h);
                return e1;
            }
            e = e1;
            e1 = (HashEntry)e1.next();
        }
    }

    public static Iterator entriesIterator(HashTable $this) {
        return new Iterator<Entry>($this){
            private final HashEntry<A, Entry>[] iterTable;
            private int idx;
            private Entry es;

            private HashEntry<A, Entry>[] iterTable() {
                return this.iterTable;
            }

            private int idx() {
                return this.idx;
            }

            private void idx_$eq(int n) {
                this.idx = n;
            }

            private Entry es() {
                return this.es;
            }

            private void es_$eq(Entry Entry2) {
                this.es = Entry2;
            }

            public boolean hasNext() {
                return this.es() != null;
            }

            /*
             * WARNING - void declaration
             */
            public Entry next() {
                void var1_1;
                Entry res = this.es();
                this.es_$eq((HashEntry)this.es().next());
                this.scan();
                return var1_1;
            }

            private void scan() {
                while (this.es() == null && this.idx() > 0) {
                    this.idx_$eq(this.idx() - 1);
                    this.es_$eq(this.iterTable()[this.idx()]);
                }
            }
            {
                GenTraversableOnce$class.$init$(this);
                TraversableOnce$class.$init$(this);
                Iterator$class.$init$(this);
                this.iterTable = $outer.table();
                this.idx = $outer.table().length - 1;
                this.es = this.iterTable()[this.idx()];
                this.scan();
            }
        };
    }

    public static final void foreachEntry(HashTable $this, Function1 f) {
        $this.entriesIterator().foreach(f);
    }

    private static void resize(HashTable $this, int newSize) {
        HashEntry<A, Entry>[] oldTable = $this.table();
        $this.table_$eq(new HashEntry[newSize]);
        $this.nnSizeMapReset($this.table().length);
        block0: for (int i = oldTable.length - 1; i >= 0; --i) {
            HashEntry e = oldTable[i];
            while (true) {
                if (e == null) {
                    continue block0;
                }
                int h = $this.index($this.elemHashCode(e.key()));
                HashEntry e1 = (HashEntry)e.next();
                e.next_$eq($this.table()[h]);
                $this.table()[h] = e;
                e = e1;
                $this.nnSizeMapAdd(h);
            }
        }
        $this.threshold_$eq(HashTable$.MODULE$.newThreshold($this._loadFactor(), newSize));
    }

    public static void nnSizeMapAdd(HashTable $this, int h) {
        if ($this.sizemap() != null) {
            int[] nArray = $this.sizemap();
            int n = h >> $this.sizeMapBucketBitSize();
            nArray[n] = nArray[n] + 1;
        }
    }

    public static void nnSizeMapRemove(HashTable $this, int h) {
        if ($this.sizemap() != null) {
            int[] nArray = $this.sizemap();
            int n = h >> $this.sizeMapBucketBitSize();
            nArray[n] = nArray[n] - 1;
        }
    }

    public static void nnSizeMapReset(HashTable $this, int tableLength) {
        if ($this.sizemap() != null) {
            int nsize = $this.calcSizeMapSize(tableLength);
            if ($this.sizemap().length != nsize) {
                $this.sizemap_$eq(new int[nsize]);
            } else {
                Arrays.fill($this.sizemap(), 0);
            }
        }
    }

    public static final int totalSizeMapBuckets(HashTable $this) {
        return $this.sizeMapBucketSize() < $this.table().length ? 1 : $this.table().length / $this.sizeMapBucketSize();
    }

    public static int calcSizeMapSize(HashTable $this, int tableLength) {
        return (tableLength >> $this.sizeMapBucketBitSize()) + 1;
    }

    public static void sizeMapInit(HashTable $this, int tableLength) {
        $this.sizemap_$eq(new int[$this.calcSizeMapSize(tableLength)]);
    }

    public static void sizeMapInitAndRebuild(HashTable $this) {
        $this.sizeMapInit($this.table().length);
        int tableidx = 0;
        HashEntry<A, Entry>[] tbl = $this.table();
        int tableuntil = tbl.length < $this.sizeMapBucketSize() ? tbl.length : $this.sizeMapBucketSize();
        int totalbuckets = $this.totalSizeMapBuckets();
        for (int bucketidx = 0; bucketidx < totalbuckets; ++bucketidx) {
            int currbucketsize = 0;
            while (tableidx < tableuntil) {
                for (HashEntry e = tbl[tableidx]; e != null; e = (HashEntry)e.next()) {
                    ++currbucketsize;
                }
                ++tableidx;
            }
            $this.sizemap()[bucketidx] = currbucketsize;
            tableuntil += $this.sizeMapBucketSize();
        }
    }

    public static boolean alwaysInitSizeMap(HashTable $this) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean elemEquals(HashTable $this, Object key1, Object key2) {
        void y1;
        void x1;
        Object object = key1;
        Object object2 = key2;
        return object == object2 ? true : (x1 == null ? false : (x1 instanceof Number ? BoxesRunTime.equalsNumObject((Number)x1, y1) : (x1 instanceof Character ? BoxesRunTime.equalsCharObject((Character)x1, y1) : x1.equals(y1))));
    }

    public static final int index(HashTable $this, int hcode) {
        int ones = $this.table().length - 1;
        int improved = $this.improve(hcode);
        int shifted = improved >> 32 - Integer.bitCount(ones) & ones;
        return shifted;
    }

    public static void initWithContents(HashTable $this, HashTable.Contents c) {
        if (c != null) {
            $this._loadFactor_$eq(c.loadFactor());
            $this.table_$eq(c.table());
            $this.tableSize_$eq(c.tableSize());
            $this.threshold_$eq(c.threshold());
            $this.sizemap_$eq(c.sizemap());
        }
        if ($this.alwaysInitSizeMap() && $this.sizemap() == null) {
            $this.sizeMapInitAndRebuild();
        }
    }

    public static void $init$(HashTable $this) {
        $this._loadFactor_$eq(HashTable$.MODULE$.defaultLoadFactor());
        $this.table_$eq(new HashEntry[HashTable$.MODULE$.initialCapacity()]);
        $this.tableSize_$eq(0);
        $this.threshold_$eq(HashTable$.MODULE$.initialThreshold($this._loadFactor()));
        $this.sizemap_$eq(null);
    }
}

