/*
 * Decompiled with CFR 0.152.
 */
package opendap.servlet;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Enumeration;
import opendap.Server.ServerDDS;
import opendap.dap.Attribute;
import opendap.dap.AttributeTable;
import opendap.dap.BaseType;
import opendap.dap.BaseTypePrimitiveVector;
import opendap.dap.DAP2Exception;
import opendap.dap.DAS;
import opendap.dap.DArray;
import opendap.dap.DConstructor;
import opendap.dap.DString;
import opendap.dap.DVector;
import opendap.dap.NoSuchAttributeException;
import opendap.dap.PrimitiveVector;
import opendap.dap.parsers.ParseException;
import opendap.servlet.GuardedDataset;
import opendap.servlet.ReqState;
import opendap.util.dasTools;

public class GetInfoHandler {
    private static final boolean _Debug = false;
    private String infoDir = null;

    public void sendINFO(PrintStream pw, GuardedDataset gds, ReqState rs) throws DAP2Exception, ParseException {
        String responseDoc = null;
        ServerDDS myDDS = null;
        DAS myDAS = null;
        myDDS = gds.getDDS();
        myDAS = gds.getDAS();
        this.infoDir = rs.getINFOCache();
        responseDoc = this.loadOverrideDoc(this.infoDir, rs.getDataSet());
        if (responseDoc != null) {
            pw.print(responseDoc);
        } else {
            String user_html = this.get_user_supplied_docs(rs.getServerClassName(), rs.getDataSet());
            String global_attrs = this.buildGlobalAttributes(myDAS, myDDS);
            String variable_sum = this.buildVariableSummaries(myDAS, myDDS);
            pw.println("<html><head><title>Dataset Information</title>");
            pw.println("<style type=\"text/css\">");
            pw.println("<!-- ul {list-style-type: none;} -->");
            pw.println("</style>");
            pw.println("</head>");
            pw.println("<body>");
            if (global_attrs.length() > 0) {
                pw.println(global_attrs);
                pw.println("<hr>");
            }
            pw.println(variable_sum);
            pw.println("<hr>");
            pw.println(user_html);
            pw.println("</body></html>");
            pw.flush();
        }
    }

    public String loadOverrideDoc(String infoDir, String dataSet) throws DAP2Exception {
        String userDoc = "";
        String overrideFile = dataSet + ".ovr";
        try {
            File fin = new File(infoDir + overrideFile);
            BufferedReader svIn = new BufferedReader(new InputStreamReader(new FileInputStream(fin)));
            boolean done = false;
            while (!done) {
                String line = svIn.readLine();
                if (line == null) {
                    done = true;
                    continue;
                }
                userDoc = userDoc + line + "\n";
            }
            svIn.close();
        }
        catch (FileNotFoundException fnfe) {
            userDoc = userDoc + "<h2>No Could Not Open Override Document.</h2><hr>";
            return null;
        }
        catch (IOException ioe) {
            throw new DAP2Exception(0, ioe.getMessage());
        }
        return userDoc;
    }

    private String get_user_supplied_docs(String serverName, String dataSet) throws DAP2Exception {
        String userDoc = "";
        try {
            File fin = new File(this.infoDir + dataSet + ".html");
            BufferedReader svIn = new BufferedReader(new InputStreamReader(new FileInputStream(fin)));
            boolean done = false;
            while (!done) {
                String line = svIn.readLine();
                if (line == null) {
                    done = true;
                    continue;
                }
                userDoc = userDoc + line + "\n";
            }
            svIn.close();
        }
        catch (FileNotFoundException fnfe) {
            userDoc = userDoc + "<h2>No Dataset Specific Information Available.</h2><hr>";
        }
        catch (IOException ioe) {
            throw new DAP2Exception(0, ioe.getMessage());
        }
        userDoc = userDoc + "<hr>\n";
        try {
            String serverFile = this.infoDir + serverName + ".html";
            File fin = new File(serverFile);
            BufferedReader svIn = new BufferedReader(new InputStreamReader(new FileInputStream(fin)));
            boolean done = false;
            while (!done) {
                String line = svIn.readLine();
                if (line == null) {
                    done = true;
                    continue;
                }
                userDoc = userDoc + line + "\n";
            }
            svIn.close();
        }
        catch (FileNotFoundException fnfe) {
            userDoc = userDoc + "<h2>No Server Specific Information Available.</h2><hr>";
        }
        catch (IOException ioe) {
            throw new DAP2Exception(0, ioe.getMessage());
        }
        return userDoc;
    }

    private String buildGlobalAttributes(DAS das, ServerDDS dds) {
        boolean found = false;
        String ga = "<h3>Dataset Information</h3>\n<table>\n";
        Enumeration edas = das.getNames();
        while (edas.hasMoreElements()) {
            String name = (String)edas.nextElement();
            if (dasTools.nameInKillFile(name) || !dasTools.nameIsGlobal(name) && dasTools.nameInDDS(name, dds)) continue;
            try {
                AttributeTable attr = das.getAttributeTable(name);
                Enumeration e = attr.getNames();
                while (e.hasMoreElements()) {
                    String aName = (String)e.nextElement();
                    Attribute a = attr.getAttribute(aName);
                    found = true;
                    ga = ga + "\n<tr><td align=right valign=top><b>";
                    ga = ga + aName + "</b>:</td>\n";
                    ga = ga + "<td align=left>";
                    Enumeration es = a.getValues();
                    while (es.hasMoreElements()) {
                        String val = (String)es.nextElement();
                        ga = ga + val + "<br>";
                    }
                    ga = ga + "</td></tr>\n";
                }
            }
            catch (NoSuchAttributeException nsae) {
            }
        }
        ga = ga + "</table>\n<p>\n";
        if (!found) {
            ga = "";
        }
        return ga;
    }

    private String buildVariableSummaries(DAS das, ServerDDS dds) {
        String vs = "<h3>Variables in this Dataset</h3>\n<table>\n";
        Enumeration e = dds.getVariables();
        while (e.hasMoreElements()) {
            BaseType bt = (BaseType)e.nextElement();
            vs = vs + "<tr>";
            vs = vs + this.summarizeVariable(bt, das);
            vs = vs + "</tr>";
        }
        vs = vs + "</table>\n<p>\n";
        return vs;
    }

    private String summarizeAttributes(AttributeTable attr, String vOut) {
        if (attr != null) {
            Enumeration e = attr.getNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Attribute a = attr.getAttribute(name);
                if (a == null) continue;
                if (a.isContainer()) {
                    vOut = vOut + "<li> <b> " + name + ": </b> </li>\n";
                    vOut = vOut + "<ul>\n";
                    try {
                        vOut = vOut + this.summarizeAttributes(a.getContainer(), "");
                    }
                    catch (NoSuchAttributeException nase) {
                        // empty catch block
                    }
                    vOut = vOut + "</ul>\n";
                    continue;
                }
                vOut = vOut + "<li> <b> " + name + ": </b> ";
                try {
                    Enumeration es = a.getValues();
                    while (es.hasMoreElements()) {
                        String val = (String)es.nextElement();
                        vOut = vOut + val;
                        if (!es.hasMoreElements()) continue;
                        vOut = vOut + ", ";
                    }
                }
                catch (NoSuchAttributeException nase) {
                    // empty catch block
                }
                vOut = vOut + " </li>\n";
            }
        }
        return vOut;
    }

    private String summarizeVariable(BaseType bt, DAS das) {
        String vOut = "<td align=right valign=top><b>" + bt.getEncodedName();
        vOut = vOut + "</b>:</td>\n";
        vOut = vOut + "<td align=left valign=top>" + dasTools.fancyTypeName(bt);
        try {
            BaseType bt2;
            DVector da;
            PrimitiveVector pv;
            AttributeTable attr = das.getAttributeTable(bt.getEncodedName());
            String s = "";
            vOut = vOut + "\n<ul>\n";
            vOut = vOut + this.summarizeAttributes(attr, s);
            vOut = vOut + "\n</ul>\n";
            if (bt instanceof DConstructor) {
                vOut = vOut + "<table>\n";
                DConstructor dc = (DConstructor)bt;
                Enumeration e = dc.getVariables();
                while (e.hasMoreElements()) {
                    BaseType bt22 = (BaseType)e.nextElement();
                    vOut = vOut + "<tr>\n";
                    vOut = vOut + this.summarizeVariable(bt22, das);
                    vOut = vOut + "</tr>\n";
                }
                vOut = vOut + "</table>\n";
            } else if (bt instanceof DVector && (pv = (da = (DVector)bt).getPrimitiveVector()) instanceof BaseTypePrimitiveVector && !((bt2 = pv.getTemplate()) instanceof DArray) && !(bt2 instanceof DString)) {
                vOut = vOut + "<table>\n";
                vOut = vOut + "<tr>\n";
                vOut = vOut + this.summarizeVariable(bt2, das);
                vOut = vOut + "</tr>\n";
                vOut = vOut + "</table>\n";
            }
        }
        catch (NoSuchAttributeException nsae) {
            // empty catch block
        }
        vOut = vOut + "</td>\n";
        return vOut;
    }
}

