/*
 * Decompiled with CFR 0.152.
 */
package opendap.Server;

import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import opendap.Server.CEEvaluator;
import opendap.Server.DAP2ServerSideException;
import opendap.Server.InvalidOperatorException;
import opendap.Server.RegExpException;
import opendap.Server.RelOps;
import opendap.Server.SBHException;
import opendap.Server.ServerMethods;
import opendap.dap.BaseType;
import opendap.dap.DStructure;
import opendap.dap.NoSuchVariableException;

public abstract class SDStructure
extends DStructure
implements ServerMethods,
RelOps {
    private boolean Synthesized = false;
    private boolean ReadMe = false;

    public SDStructure() {
    }

    public SDStructure(String n) {
        super(n);
    }

    public void printDecl(PrintWriter os, String space, boolean print_semi, boolean constrained) {
        if (constrained && !this.isProject()) {
            return;
        }
        super.printDecl(os, space, print_semi, constrained);
    }

    public void printVal(PrintWriter os, String space, boolean print_decl_p) {
        if (!this.isProject()) {
            return;
        }
        if (print_decl_p) {
            this.printDecl(os, space, false, true);
            os.print(" = ");
        }
        boolean first = true;
        os.print("{ ");
        Enumeration e = this.vars.elements();
        while (e.hasMoreElements()) {
            BaseType bt = (BaseType)e.nextElement();
            if (!((ServerMethods)((Object)bt)).isProject()) continue;
            if (!first) {
                os.print(", ");
            }
            bt.printVal(os, "", false);
            first = false;
        }
        os.print(" }");
        if (print_decl_p) {
            os.println(";");
        }
    }

    public void setProject(boolean state, boolean all) {
        super.setProject(state, all);
        if (all) {
            Enumeration e = this.vars.elements();
            while (e.hasMoreElements()) {
                ServerMethods sm = (ServerMethods)e.nextElement();
                sm.setProject(state, all);
            }
        }
    }

    public boolean equal(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("Equals (=) operator does not work with the type SDStructure!");
    }

    public boolean not_equal(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("Not Equals (!=) operator does not work with the type SDStructure!");
    }

    public boolean greater(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("Greater Than (>)operator does not work with the type SDStructure!");
    }

    public boolean greater_eql(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("GreaterThan or equals (<=) operator does not work with the type SDStructure!");
    }

    public boolean less(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("LessThan (<) operator does not work with the type SDStructure!");
    }

    public boolean less_eql(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("LessThan oe equals (<=) operator does not work with the type SDStructure!");
    }

    public boolean regexp(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("Regular Expression's don't work with the type SDStructure!");
    }

    public void setSynthesized(boolean state) {
        this.Synthesized = state;
    }

    public boolean isSynthesized() {
        return this.Synthesized;
    }

    public void setRead(boolean state) {
        this.ReadMe = state;
    }

    public boolean isRead() {
        return this.ReadMe;
    }

    public abstract boolean read(String var1, Object var2) throws NoSuchVariableException, IOException, EOFException;

    public void serialize(String dataset, DataOutputStream sink, CEEvaluator ce, Object specialO) throws NoSuchVariableException, DAP2ServerSideException, IOException {
        if (!this.isRead()) {
            this.read(dataset, specialO);
        }
        if (ce.evalClauses(specialO)) {
            Enumeration e = this.vars.elements();
            while (e.hasMoreElements()) {
                ServerMethods sm = (ServerMethods)e.nextElement();
                if (!sm.isProject()) continue;
                sm.serialize(dataset, sink, ce, specialO);
            }
        }
    }

    public void printXML(PrintWriter pw, String pad, boolean constrained) {
        if (constrained && !this.isProject()) {
            return;
        }
        super.printXML(pw, pad, constrained);
    }
}

