/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.gcubedocumentlibrary.io;

import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.commons.server.PortRange;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.commons.server.TCPConnectionManagerConfig;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPStoreConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.stubs.CollectionReference;
import org.gcube.contentmanagement.contentmanager.stubs.calls.ManagerCall;
import org.gcube.contentmanagement.contentmanager.stubs.calls.ReadManagerCall;
import org.gcube.contentmanagement.contentmanager.stubs.calls.exceptions.UnknownDocumentException;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.RemoteIterator;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Predicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.TreePredicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.protocol.URIs;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.GDoc;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.BaseReader;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projection;
import org.gcube.contentmanagement.gcubedocumentlibrary.streams.dsl.Streams;
import org.gcube.contentmanagement.gcubedocumentlibrary.streams.filters.Filter;
import org.gcube.contentmanagement.gcubemodellibrary.elements.Conversions;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeInnerElement;

public class DocumentReader
extends BaseReader {
    private static GCUBELog logger = new GCUBELog(DocumentReader.class);
    private RecordDefinition[] defs = new RecordDefinition[]{new GenericRecordDefinition(new FieldDefinition[]{new StringFieldDefinition("payload")})};
    private static int POOL_SIZE;
    private static ExecutorService executor;
    private ReadManagerCall call;

    DocumentReader(ReadManagerCall c) {
        this.call = c;
    }

    public DocumentReader(String collID) throws IllegalStateException, Exception {
        this(collID, GCUBEScopeManager.DEFAULT.getScope());
        if (GCUBEScopeManager.DEFAULT.getScope() == null) {
            throw new IllegalStateException("current scope is not set");
        }
    }

    public DocumentReader(String collID, GCUBEScope scope) throws Exception {
        logger.trace((Object)("initializing " + this.getClass().getSimpleName() + " with collection " + collID + " in scope: " + scope));
        this.call = new ReadManagerCall(collID, scope, new GCUBESecurityManager[0]);
    }

    public DocumentReader(String collID, GCUBEScope scope, GCUBESecurityManager securityManager) throws Exception {
        logger.trace((Object)("initializing " + this.getClass().getSimpleName() + " with collection " + collID + " in scope: " + scope));
        this.call = new ReadManagerCall(collID, scope, new GCUBESecurityManager[]{securityManager});
    }

    public DocumentReader(String collectionId, EndpointReferenceType endpointReferenceType, GCUBEScope scope) throws Exception {
        this(collectionId, scope);
        this.call.setEndpointReference(endpointReferenceType);
    }

    public DocumentReader(String collectionId, EndpointReferenceType endpointReferenceType, GCUBEScope scope, GCUBESecurityManager securityManager) throws Exception {
        this(collectionId, scope);
        this.call.setEndpointReference(endpointReferenceType);
    }

    public DocumentReader(CollectionReference reference, GCUBEScope scope) throws Exception {
        this(reference.getCollectionID(), reference.getReader(), scope);
    }

    public DocumentReader(CollectionReference reference) throws Exception {
        this(reference.getCollectionID(), reference.getReader(), GCUBEScopeManager.DEFAULT.getScope());
    }

    public DocumentReader(CollectionReference reference, GCUBEScope scope, GCUBESecurityManager securityManager) throws Exception {
        this(reference.getCollectionID(), reference.getReader(), scope, securityManager);
    }

    protected ReadManagerCall getCall() {
        return this.call;
    }

    @Override
    public String collectionID() {
        return this.call.getCollectionID();
    }

    @Override
    public GCubeDocument get(String id, Projection<?, ?> p) throws UnknownDocumentException, ManagerCall.DiscoveryException, GCUBEException, Exception {
        logger.trace((Object)("getting document " + id + " if it matches : " + p));
        return Conversions.toDocument((GDoc)this.call.get(id, (Predicate)p.documentPredicate()));
    }

    @Override
    public RemoteIterator<GCubeDocument> get(final Iterator<String> ids, Projection<?, ?> p) throws ManagerCall.DiscoveryException, GCUBEException, Exception {
        logger.trace((Object)("getting documents with given ids that match : " + p));
        final RecordWriter writer = new RecordWriter((IWriterProxy)new TCPWriterProxy(), this.defs);
        Runnable job = new Runnable(){

            @Override
            public void run() {
                while (ids.hasNext()) {
                    String id = (String)ids.next();
                    try {
                        GenericRecord record = new GenericRecord();
                        record.setFields((Field[])new StringField[]{new StringField(id)});
                        writer.put((Record)record);
                    }
                    catch (Exception e) {
                        logger.error((Object)("error when writing identifier " + id), (Throwable)e);
                        break;
                    }
                }
                try {
                    writer.close();
                }
                catch (Exception e) {
                    logger.error((Object)"could not close writer", (Throwable)e);
                }
            }
        };
        executor.submit(job);
        URI rs = this.call.get(writer.getLocator(), (Predicate)p.documentPredicate());
        return Streams.documentsIn(rs);
    }

    @Override
    public RemoteIterator<GCubeDocument> get(Projection<?, ?> p) throws ManagerCall.DiscoveryException, GCUBEException, Exception {
        logger.trace((Object)("getting elements that match : " + p));
        URI rs = this.call.get((Predicate)p.documentPredicate());
        return Streams.documentsIn(rs);
    }

    public <E extends GCubeInnerElement> E resolve(URI uri, Projection<E, ?> p) throws IllegalArgumentException, UnknownDocumentException, ManagerCall.DiscoveryException, GCUBEException, Exception {
        TreePredicate predicate = this.mergeURI(uri, p);
        logger.trace((Object)("getting element " + uri + " that matches " + p.predicate()));
        String id = URIs.documentID((URI)uri);
        GCubeDocument doc = Conversions.toDocument((GDoc)this.call.get(id, (Predicate)predicate));
        GCubeInnerElement element = (GCubeInnerElement)this.fromDocument(URIs.nodeID((URI)uri), doc);
        return (E)element;
    }

    public <E extends GCubeInnerElement> RemoteIterator<E> resolve(Iterator<URI> uris, final Projection<E, ?> p) throws ManagerCall.DiscoveryException, GCUBEException, Exception {
        logger.trace((Object)("getting elements with given URIs that match : " + p.predicate()));
        Filter f = new Filter<URI, E>(){

            @Override
            public E apply(URI uri) throws Exception {
                return DocumentReader.this.resolve(uri, p);
            }
        };
        RemoteIterator docs = Streams.pipe(uris).through(f).withRemoteDefaults();
        return docs;
    }

    static {
        if (!TCPConnectionManager.IsInitialized()) {
            try {
                ArrayList<PortRange> ports = new ArrayList<PortRange>();
                ports.add(new PortRange(3050, 3100));
                TCPConnectionManager.Init((TCPConnectionManagerConfig)new TCPConnectionManagerConfig(InetAddress.getLocalHost().getHostName(), ports, true));
                TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPConnectionHandler());
                TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPStoreConnectionHandler());
            }
            catch (Exception e) {
                logger.warn((Object)"error initializing the result set", (Throwable)e);
            }
        }
        POOL_SIZE = 10;
        executor = Executors.newFixedThreadPool(POOL_SIZE);
    }
}

