/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.gcubedocumentlibrary.views;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import javax.xml.namespace.QName;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentReader;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.ViewReader;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.Property;
import org.gcube.contentmanagement.gcubedocumentlibrary.views.CollectionView;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeElement;
import org.gcube.contentmanagement.viewmanager.stubs.calls.ViewCall;
import org.gcube.contentmanagement.viewmanager.stubs.model.View;
import org.gcube.contentmanagement.viewmanager.stubs.model.ViewProperty;

public abstract class BaseCollectionView<E extends GCubeElement, P extends Property>
implements CollectionView<E, P> {
    private View inner;
    private boolean isBound;
    private GCUBEScope scope;
    private GCUBESecurityManager securityManager;
    private static final QName NAME = new QName("name");
    DocumentReader testReader;
    ViewCall testCall;

    BaseCollectionView() {
        this(GCUBEScopeManager.DEFAULT.getScope());
    }

    BaseCollectionView(GCUBEScope s) {
        if (s == null) {
            throw new IllegalArgumentException("scope is null");
        }
        this.scope = s;
        this.inner = new View();
        this.inner.setType(this.type());
    }

    BaseCollectionView(View proxy) throws IllegalArgumentException {
        this(proxy, GCUBEScopeManager.DEFAULT.getScope());
    }

    BaseCollectionView(View proxy, GCUBEScope s) throws IllegalArgumentException {
        if (proxy == null || s == null) {
            throw new IllegalArgumentException("proxy or scope are null");
        }
        this.inner = proxy;
        this.scope = s;
        this.isBound = true;
        if (this.collectionId() == null) {
            throw new IllegalArgumentException("failed binding: no collection bound to " + this);
        }
        if (this.id() == null) {
            throw new IllegalArgumentException("failed binding: no view identifier for " + this);
        }
        if (this.projection() == null) {
            throw new IllegalStateException("failed binding: no projection set on " + this);
        }
        if (this.type() == null) {
            throw new IllegalStateException("failed binding: no type set on " + this);
        }
        this.onBinding();
    }

    BaseCollectionView(View proxy, GCUBESecurityManager m) throws IllegalArgumentException {
        this(proxy, GCUBEScopeManager.DEFAULT.getScope());
    }

    BaseCollectionView(View proxy, GCUBEScope s, GCUBESecurityManager m) throws IllegalArgumentException {
        this(proxy, s);
        if (m == null) {
            throw new IllegalArgumentException("failed binding: no security manager for " + this);
        }
        this.scope = s;
    }

    void unboundOnly() throws IllegalStateException {
        if (this.isBound()) {
            throw new IllegalStateException("invalid operation on bound view such as " + this);
        }
    }

    void boundOnly() throws IllegalStateException {
        if (!this.isBound()) {
            throw new IllegalStateException("invalid operation on unbound view such as " + this);
        }
    }

    @Override
    public boolean isBound() {
        return this.isBound;
    }

    @Override
    public String id() {
        return this.inner.getId();
    }

    public void setId(String id) throws IllegalStateException {
        this.unboundOnly();
        this.inner.setId(id);
    }

    @Override
    public QName type() {
        return this.inner.getType();
    }

    public void setCollectionId(String id) {
        this.unboundOnly();
        this.inner.setCollectionID(id);
    }

    @Override
    public String collectionId() {
        return this.inner.getCollectionID();
    }

    @Override
    public String name() {
        return this.getPropertyValueOrNull(NAME);
    }

    public void setName(String n) {
        this.unboundOnly();
        this.inner.addProperty(new ViewProperty(NAME, "the descriptive name of the view", n));
    }

    @Override
    public String description() {
        return this.inner.getDescription();
    }

    public void setDescription(String d) {
        this.unboundOnly();
        this.inner.setDescription(d);
    }

    @Override
    public Calendar lastUpdate() {
        return this.inner.getLastUpdate();
    }

    @Override
    public long cardinality() {
        return this.inner.getCardinality();
    }

    @Override
    public GCUBEScope scope() {
        return this.scope;
    }

    @Override
    public GCUBESecurityManager securityManager() {
        return this.securityManager;
    }

    @Override
    public void publish() throws IllegalStateException, GCUBEException, Exception {
        this.publish(false);
    }

    @Override
    public void publishAndBroadcast() throws IllegalStateException, GCUBEException, Exception {
        this.publish(true);
    }

    void publish(boolean broadcast) throws IllegalStateException, GCUBEException, Exception {
        GCUBESecurityManager[] gCUBESecurityManagerArray;
        this.unboundOnly();
        this.onPublication();
        if (this.securityManager == null) {
            gCUBESecurityManagerArray = new GCUBESecurityManager[]{};
        } else {
            GCUBESecurityManager[] gCUBESecurityManagerArray2 = new GCUBESecurityManager[1];
            gCUBESecurityManagerArray = gCUBESecurityManagerArray2;
            gCUBESecurityManagerArray2[0] = this.securityManager;
        }
        GCUBESecurityManager[] optionalManager = gCUBESecurityManagerArray;
        ViewCall viewcall = this.testCall == null ? (this.plugin() == null ? new ViewCall(this.scope, optionalManager) : new ViewCall(this.plugin(), this.scope, optionalManager)) : this.testCall;
        this.inner = viewcall.create(this.inner, new boolean[]{broadcast});
        this.isBound = true;
    }

    @Override
    public void delete() throws Exception {
        GCUBESecurityManager[] gCUBESecurityManagerArray;
        this.boundOnly();
        if (this.securityManager == null) {
            gCUBESecurityManagerArray = new GCUBESecurityManager[]{};
        } else {
            GCUBESecurityManager[] gCUBESecurityManagerArray2 = new GCUBESecurityManager[1];
            gCUBESecurityManagerArray = gCUBESecurityManagerArray2;
            gCUBESecurityManagerArray2[0] = this.securityManager;
        }
        GCUBESecurityManager[] optionalManager = gCUBESecurityManagerArray;
        ViewCall viewcall = this.testCall == null ? (this.plugin() == null ? new ViewCall(this.scope, optionalManager) : new ViewCall(this.plugin(), this.scope, optionalManager)) : this.testCall;
        System.out.println("inner view EndpointReference: " + this.inner.getEndpointReference());
        viewcall.destroy(this.inner.getEndpointReference());
    }

    @Override
    public ViewReader reader() throws IllegalStateException, Exception {
        this.boundOnly();
        DocumentReader br = this.testReader == null ? (this.securityManager == null ? new DocumentReader(this.collectionId(), this.scope) : new DocumentReader(this.collectionId(), this.scope, this.securityManager)) : this.testReader;
        return new ViewReader(this.projection(), br);
    }

    public void addProperty(ViewProperty p) {
        this.inner.addProperty(p);
    }

    public void addProperty(QName name, String value) {
        this.addProperty(new ViewProperty(name, null, value));
    }

    @Override
    public Map<QName, ViewProperty> properties() {
        return this.inner.getProperties();
    }

    @Override
    public View inner() {
        return this.inner;
    }

    protected String getPropertyValueOrNull(QName name) {
        ViewProperty prop = (ViewProperty)this.inner.getProperties().get(name);
        return prop == null ? null : prop.getValue();
    }

    protected abstract String plugin();

    protected abstract void onBinding() throws IllegalArgumentException;

    protected abstract void onPublication() throws IllegalStateException;

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(": collection=" + this.collectionId());
        builder.append(", id=" + this.id());
        builder.append(", type=" + this.type());
        builder.append(", predicate=" + this.projection());
        builder.append(", description=" + this.description());
        builder.append(", lastUpdate=");
        if (this.lastUpdate() != null) {
            SimpleDateFormat sdf = new SimpleDateFormat();
            builder.append(sdf.format(this.lastUpdate().getTime()));
        } else {
            builder.append("null");
        }
        builder.append(", cardinality=" + this.cardinality());
        builder.append(", scope=" + this.scope());
        for (ViewProperty p : this.properties().values()) {
            builder.append(", property=[" + p.getName() + "," + p.getDescription() + "," + p.getValue() + "]");
        }
        return builder.toString();
    }

    void setTestReader(DocumentReader r) {
        this.testReader = r;
    }

    void setTestCall(ViewCall c) {
        this.testCall = c;
    }
}

