/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.gcubedocumentlibrary.streams.dsl;

import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.RSIterator;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.RemoteIterator;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.ResultParser;
import org.gcube.contentmanagement.gcubedocumentlibrary.streams.dsl.Env;
import org.gcube.contentmanagement.gcubedocumentlibrary.streams.dsl.InClause;
import org.gcube.contentmanagement.gcubedocumentlibrary.streams.dsl.ThroughClause;
import org.gcube.contentmanagement.gcubedocumentlibrary.streams.dsl.UnfoldThroughClause;
import org.gcube.contentmanagement.gcubedocumentlibrary.streams.dsl.WithClause;
import org.gcube.contentmanagement.gcubedocumentlibrary.streams.dsl.WithLocalClause;
import org.gcube.contentmanagement.gcubedocumentlibrary.streams.faults.FaultPolicy;
import org.gcube.contentmanagement.gcubedocumentlibrary.streams.faults.IFaultPolicy;
import org.gcube.contentmanagement.gcubedocumentlibrary.streams.filters.Filter;
import org.gcube.contentmanagement.gcubemodellibrary.elements.Conversions;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeAlternative;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeAnnotation;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeElement;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeMetadata;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubePart;

public class Streams {
    private static GCUBELog logger = new GCUBELog(Streams.class);
    public static final IFaultPolicy<RuntimeException> IGNORE_POLICY = new IFaultPolicy<RuntimeException>(){

        @Override
        public boolean onFault(Exception e, int count) {
            if (!(e instanceof FaultPolicy.SkipElementException)) {
                logger.warn((Object)("iteration failure number " + count), (Throwable)e);
            }
            return CONTINUE;
        }
    };
    public static final IFaultPolicy<RuntimeException> FAILFAST_POLICY = new IFaultPolicy<RuntimeException>(){

        @Override
        public boolean onFault(Exception e, int count) {
            return STOP;
        }
    };
    public static final IFaultPolicy<Exception> RETHROW_POLICY = new IFaultPolicy<Exception>(){

        @Override
        public boolean onFault(Exception e, int count) throws Exception {
            throw e;
        }
    };
    public static boolean CONTINUE = true;
    public static boolean STOP = false;
    public static ResultParser<String> PASSTHROUGH_PARSER = new ResultParser<String>(){

        public String parse(String s) throws Exception {
            return s;
        }
    };
    public static ResultParser<URI> URI_PARSER = new ResultParser<URI>(){

        public URI parse(String s) throws Exception {
            return new URI(s);
        }
    };
    static Filter<String, GCubeDocument> DOCUMENT_FILTER = new Filter<String, GCubeDocument>(){

        @Override
        public GCubeDocument apply(String xml) throws Exception {
            return Conversions.toDocument((Reader)new StringReader(xml));
        }
    };
    static Filter<GCubeDocument, List<GCubeMetadata>> METADATA_FILTER = new Filter<GCubeDocument, List<GCubeMetadata>>(){

        @Override
        public List<GCubeMetadata> apply(GCubeDocument element) throws Exception {
            return element.metadata().toList();
        }
    };
    static Filter<GCubeDocument, List<GCubeAnnotation>> ANNOTATION_FILTER = new Filter<GCubeDocument, List<GCubeAnnotation>>(){

        @Override
        public List<GCubeAnnotation> apply(GCubeDocument element) throws Exception {
            return element.annotations().toList();
        }
    };
    static Filter<GCubeDocument, List<GCubeAlternative>> ALTERNATIVE_FILTER = new Filter<GCubeDocument, List<GCubeAlternative>>(){

        @Override
        public List<GCubeAlternative> apply(GCubeDocument element) throws Exception {
            return element.alternatives().toList();
        }
    };
    static Filter<GCubeDocument, List<GCubePart>> PART_FILTER = new Filter<GCubeDocument, List<GCubePart>>(){

        @Override
        public List<GCubePart> apply(GCubeDocument element) throws Exception {
            return element.parts().toList();
        }
    };

    public static RemoteIterator<String> payloadsIn(URI locator) throws Exception {
        return new RSIterator(locator, PASSTHROUGH_PARSER);
    }

    public static RemoteIterator<URI> urisIn(URI locator, int timeout) throws Exception {
        return new RSIterator(locator, URI_PARSER, timeout);
    }

    public static <E extends GCubeElement> WithClause<E, URI> urisOf(Iterator<E> iterator) {
        return Streams.pipe(iterator).through(new URIExtractor());
    }

    public static <E extends GCubeElement> WithClause<E, URI> urisOf(RemoteIterator<E> iterator) {
        return Streams.pipe(iterator).through(new URIExtractor());
    }

    public static RemoteIterator<GCubeDocument> documentsIn(URI locator) throws Exception {
        return Streams.pipe(Streams.payloadsIn(locator)).through(DOCUMENT_FILTER).withRemoteDefaults();
    }

    public static RemoteIterator<GCubeDocument> documentsIn(RemoteIterator<String> it) throws Exception {
        return Streams.pipe(it).through(DOCUMENT_FILTER).withRemoteDefaults();
    }

    public static RemoteIterator<GCubeMetadata> metadataIn(URI locator) throws Exception {
        return Streams.metadataIn(Streams.documentsIn(locator));
    }

    public static RemoteIterator<GCubeMetadata> metadataIn(RemoteIterator<GCubeDocument> docs) throws Exception {
        return Streams.unfold(docs).pipingThrough(METADATA_FILTER).withRemoteDefaults();
    }

    public static Iterator<GCubeMetadata> metadataIn(Iterator<GCubeDocument> docs) throws Exception {
        return Streams.unfold(docs).pipingThrough(METADATA_FILTER).withDefaults();
    }

    public static RemoteIterator<GCubeAnnotation> annotationsIn(URI locator) throws Exception {
        return Streams.unfold(Streams.documentsIn(locator)).pipingThrough(ANNOTATION_FILTER).withRemoteDefaults();
    }

    public static RemoteIterator<GCubeAnnotation> annotationsIn(RemoteIterator<GCubeDocument> docs) throws Exception {
        return Streams.unfold(docs).pipingThrough(ANNOTATION_FILTER).withRemoteDefaults();
    }

    public static Iterator<GCubeAnnotation> annotationsIn(Iterator<GCubeDocument> docs) throws Exception {
        return Streams.unfold(docs).pipingThrough(ANNOTATION_FILTER).withDefaults();
    }

    public static RemoteIterator<GCubeAlternative> alternativesIn(URI locator) throws Exception {
        return Streams.unfold(Streams.documentsIn(locator)).pipingThrough(ALTERNATIVE_FILTER).withRemoteDefaults();
    }

    public static RemoteIterator<GCubeAlternative> alternativesIn(RemoteIterator<GCubeDocument> docs) throws Exception {
        return Streams.unfold(docs).pipingThrough(ALTERNATIVE_FILTER).withRemoteDefaults();
    }

    public static Iterator<GCubeAlternative> alternativesIn(Iterator<GCubeDocument> docs) throws Exception {
        return Streams.unfold(docs).pipingThrough(ALTERNATIVE_FILTER).withDefaults();
    }

    public static RemoteIterator<GCubePart> partsIn(URI locator) throws Exception {
        return Streams.unfold(Streams.documentsIn(locator)).pipingThrough(PART_FILTER).withRemoteDefaults();
    }

    public static RemoteIterator<GCubePart> partsIn(RemoteIterator<GCubeDocument> docs) throws Exception {
        return Streams.unfold(docs).pipingThrough(PART_FILTER).withRemoteDefaults();
    }

    public static Iterator<GCubePart> partsIn(Iterator<GCubeDocument> docs) throws Exception {
        return Streams.unfold(docs).pipingThrough(PART_FILTER).withDefaults();
    }

    public static <FROM> ThroughClause<FROM> pipe(Iterator<FROM> it) {
        return Streams.pipe(Streams.convert(it));
    }

    public static <FROM> ThroughClause<FROM> pipe(RemoteIterator<FROM> rit) {
        return new ThroughClause<FROM>(new Env(rit));
    }

    public static <FROM> InClause<FROM> group(Iterator<FROM> it) {
        return Streams.group(Streams.convert(it));
    }

    public static <FROM> InClause<FROM> group(RemoteIterator<FROM> rit) {
        return new InClause<FROM>(new Env(rit));
    }

    public static <FROM> UnfoldThroughClause<FROM> unfold(Iterator<FROM> it) {
        return Streams.unfold(Streams.convert(it));
    }

    public static <FROM> UnfoldThroughClause<FROM> unfold(RemoteIterator<FROM> rit) {
        return new UnfoldThroughClause<FROM>(new Env(rit));
    }

    public static <T> WithLocalClause<T, T> convert(RemoteIterator<T> rit) {
        return new WithLocalClause(new Env(rit, new PassThroughFilter()));
    }

    public static <T> RemoteIterator<T> convert(final Iterator<T> it) {
        return new RemoteIterator<T>(){

            public boolean hasNext() {
                return it.hasNext();
            }

            public T next() throws Exception {
                return it.next();
            }

            public String locator() {
                return it.toString();
            }

            public void close() {
            }
        };
    }

    static class URIExtractor<E extends GCubeElement>
    implements Filter<E, URI> {
        URIExtractor() {
        }

        @Override
        public URI apply(E element) throws Exception {
            return element.uri();
        }
    }

    static class PassThroughFilter<T>
    implements Filter<T, T> {
        PassThroughFilter() {
        }

        @Override
        public T apply(T element) throws Exception {
            return element;
        }
    }
}

