/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.ecomodelling.generators.processing;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.gcube.application.aquamaps.ecomodelling.generators.abstracts.AbstractEnvelopeAlgorithm;
import org.gcube.application.aquamaps.ecomodelling.generators.aquamapsorg.AquamapsEnvelopeAlgorithm;
import org.gcube.application.aquamaps.ecomodelling.generators.configuration.EngineConfiguration;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.EnvelopeModel;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.EnvelopeName;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.Hspen;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.livemonitor.ResourceLoad;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.livemonitor.Resources;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.subconnectors.Envelope;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.subconnectors.EnvelopeSet;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.subconnectors.OccurrencePointSets;
import org.gcube.application.aquamaps.ecomodelling.generators.utils.DatabaseFactory;
import org.gcube.contentmanagement.graphtools.utils.HttpRequest;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.hibernate.SessionFactory;

public class EnvelopeGenerator {
    private static final String alterQuery = "UPDATE %HSPEN% SET %1$s WHERE speciesid = '%2$s'";
    private static final String createHspenTable = "CREATE TABLE %HSPEN% ( speccode integer, speciesid character varying NOT NULL, lifestage character varying NOT NULL, faoareas character varying(100), faoareasref character varying, faocomplete smallint, nmostlat real, smostlat real, wmostlong real,emostlong real, lme character varying(180), depthyn smallint, depthmin integer, depthmax integer,  depthprefmin integer,  depthprefmax integer,  meandepth smallint,  depthref character varying,  pelagic smallint,  tempyn smallint,  tempmin real,  tempmax real,  tempprefmin real,  tempprefmax real,  tempref character varying,  salinityyn smallint,  salinitymin real,  salinitymax real,  salinityprefmin real,  salinityprefmax real,  salinityref character varying,  primprodyn smallint,  primprodmin real,  primprodmax real,  primprodprefmin real,  primprodprefmax real,  primprodprefref character varying,  iceconyn smallint,  iceconmin real,  iceconmax real,  iceconprefmin real,  iceconprefmax real,  iceconref character varying,  landdistyn smallint,  landdistmin real,  landdistmax real,  landdistprefmin real,  landdistprefmax real,  landdistref character varying,  remark character varying,  datecreated timestamp without time zone,  datemodified timestamp without time zone,  expert integer,  dateexpert timestamp without time zone,  envelope smallint,  mapdata smallint,  effort smallint,  layer character(1),  usepoints smallint,  rank smallint,  CONSTRAINT %HSPEN%_pkey PRIMARY KEY (speciesid, lifestage))WITH (  OIDS=FALSE);ALTER TABLE %HSPEN% OWNER TO %1$s; CREATE INDEX envelope_%HSPEN%_idx   ON %HSPEN%  USING btree  (envelope); CREATE INDEX mapdata_%HSPEN%_idx  ON %HSPEN%  USING btree  (mapdata); CREATE INDEX speciesid_%HSPEN%_idx  ON %HSPEN%  USING btree  (speciesid);";
    private static final String populateNewHspen = "insert into %HSPEN% (select * from %HSPEN_ORIGIN%);";
    private static final String speciesListQuery = "select distinct speciesid from %HSPEN%;";
    private static final String hspenListQuery = "select speciesid, layer, iceconmin , iceconmax , iceconprefmin , iceconprefmax , salinitymin , salinitymax , salinityprefmin , salinityprefmax , landdistmin , landdistmax , landdistprefmin , landdistprefmax , tempmin , tempmax , tempprefmin , tempprefmax ,  primprodmin ,  primprodmax ,  primprodprefmin ,  primprodprefmax  from %HSPEN%;";
    String defaultDatabaseFile = "DestinationDBHibernate.cfg.xml";
    String defaultLogFile = "ALog.properties";
    String default_hspec_suitable_table = "hspec_suitable_gp2";
    String default_hcaf_table = "hcaf_s";
    String default_hspen_table = "hspen_new";
    String default_origin_hspen_table = "hspen";
    String default_species_list = "selectedSpecies.txt";
    String dynamicCreateTable;
    String dynamicPopulateNewHspen;
    String dynamicAlterQuery;
    String dynamicSelectValues;
    String dynamicSpeciesListQuery;
    String dynamicHspenInformationQuery;
    String currentHCAFTable;
    String currentOccurrenceTable;
    boolean useDB = true;
    boolean interruptProcessing = false;
    float status;
    int numbOfProcessedSpecies;
    private ExecutorService executorService;
    EnvelopeModel generatorAlgorithm = EnvelopeModel.AQUAMAPS;
    List<Object> selectedSpecies;
    AbstractEnvelopeAlgorithm envelopeGenerationAlgorithm;
    int countDifferences;
    protected SessionFactory vreConnection;
    static int chunksize = 5000;
    int numberOfthreads = 1;
    boolean[] threadActivity;
    HashMap<String, List<Object>> allSpeciesHspen;
    private int lastProcessedRecordsNumber;
    private long lastTime;

    public void stopProcess() {
        this.interruptProcessing = true;
    }

    public double getStatus() {
        return this.status;
    }

    public void initDBSession(EngineConfiguration engineConf) throws Exception {
        if (engineConf != null && engineConf.getConfigPath() != null) {
            this.defaultDatabaseFile = engineConf.getConfigPath() + this.defaultDatabaseFile;
        }
        if (this.useDB) {
            this.vreConnection = DatabaseFactory.initDBConnection(this.defaultDatabaseFile, engineConf);
        }
    }

    private void wait4Thread(int index) {
        while (this.threadActivity[index]) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void initializeThreads(int numberOfThreadsToUse) {
        this.executorService = Executors.newFixedThreadPool(numberOfThreadsToUse);
        this.threadActivity = new boolean[numberOfThreadsToUse];
        for (int j = 0; j < this.threadActivity.length; ++j) {
            this.threadActivity[j] = false;
        }
    }

    public void initQueriesStatements(EngineConfiguration engineConf) throws Exception {
        if (engineConf != null && engineConf.getConfigPath() != null) {
            try {
                this.dynamicAlterQuery = alterQuery.replace("%HSPEN%", engineConf.getHspenTable());
                this.dynamicCreateTable = createHspenTable.replace("%HSPEN%", engineConf.getHspenTable());
                this.dynamicPopulateNewHspen = populateNewHspen.replace("%HSPEN_ORIGIN%", engineConf.getOriginHspenTable()).replace("%HSPEN%", engineConf.getHspenTable());
                this.dynamicSpeciesListQuery = speciesListQuery.replace("%HSPEN%", engineConf.getOriginHspenTable());
                this.dynamicHspenInformationQuery = hspenListQuery.replace("%HSPEN%", engineConf.getOriginHspenTable());
                this.currentHCAFTable = engineConf.getHcafTable();
                this.currentOccurrenceTable = engineConf.getOccurrenceCellsTable();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void shutdownConnection() {
        this.vreConnection.close();
    }

    public void setSelectedSpecies(List<String> speciesList) {
        this.selectedSpecies = new ArrayList<Object>();
        for (String species : speciesList) {
            this.selectedSpecies.add(species);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateSelectedSpecies() {
        if (this.selectedSpecies == null) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(this.default_species_list));
                this.selectedSpecies = new ArrayList<Object>();
                String line = br.readLine();
                while (line != null) {
                    this.selectedSpecies.add(line.trim());
                    line = br.readLine();
                }
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().trace("Distribution Generator - SELECTED SPECIES - FILE NOT FOUND - POPULATING FROM DB");
                this.populateSelectedSpeciesByDB();
            }
            finally {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void populateSelectedSpeciesByDB() {
        AnalysisLogger.getLogger().trace("Distribution Generator ->getting all species list from DB");
        if (this.useDB) {
            List<Object> allspecies = DatabaseFactory.executeSQLQuery(this.dynamicSpeciesListQuery, this.vreConnection);
            this.selectedSpecies = allspecies;
        }
    }

    private void populateHspen() {
        this.allSpeciesHspen = new HashMap();
        List<Object> SpeciesInfo = DatabaseFactory.executeSQLQuery(this.dynamicHspenInformationQuery, this.vreConnection);
        int lenSpecies = SpeciesInfo.size();
        for (int i = 0; i < lenSpecies; ++i) {
            Object[] speciesArray = (Object[])SpeciesInfo.get(i);
            String speciesid = (String)speciesArray[0];
            ArrayList<Object[]> singleSpeciesInfo = new ArrayList<Object[]>();
            singleSpeciesInfo.add(speciesArray);
            this.allSpeciesHspen.put(speciesid, singleSpeciesInfo);
        }
    }

    public EnvelopeGenerator(EngineConfiguration engine) throws Exception {
        if (engine != null) {
            this.useDB = engine.useDB();
            this.initDBSession(engine);
            this.initQueriesStatements(engine);
            if (engine.getConfigPath() != null) {
                this.defaultLogFile = engine.getConfigPath() + this.defaultLogFile;
                this.default_species_list = engine.getConfigPath() + this.default_species_list;
            }
            AnalysisLogger.setLogger((String)this.defaultLogFile);
            if (engine.getHspenTable() != null) {
                this.default_hspen_table = engine.getHspenTable();
            }
            if (engine.getHcafTable() != null) {
                this.default_hcaf_table = engine.getHcafTable();
            }
            if (engine.getOriginHspenTable() != null) {
                this.default_origin_hspen_table = engine.getOriginHspenTable();
            }
            if (engine.getNumberOfThreads() != null) {
                this.numberOfthreads = engine.getNumberOfThreads();
            }
            if (engine.createTable().booleanValue()) {
                try {
                    if (this.useDB) {
                        AnalysisLogger.getLogger().trace("Distribution Generator->creating new table " + String.format(this.dynamicCreateTable, engine.getDatabaseUserName()));
                        DatabaseFactory.executeSQLUpdate(String.format(this.dynamicCreateTable, engine.getDatabaseUserName()), this.vreConnection);
                        AnalysisLogger.getLogger().trace("Distribution Generator->populating new table " + this.dynamicPopulateNewHspen);
                        DatabaseFactory.executeSQLUpdate(this.dynamicPopulateNewHspen, this.vreConnection);
                    }
                }
                catch (Exception e) {
                    AnalysisLogger.getLogger().trace("Distribution Generator->could not create table");
                }
            }
            if (engine.getGenerator() != null) {
                this.generatorAlgorithm = engine.getEnvelopeGenerator();
            }
        }
        if (this.generatorAlgorithm == EnvelopeModel.AQUAMAPS) {
            this.envelopeGenerationAlgorithm = new AquamapsEnvelopeAlgorithm();
        }
        this.interruptProcessing = false;
    }

    public void reGenerateEnvelopes() throws Exception {
        AnalysisLogger.getLogger().trace("Distribution Generator->populating species");
        this.populateSelectedSpecies();
        this.populateHspen();
        AnalysisLogger.getLogger().trace("Distribution Generator->ENVELOPES GENERATION STARTED");
        long tstart = System.currentTimeMillis();
        this.initializeThreads(this.numberOfthreads);
        try {
            int currentThread = 0;
            int globalcounter = 0;
            this.countDifferences = 0;
            long computationT0 = System.currentTimeMillis();
            int numberOfSpecies = this.selectedSpecies.size();
            for (Object species : this.selectedSpecies) {
                String speciesid = (String)species;
                if (speciesid.length() > 0) {
                    float s;
                    AnalysisLogger.getLogger().trace("Distribution Generator->ANALIZING SPECIES: " + speciesid);
                    this.wait4Thread(currentThread);
                    this.startNewTCalc(currentThread, speciesid);
                    if (++currentThread >= this.numberOfthreads) {
                        currentThread = 0;
                    }
                    this.status = (s = (float)((int)((float)globalcounter * 100.0f / (float)numberOfSpecies * 100.0f)) / 100.0f) == 100.0f ? 99.0f : s;
                    AnalysisLogger.getLogger().trace("STATUS->" + this.status + "%");
                    ++globalcounter;
                    AnalysisLogger.getLogger().warn("Number of Found Differences: " + this.countDifferences);
                }
                if (!this.interruptProcessing) continue;
                break;
            }
            for (int i = 0; i < this.numberOfthreads; ++i) {
                this.wait4Thread(i);
            }
            long computationT1 = System.currentTimeMillis();
            AnalysisLogger.getLogger().warn("All Envelopes Computation Finished in " + (computationT1 - computationT0) + " ms");
            AnalysisLogger.getLogger().warn("Number of Overall Found Differences: " + this.countDifferences);
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().trace("Computation traminate prematurely: ", (Throwable)e);
        }
        this.executorService.shutdown();
        this.shutdownConnection();
        this.status = 100.0f;
    }

    public Hspen calcEnvelopes(Hspen hspen, EngineConfiguration config) {
        long t0 = System.currentTimeMillis();
        try {
            Object[] singleHspen = this.envelopeGenerationAlgorithm.hspen2ObjectArray(hspen);
            EnvelopeSet envSet = this.envelopeGenerationAlgorithm.calculateEnvelopes(hspen.getSpeciesID(), this.vreConnection, config.getOccurrenceCellsTable(), config.getHcafTable(), singleHspen);
            List<Envelope> envelopes = envSet.getEnvelopes();
            for (Envelope e : envelopes) {
                if (e.getName().equals((Object)EnvelopeName.TEMPERATURE)) {
                    hspen.setTemperature(e);
                    continue;
                }
                if (e.getName().equals((Object)EnvelopeName.SALINITY)) {
                    hspen.setSalinity(e);
                    continue;
                }
                if (e.getName().equals((Object)EnvelopeName.LAND_DISTANCE)) {
                    hspen.setLandDistance(e);
                    continue;
                }
                if (e.getName().equals((Object)EnvelopeName.ICE_CONCENTRATION)) {
                    hspen.setIceConcentration(e);
                    continue;
                }
                if (!e.getName().equals((Object)EnvelopeName.PRIMARY_PRODUCTION)) continue;
                hspen.setPrimaryProduction(e);
            }
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().trace("Computation traminated prematurely: ", (Throwable)e);
        }
        long t1 = System.currentTimeMillis();
        AnalysisLogger.getLogger().trace("Computation for species " + hspen.getSpeciesID() + " finished in " + (t1 - t0) + " ms");
        this.shutdownConnection();
        return hspen;
    }

    public Hspen calcEnvelopes(Hspen hspen, OccurrencePointSets occPointLists) {
        long t0 = System.currentTimeMillis();
        try {
            Object[] singleHspen = this.envelopeGenerationAlgorithm.hspen2ObjectArray(hspen);
            AnalysisLogger.getLogger().trace("calcEnvelopes->Species ID : " + hspen.getSpeciesID());
            EnvelopeSet envSet = this.envelopeGenerationAlgorithm.calculateEnvelopes(hspen.getSpeciesID(), singleHspen, occPointLists);
            List<Envelope> envelopes = envSet.getEnvelopes();
            for (Envelope e : envelopes) {
                if (e.getName().equals((Object)EnvelopeName.TEMPERATURE)) {
                    hspen.setTemperature(e);
                    continue;
                }
                if (e.getName().equals((Object)EnvelopeName.SALINITY)) {
                    hspen.setSalinity(e);
                    continue;
                }
                if (e.getName().equals((Object)EnvelopeName.LAND_DISTANCE)) {
                    hspen.setLandDistance(e);
                    continue;
                }
                if (e.getName().equals((Object)EnvelopeName.ICE_CONCENTRATION)) {
                    hspen.setIceConcentration(e);
                    continue;
                }
                if (!e.getName().equals((Object)EnvelopeName.PRIMARY_PRODUCTION)) continue;
                hspen.setPrimaryProduction(e);
            }
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().trace("Computation traminated prematurely: ", (Throwable)e);
        }
        long t1 = System.currentTimeMillis();
        AnalysisLogger.getLogger().trace("Computation for species " + hspen.getSpeciesID() + " finished in " + (t1 - t0) + " ms");
        return hspen;
    }

    public void calcEnvelopes(String species) {
        long t0 = System.currentTimeMillis();
        try {
            List<Object> singleHspen = this.allSpeciesHspen.get(species);
            EnvelopeSet envSet = this.envelopeGenerationAlgorithm.calculateEnvelopes(species, this.vreConnection, this.currentOccurrenceTable, this.currentHCAFTable, (Object[])singleHspen.get(0));
            String instruction = envSet.getEnvelopeString();
            long t1 = System.currentTimeMillis();
            AnalysisLogger.getLogger().trace("Computation for species " + species + " finished in " + (t1 - t0) + " ms");
            if (instruction.length() > 0) {
                ++this.countDifferences;
                String query = String.format(this.dynamicAlterQuery, instruction, species);
                try {
                    AnalysisLogger.getLogger().trace("Envelope Generated - executing query: " + query);
                    DatabaseFactory.executeSQLUpdate(query, this.vreConnection);
                }
                catch (Exception e) {
                    AnalysisLogger.getLogger().trace("could not execute update");
                    e.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            AnalysisLogger.getLogger().trace("Computation traminated prematurely: ", (Throwable)ex);
        }
        ++this.numbOfProcessedSpecies;
    }

    private void startNewTCalc(int index, String species) {
        this.threadActivity[index] = true;
        ThreadCalculator tc = new ThreadCalculator(index, species);
        this.executorService.submit(tc);
    }

    public String getSpeciesLoad() {
        String returnString = "";
        try {
            long tk = System.currentTimeMillis();
            double activity = this.numbOfProcessedSpecies;
            ResourceLoad rs = new ResourceLoad(tk, activity);
            returnString = rs.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            long tk = System.currentTimeMillis();
            returnString = new ResourceLoad(tk, 0.0).toString();
        }
        return returnString;
    }

    public String getResourceLoad() {
        String returnString = "";
        try {
            long tk = System.currentTimeMillis();
            double activity = Double.valueOf(this.numbOfProcessedSpecies - this.lastProcessedRecordsNumber) * 1000.0 / Double.valueOf(tk - this.lastTime);
            this.lastTime = tk;
            this.lastProcessedRecordsNumber = this.numbOfProcessedSpecies;
            ResourceLoad rs = new ResourceLoad(tk, activity);
            returnString = rs.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            long tk = System.currentTimeMillis();
            returnString = new ResourceLoad(tk, 0.0).toString();
        }
        return returnString;
    }

    public String getResources() {
        Resources res = new Resources();
        try {
            for (int i = 0; i < this.numberOfthreads; ++i) {
                try {
                    double value = this.threadActivity[i] ? 100.0 : 0.0;
                    res.addResource("Thread_" + (i + 1), value);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (res != null && res.list != null) {
            return HttpRequest.toJSon(res.list).replace("resId", "resID");
        }
        return "";
    }

    private class ThreadCalculator
    implements Callable<Integer> {
        int index;
        String species;

        public ThreadCalculator(int index, String species) {
            this.species = species;
            this.index = index;
        }

        @Override
        public Integer call() {
            try {
                EnvelopeGenerator.this.calcEnvelopes(this.species);
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().trace("" + e);
                e.printStackTrace();
            }
            EnvelopeGenerator.this.threadActivity[this.index] = false;
            return 0;
        }
    }
}

