/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.stubs.calls.iterators;

import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import java.net.URI;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.RemoteIterator;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.ResultParser;

public abstract class BaseRSIterator<T>
implements RemoteIterator<T> {
    private static final int DEFAULT_TIMEOUT = 30;
    private static GCUBELog logger = new GCUBELog(BaseRSIterator.class);
    private Iterator<GenericRecord> iterator;
    private ResultParser<T> parser;
    private URI locator;
    private ForwardReader<GenericRecord> reader;

    BaseRSIterator(URI l, ResultParser<T> p) throws Exception {
        this(l, p, 30);
    }

    BaseRSIterator(URI l, ResultParser<T> p, int timeout) throws Exception {
        this.locator = l;
        long time = System.currentTimeMillis();
        logger.debug((Object)"getting reader over given locator");
        this.reader = new ForwardReader(this.locator);
        this.reader.setIteratorTimeout((long)timeout);
        this.reader.setIteratorTimeUnit(TimeUnit.SECONDS);
        logger.debug((Object)("got reader after" + (System.currentTimeMillis() - time)));
        this.iterator = this.reader.iterator();
        this.parser = p;
    }

    public Iterator<GenericRecord> getRSIterator() {
        return this.iterator;
    }

    protected ResultParser<T> getParser() {
        return this.parser;
    }

    @Override
    public String locator() {
        return this.locator.toString();
    }

    @Override
    public void close() {
        try {
            this.reader.close();
            logger.trace((Object)"resultSet reader closed");
        }
        catch (GRS2ReaderException e) {
            logger.error((Object)"error closing reader");
        }
    }
}

