/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.stubs.calls.iterators;

import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.field.StringField;
import java.net.URI;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.BaseRSIterator;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.FaultListener;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.ResultParser;

public class AsyncRSIterator<T>
extends BaseRSIterator<T>
implements Iterator<T> {
    private T next;
    private FaultListener listener;

    public AsyncRSIterator(URI l, ResultParser<T> p, int timeout) throws Exception {
        this(l, p, timeout, new DefaultListener());
    }

    public AsyncRSIterator(URI l, ResultParser<T> p, int timeout, FaultListener fl) throws Exception {
        super(l, p, timeout);
        this.listener = fl;
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        if (!this.getRSIterator().hasNext()) {
            this.close();
            return false;
        }
        GenericRecord result = this.getRSIterator().next();
        String payload = null;
        try {
            payload = ((StringField)result.getField(0)).getPayload();
            this.next = this.getParser().parse(payload);
            return true;
        }
        catch (Throwable t) {
            this.listener.onFault(payload, t);
            return this.hasNext();
        }
    }

    @Override
    public T next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        T t = this.next;
        this.next = null;
        return t;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static class DefaultListener
    implements FaultListener {
        private DefaultListener() {
        }

        @Override
        public void onFault(String payload, Throwable t) {
            System.out.println("error processing:\n " + payload);
            t.printStackTrace();
        }
    }
}

