package org.gcube.contentmanagement.codelistmanager.util.csv;

import java.util.ArrayList;
import java.util.List;
import net.sf.csv4j.CSVLineProcessor;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.Insert;
import org.gcube.common.dbinterface.tables.SimpleTable;

/**
 * 
 * @author lucio
 *
 */
public class ImportLineProcessor implements CSVLineProcessor{


	private SimpleTable table;
	protected Insert insertValues=null;		
	protected DBSession session=null;
	private int importedLines =0;
	private ProgresChangedEvent event;
	
	
	public ImportLineProcessor() {
		super();
	}

	
	
	/**
	 * @param table the table to set
	 */
	public void setTable(SimpleTable table) {
		this.table = table;
	}

	

	/**
	 * @param event the event to set
	 */
	public void setEvent(ProgresChangedEvent event) {
		this.event = event;
	}



	public boolean continueProcessing() {
		return true;
	}

	public void processDataLine(int lineNumber, List<String> fields) {
		try{
			if (session==null){
				session= DBSession.connect();
				insertValues=DBSession.getImplementation(Insert.class);
				insertValues.setTable(table);
			}
			List<Object> selectedValues= new ArrayList<Object>();
			selectedValues.add("DEFAULT");
			selectedValues.addAll(fields);
			insertValues.setInsertValues(selectedValues.toArray(new Object[selectedValues.size()]));
			insertValues.execute(session);
			importedLines++;
			event.onProgresChanged(importedLines);
		}catch(Exception e){
			e.printStackTrace();
		}
	}
		
	public void processHeaderLine(int arg0, List<String> arg1) {}

	/**
	 * @return the importedLines
	 */
	public int getImportedLines() {
		return importedLines;
	}	
	
}

