/**
 * 
 */
package org.gcube.contentmanagement.codelistmanager.managers.handlers;

import java.util.Hashtable;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.contentmanagement.codelistmanager.entities.TableField;
import org.gcube.contentmanagement.codelistmanager.entities.TableField.ColumnType;
import org.gcube.contentmanagement.codelistmanager.exception.NullValuesOnCastException;
import org.gcube.contentmanagement.codelistmanager.util.ColumnReference;

/**
 * @author lucio
 *
 */
public interface CodeListCurationHandler  {

	public abstract Integer[] checkInvalidValues(String fieldId, Type type, SimpleTable table,
			Hashtable<String, TableField> fieldLabelMapping) throws Exception;

	public abstract Integer[] checkInvalidValues(String fieldId, ColumnReference columnReference, SimpleTable table,
			Hashtable<String, TableField> fieldLabelMapping) throws Exception;
	
	public abstract boolean replaceValue(String fieldId, String newValue, int rowId, SimpleTable table,
			Hashtable<String, TableField> fieldLabelMapping) throws Exception;
	
	public abstract void changeColumnType(String fieldId,  ColumnType columnType, SimpleTable table,
			Hashtable<String, TableField> fieldLabelMapping, String ... relatedCL) throws Exception;
	
	public abstract boolean changeColumnDataType(String fieldId, Type type, SimpleTable table,
			Hashtable<String, TableField> fieldLabelMapping) throws NullValuesOnCastException;
	
	public abstract boolean checkRelationMatch(String fieldId, SimpleTable table,
			Hashtable<String, TableField> fieldLabelMapping);
	
	public abstract boolean isMappingFinished(SimpleTable table, Hashtable<String, TableField>fieldLabelMapping);

}
