/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.codelistmanager.util.opensdmx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.Insert;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.contentmanagement.codelistmanager.entities.TableField;
import org.gcube.contentmanagement.codelistmanager.util.ColumnReference;
import org.gcube.contentmanagement.codelistmanager.util.csv.ImportUtil;
import org.gcube.contentmanagement.codelistmanager.util.csv.ProgresChangedEvent;
import org.gcube.contentmanagement.codelistmanager.util.opensdmx.SDMXImport;
import org.sdmx.resources.sdmxml.schemas.v2_0.common.AnnotationType;
import org.sdmx.resources.sdmxml.schemas.v2_0.common.TextType;
import org.sdmx.resources.sdmxml.schemas.v2_0.structure.CodeListType;
import org.sdmx.resources.sdmxml.schemas.v2_0.structure.CodeType;

public class CLSDMXImport
extends SDMXImport {
    private final String CODECOLUMN = "code";
    private final String PARENTCOLUMN = "parent_code";
    private CodeListType codeList;

    public CLSDMXImport(CodeListType codelist) {
        this.codeList = codelist;
    }

    @Override
    public String getAgencyId() {
        return this.codeList.getAgencyID();
    }

    @Override
    public String getName() {
        if (this.codeList.getNames().size() > 0) {
            return ((TextType)this.codeList.getNames().get(0)).getValue();
        }
        return "undefined";
    }

    @Override
    public String getDescription() {
        if (this.codeList.getDescriptions().size() > 0) {
            return ((TextType)this.codeList.getDescriptions().get(0)).getValue();
        }
        return "undefined";
    }

    @Override
    public String getValidFrom() {
        if (this.codeList.getValidFrom() != null) {
            return this.codeList.getValidFrom();
        }
        return "undefined";
    }

    @Override
    public String getValidTo() {
        if (this.codeList.getValidTo() != null) {
            return this.codeList.getValidTo();
        }
        return "undefined";
    }

    @Override
    public float getVersion() {
        if (this.codeList.getVersion() != null) {
            return Float.parseFloat(this.codeList.getVersion());
        }
        return 0.0f;
    }

    @Override
    public boolean isFinal() {
        if (this.codeList.getIsFinal() == null) {
            return false;
        }
        return this.codeList.getIsFinal();
    }

    @Override
    protected List<SDMXImport.FieldDefinition> retrieveFieldsDefinition() {
        ArrayList<SDMXImport.FieldDefinition> fieldsDefinition = new ArrayList<SDMXImport.FieldDefinition>();
        for (CodeType code : this.codeList.getCodes()) {
            SDMXImport.FieldDefinition codeDef;
            if (fieldsDefinition.contains(new SDMXImport.FieldDefinition("code"))) {
                codeDef = (SDMXImport.FieldDefinition)fieldsDefinition.get(fieldsDefinition.indexOf(new SDMXImport.FieldDefinition("code")));
                if (code.getValue().length() > codeDef.getLength()[0]) {
                    codeDef.setLength(new int[]{code.getValue().length(), codeDef.getLength()[1]});
                }
                if (ImportUtil.getAfterDotLength(code.getValue()) > codeDef.getLength()[1]) {
                    codeDef.setLength(new int[]{codeDef.getLength()[0], ImportUtil.getAfterDotLength(code.getValue())});
                }
            } else {
                fieldsDefinition.add(new SDMXImport.FieldDefinition("code", new int[]{code.getValue().length(), ImportUtil.getAfterDotLength(code.getValue())}, new ColumnReference(TableField.ColumnType.Code)));
            }
            if (code.getParentCode() != null) {
                if (fieldsDefinition.contains(new SDMXImport.FieldDefinition("parent_code"))) {
                    codeDef = (SDMXImport.FieldDefinition)fieldsDefinition.get(fieldsDefinition.indexOf(new SDMXImport.FieldDefinition("parent_code")));
                    if (code.getParentCode().length() > codeDef.getLength()[0]) {
                        codeDef.setLength(new int[]{code.getParentCode().length(), codeDef.getLength()[1]});
                    }
                    if (ImportUtil.getAfterDotLength(code.getParentCode()) > codeDef.getLength()[1]) {
                        codeDef.setLength(new int[]{codeDef.getLength()[0], ImportUtil.getAfterDotLength(code.getParentCode())});
                    }
                } else {
                    fieldsDefinition.add(new SDMXImport.FieldDefinition("parent_code", new int[]{code.getParentCode().length(), ImportUtil.getAfterDotLength(code.getParentCode())}, new ColumnReference(TableField.ColumnType.ParentCode)));
                }
            }
            for (TextType description : code.getDescriptions()) {
                if (fieldsDefinition.contains(new SDMXImport.FieldDefinition(description.getLang()))) {
                    SDMXImport.FieldDefinition codeDef2 = (SDMXImport.FieldDefinition)fieldsDefinition.get(fieldsDefinition.indexOf(new SDMXImport.FieldDefinition(description.getLang())));
                    if (description.getValue().length() > codeDef2.getLength()[0]) {
                        codeDef2.setLength(new int[]{description.getValue().length(), codeDef2.getLength()[1]});
                    }
                    if (ImportUtil.getAfterDotLength(description.getValue()) <= codeDef2.getLength()[1]) continue;
                    codeDef2.setLength(new int[]{codeDef2.getLength()[0], ImportUtil.getAfterDotLength(description.getValue())});
                    continue;
                }
                int descriptionLength = description.getValue().length() > 0 ? description.getValue().length() : 1;
                fieldsDefinition.add(new SDMXImport.FieldDefinition(description.getLang(), new int[]{descriptionLength, ImportUtil.getAfterDotLength(code.getValue())}, new ColumnReference(TableField.ColumnType.Description)));
            }
            if (code.getAnnotations() != null) {
                for (AnnotationType annotation : code.getAnnotations().getAnnotations()) {
                    if (fieldsDefinition.contains(new SDMXImport.FieldDefinition(annotation.getAnnotationTitle()))) {
                        SDMXImport.FieldDefinition codeDef3 = (SDMXImport.FieldDefinition)fieldsDefinition.get(fieldsDefinition.indexOf(new SDMXImport.FieldDefinition(annotation.getAnnotationTitle())));
                        if (annotation.getAnnotationTexts().size() <= 0) continue;
                        if (((TextType)annotation.getAnnotationTexts().get(0)).getValue().length() > codeDef3.getLength()[0]) {
                            codeDef3.setLength(new int[]{((TextType)annotation.getAnnotationTexts().get(0)).getValue().length(), codeDef3.getLength()[1]});
                        }
                        if (ImportUtil.getAfterDotLength(((TextType)annotation.getAnnotationTexts().get(0)).getValue()) <= codeDef3.getLength()[1]) continue;
                        codeDef3.setLength(new int[]{codeDef3.getLength()[0], ImportUtil.getAfterDotLength(((TextType)annotation.getAnnotationTexts().get(0)).getValue())});
                        continue;
                    }
                    if (annotation.getAnnotationTexts().size() <= 0) continue;
                    int annotationLength = ((TextType)annotation.getAnnotationTexts().get(0)).getValue().length() > 0 ? ((TextType)annotation.getAnnotationTexts().get(0)).getValue().length() : 1;
                    fieldsDefinition.add(new SDMXImport.FieldDefinition(annotation.getAnnotationTitle(), new int[]{annotationLength, ImportUtil.getAfterDotLength(((TextType)annotation.getAnnotationTexts().get(0)).getValue())}, new ColumnReference(TableField.ColumnType.Annotation)));
                }
            }
            ++this.totalLine;
        }
        return fieldsDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(SimpleTable table, ProgresChangedEvent event) throws Exception {
        Insert insertQuery = (Insert)DBSession.getImplementation(Insert.class);
        insertQuery.setTable(table);
        DBSession session = DBSession.connect();
        session.disableAutoCommit();
        try {
            for (CodeType code : this.codeList.getCodes()) {
                Object[] line = new String[this.fieldsDefinition.size() + 1];
                line[0] = "DEFAULT";
                Arrays.fill(line, null);
                line[this.fieldsDefinition.indexOf((Object)(SDMXImport)this.new SDMXImport.FieldDefinition((String)"code")) + 1] = code.getValue();
                if (code.getParentCode() != null) {
                    line[this.fieldsDefinition.indexOf((Object)(SDMXImport)this.new SDMXImport.FieldDefinition((String)"parent_code")) + 1] = code.getParentCode();
                }
                for (TextType description : code.getDescriptions()) {
                    line[this.fieldsDefinition.indexOf((Object)(SDMXImport)this.new SDMXImport.FieldDefinition((String)description.getLang())) + 1] = description.getValue();
                }
                if (code.getAnnotations() != null) {
                    for (AnnotationType annotation : code.getAnnotations().getAnnotations()) {
                        line[this.fieldsDefinition.indexOf((Object)(SDMXImport)this.new SDMXImport.FieldDefinition((String)annotation.getAnnotationTitle())) + 1] = annotation.getAnnotationTexts().size() > 0 ? ((TextType)annotation.getAnnotationTexts().get(0)).getValue() : null;
                    }
                }
                insertQuery.setInsertValues(line);
                insertQuery.execute(session);
                ++this.progress;
                event.onProgresChanged(this.progress);
            }
            session.commit();
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
    }
}

