/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.codelistmanager.entities;

import org.gcube.common.dbinterface.types.Type;
import org.gcube.contentmanagement.codelistmanager.util.ColumnReference;

public class TableField
implements Comparable<TableField> {
    private String id;
    private String fieldName;
    private ColumnReference columnReference;
    private Type.Types dataType;
    private int[] length;

    public TableField(String id, String fieldName, ColumnType columnType, Type.Types dataType, int[] length) {
        this.id = id;
        this.fieldName = fieldName;
        this.columnReference = new ColumnReference(columnType);
        this.setDataType(dataType);
        this.setLength(length);
    }

    public TableField(String id, String fieldName, ColumnReference columnReference, Type.Types dataType, int[] length) {
        this.id = id;
        this.fieldName = fieldName;
        this.columnReference = columnReference;
        this.setDataType(dataType);
        this.setLength(length);
    }

    public TableField(String id, String fieldName, ColumnReference columnReference, Type.Types dataType) {
        this.id = id;
        this.fieldName = fieldName;
        this.columnReference = columnReference;
        this.setDataType(dataType);
        this.setLength(new int[]{1, 0});
    }

    public TableField(String id, String fieldName, Type.Types dataType) {
        this.id = id;
        this.fieldName = fieldName;
        this.columnReference = new ColumnReference(ColumnType.Undefined);
        this.setDataType(dataType);
        this.setLength(new int[]{1, 0});
    }

    public String getId() {
        return this.id;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setColumnReference(ColumnReference columnReference) {
        this.columnReference = columnReference;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public ColumnReference getColumnReference() {
        return this.columnReference;
    }

    public int[] getLength() {
        return this.length;
    }

    public void setLength(int[] length) {
        this.length = length;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableField other = (TableField)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public void setDataType(Type.Types dataType) {
        this.dataType = dataType;
    }

    public Type.Types getDataType() {
        return this.dataType;
    }

    @Override
    public int compareTo(TableField tablefield) {
        return this.id.compareTo(tablefield.getId());
    }

    public static enum ColumnType {
        Undefined,
        Code,
        Description,
        Annotation,
        ParentCode,
        HLChildCode,
        HLParentCode;

    }
}

