/*
 * Decompiled with CFR 0.152.
 */
package org.opensdmx.client.sdmx20.direct;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.opensdmx.client.OpenSdmxClientException;
import org.sdmx.resources.sdmxml.schemas.v2_0.message.Structure;
import org.sdmx.resources.sdmxml.schemas.v2_0.structure.CodeListType;

public class Sdmx20CustomRegistryClient {
    public Structure retrieveStructure(File file) {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Structure.class});
            Unmarshaller u = jc.createUnmarshaller();
            return (Structure)u.unmarshal(file);
        }
        catch (JAXBException e) {
            throw new OpenSdmxClientException(e);
        }
    }

    public Structure retrieveStructure(InputStream is) {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Structure.class});
            Unmarshaller u = jc.createUnmarshaller();
            return (Structure)u.unmarshal(is);
        }
        catch (JAXBException e) {
            throw new OpenSdmxClientException(e);
        }
    }

    public Structure retrieveStructure(URL url) {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Structure.class});
            Unmarshaller u = jc.createUnmarshaller();
            return (Structure)u.unmarshal(url);
        }
        catch (JAXBException e) {
            throw new OpenSdmxClientException(e);
        }
    }

    public CodeListType retrieveCodelist(InputStream is, String codelistId) {
        Structure structure = this.retrieveStructure(is);
        return this.findCodeListInStructure(codelistId, structure);
    }

    public CodeListType retrieveCodelist(File file, String codelistId) {
        Structure structure = this.retrieveStructure(file);
        return this.findCodeListInStructure(codelistId, structure);
    }

    private CodeListType findCodeListInStructure(String codelistId, Structure structure) {
        List codelists = structure.getCodeLists().getCodeLists();
        CodeListType codelist = null;
        for (CodeListType codeListType : codelists) {
            if (!codeListType.getId().equals(codelistId)) continue;
            codelist = codeListType;
        }
        return codelist;
    }
}

