/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.mongodb.access;

import com.mongodb.ServerAddress;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.content.storage.rest.bean.Credentials;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCubeClient {
    private static final Logger logger = LoggerFactory.getLogger(GCubeClient.class);
    private String username;
    private String password;
    private String[] server;
    private String sc;
    private String sn;

    public GCubeClient(String serviceClass, String serviceName) {
        this.sc = serviceClass;
        this.sn = serviceName;
    }

    public List<ServiceEndpoint> getStorageEndpoint() {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq '" + this.sc + "' and $resource/Profile/Name eq '" + this.sn + "' ");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List resources = client.submit((Query)query);
        return resources;
    }

    public List<ServiceEndpoint> getServiceEndpoint(String sc, String sn) {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq '" + sc + "' and $resource/Profile/Name eq '" + sn + "' ");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List resources = client.submit((Query)query);
        return resources;
    }

    public String[] getServersAddresses(ServiceEndpoint res) {
        this.server = new String[res.profile().accessPoints().size()];
        int i = 0;
        for (ServiceEndpoint.AccessPoint ap : res.profile().accessPoints()) {
            this.server[i] = ap.address();
            this.username = ap.username();
            logger.info("username found ");
            if (this.username != null && this.username.length() > 0) {
                try {
                    this.password = StringEncrypter.getEncrypter().decrypt(ap.password(), new Key[0]);
                    if (this.password != null) {
                        logger.info("password found");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return this.server;
    }

    public String getServersAddressesForSpecificAccessPoint(ServiceEndpoint res, String dbName) {
        String server = null;
        for (ServiceEndpoint.AccessPoint ap : res.profile().accessPoints()) {
            if (!ap.name().equals(dbName)) continue;
            server = ap.address();
            this.username = ap.username();
            logger.info("username found ");
            if (this.username == null || this.username.length() <= 0) continue;
            try {
                this.password = StringEncrypter.getEncrypter().decrypt(ap.password(), new Key[0]);
                if (this.password == null) continue;
                logger.info("password found");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return server;
    }

    public ServiceEndpoint.AccessPoint getAccessPoint(ServiceEndpoint res, String dbName) {
        for (ServiceEndpoint.AccessPoint ap : res.profile().accessPoints()) {
            if (!ap.name().equals(dbName)) continue;
            return ap;
        }
        throw new RuntimeException("AccessPoint Not Found");
    }

    public String getUser(ServiceEndpoint.AccessPoint ap) {
        return ap.username();
    }

    public List<ServerAddress> getMongoServers(ServiceEndpoint.AccessPoint ap) {
        ArrayList<ServerAddress> serverList = new ArrayList<ServerAddress>();
        String serverListString = ap.address();
        String[] serverListArray = serverListString.split(";");
        for (int i = 0; i < serverListArray.length; ++i) {
            serverList.add(new ServerAddress(serverListArray[i]));
        }
        return serverList;
    }

    public String getPassword(ServiceEndpoint.AccessPoint ap) throws Exception {
        return StringEncrypter.getEncrypter().decrypt(ap.password(), new Key[0]).toString();
    }

    public String getServerAccess(ServiceEndpoint.AccessPoint ap) {
        return ap.address();
    }

    public String getProperty(ServiceEndpoint.AccessPoint ap, String name) {
        Map map = ap.propertyMap();
        ServiceEndpoint.Property type = (ServiceEndpoint.Property)map.get(name);
        if (type != null) {
            return type.value();
        }
        return null;
    }

    public String getResolverHost(ServiceEndpoint serviceEndpoint) {
        return serviceEndpoint.profile().runtime().hostedOn();
    }

    public String retrievePropertyValue(ServiceEndpoint res, String name, String scope) {
        ServiceEndpoint.AccessPoint ap;
        Map map;
        ServiceEndpoint.Property type;
        Iterator it = res.profile().accessPoints().iterator();
        String value = null;
        while (it.hasNext() && ((type = (ServiceEndpoint.Property)(map = (ap = (ServiceEndpoint.AccessPoint)it.next()).propertyMap()).get(name)) == null || (value = type.value()) == null)) {
        }
        return value;
    }

    public Credentials getCredentials(String dbName, String collectionFieldName) {
        List resources = this.getStorageEndpoint();
        if (resources != null && resources.size() > 0) {
            ServiceEndpoint.AccessPoint ap = this.getAccessPoint((ServiceEndpoint)resources.get(0), dbName);
            if (ap == null) {
                throw new RuntimeException("DB: " + dbName + " not found on resource " + this.sc + " " + this.sn);
            }
            List server = this.getMongoServers(ap);
            String collection = this.getProperty(ap, collectionFieldName);
            String user = this.getUser(ap);
            String pwd = null;
            try {
                pwd = this.getPassword(ap);
            }
            catch (Exception e) {
                throw new RuntimeException("decrypting password failed");
            }
            Credentials credentials = new Credentials(server, dbName, collection, user, pwd);
            return credentials;
        }
        throw new RuntimeException("resource not found on scope: " + ScopeProvider.instance.get());
    }

    public String retrieveDBEnabled(String dbIdentifier) {
        logger.debug("retrieve db info from id: " + dbIdentifier);
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("/dbMapping.properties");
        Properties prop = new Properties();
        try {
            prop.load(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String value = (String)prop.get(dbIdentifier);
        if (value != null) {
            return value;
        }
        throw new RuntimeException("There is not mapping between token and backend. This call has been rejected");
    }
}

