/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.content.storage.rest.controller;

import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.gcube.content.storage.rest.service.ResourceService;
import org.gcube.content.storage.rest.utils.Utils;

@Path(value="/resources")
public class ResourceController {
    @GET
    @Produces(value={"application/json"})
    public List<String> getResources(@QueryParam(value="gcube_token") String token) {
        ResourceService resourceService = this.initService(token);
        List listOfResources = resourceService.getAllResources();
        return listOfResources;
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public String getResourceById(@PathParam(value="id") String id, @QueryParam(value="gcube_token") String token) {
        ResourceService resourceService = this.initService(token);
        return resourceService.getResource(id);
    }

    @POST
    @Produces(value={"application/json"})
    public String addResource(String resource, @QueryParam(value="gcube_token") String token) {
        ResourceService resourceService = this.initService(token);
        return resourceService.addResource(resource);
    }

    @PUT
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public String updateResource(String resource, @PathParam(value="id") String id, @QueryParam(value="gcube_token") String token) {
        ResourceService resourceService = this.initService(token);
        return resourceService.updateResource(id, resource);
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public void deleteResource(@PathParam(value="id") int id, @QueryParam(value="gcube_token") String token) {
        ResourceService resourceService = this.initService(token);
        resourceService.deleteResource(id);
    }

    private ResourceService initService(String token) {
        if (Utils.isValid((String)token)) {
            ResourceService resourceService = new ResourceService(token);
            return resourceService;
        }
        throw new RuntimeException("You are not allowed to execute this method. Please contact the system administrator.");
    }
}

