/*
 * Decompiled with CFR 0.152.
 */
package org.bitlet.wetorrent.pieceChooser;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bitlet.wetorrent.Torrent;
import org.bitlet.wetorrent.peer.Peer;
import org.bitlet.wetorrent.peer.message.Cancel;
import org.bitlet.wetorrent.peer.message.Request;
import org.bitlet.wetorrent.pieceChooser.RequestExtended;

public abstract class PieceChooser {
    protected Torrent torrent;
    public static final int blockLength = 16384;
    private Set<Integer> completingPieces = new HashSet<Integer>();
    private Map<Peer, Integer> peerPiece = new HashMap<Peer, Integer>();
    private Map<Peer, Set<RequestExtended>> peerPendingRequests = new HashMap<Peer, Set<RequestExtended>>();
    private Map<Integer, Set<RequestExtended>> piecePendingRequests = new HashMap<Integer, Set<RequestExtended>>();
    private Set<RequestExtended> allPendingRequests = new HashSet<RequestExtended>();
    private Set<RequestExtended> orphanPendingRequests = new HashSet<RequestExtended>();

    protected abstract Integer choosePiece(Peer var1, int[] var2);

    protected Set<RequestExtended> getPiecePendingRequests(int index) {
        return this.piecePendingRequests.get(index);
    }

    protected RequestExtended recoverRequest(Peer peer) {
        for (RequestExtended re : this.orphanPendingRequests) {
            if (!peer.hasPiece(re.getIndex())) continue;
            return re;
        }
        return null;
    }

    public synchronized Request getNextBlockRequest(Peer peer, int[] piecesFrequencies) {
        int firstMissingByte;
        RequestExtended recoveredRequest = this.recoverRequest(peer);
        if (recoveredRequest != null) {
            this.associateRequest(peer, recoveredRequest);
            return recoveredRequest;
        }
        Integer pieceIndex = this.peerPiece.get(peer);
        if (pieceIndex == null || this.torrent.getTorrentDisk().isCompleted(pieceIndex) || this.completingPieces.contains(pieceIndex)) {
            this.peerPiece.remove(peer);
            pieceIndex = this.choosePiece(peer, piecesFrequencies);
            if (pieceIndex == null) {
                return this.endGameBlockRequest(peer);
            }
            this.peerPiece.put(peer, pieceIndex);
        }
        if ((firstMissingByte = this.getFirstMissingByte(pieceIndex)) >= this.torrent.getTorrentDisk().getLength(pieceIndex)) {
            throw new AssertionError((Object)"this piece is already completely requested, we should not be here.");
        }
        int pieceMissingBytes = this.torrent.getTorrentDisk().getLength(pieceIndex) - firstMissingByte;
        int requestBlockLength = 16384;
        if (pieceMissingBytes <= 16384) {
            this.completingPieces.add(pieceIndex);
            this.peerPiece.remove(peer);
            requestBlockLength = pieceMissingBytes;
        }
        RequestExtended re = new RequestExtended(pieceIndex, firstMissingByte, requestBlockLength);
        this.associateRequest(peer, re);
        return re;
    }

    private int getFirstMissingByte(Integer pieceIndex) {
        int firstMissingByte = this.torrent.getTorrentDisk().getFirstMissingByte(pieceIndex);
        Collection pendingRequests = this.piecePendingRequests.get(pieceIndex);
        if (pendingRequests != null) {
            for (RequestExtended r : pendingRequests) {
                if (firstMissingByte >= r.getBegin() + r.getLength()) continue;
                firstMissingByte = r.getBegin() + r.getLength();
            }
        }
        return firstMissingByte;
    }

    public synchronized void interrupted(Peer peer) {
        this.peerPiece.remove(peer);
        Set<RequestExtended> pendingRequests = this.peerPendingRequests.get(peer);
        if (pendingRequests != null) {
            for (RequestExtended re : pendingRequests) {
                re.getPeers().remove(peer);
                if (re.getPeers().size() != 0) continue;
                this.orphanPendingRequests.add(re);
            }
            this.peerPendingRequests.remove(peer);
        }
    }

    public synchronized void piece(int index, int begin, byte[] block, Peer peer) {
        RequestExtended request = null;
        Set<RequestExtended> pendingRequests = null;
        pendingRequests = this.peerPendingRequests.get(peer);
        if (pendingRequests != null) {
            for (RequestExtended re : pendingRequests) {
                if (re.getIndex() != index || re.getBegin() != begin || re.getLength() != block.length) continue;
                request = re;
                break;
            }
            if (request != null) {
                pendingRequests.remove(request);
                if (pendingRequests.size() == 0) {
                    this.peerPendingRequests.remove(peer);
                }
                request.getPeers().remove(peer);
                for (Peer p : request.getPeers()) {
                    p.sendMessage(new Cancel(index, begin, block.length));
                    pendingRequests = this.peerPendingRequests.get(p);
                    pendingRequests.remove(request);
                    if (pendingRequests.size() != 0) continue;
                    this.peerPendingRequests.remove(p);
                }
                this.piecePendingRequests.get(index).remove(request);
                this.allPendingRequests.remove(request);
            }
        }
    }

    private Request endGameBlockRequest(Peer peer) {
        RequestExtended reToReturn = null;
        for (RequestExtended re : this.allPendingRequests) {
            if (!peer.hasPiece(re.getIndex()) || re.getPeers().contains(peer) || reToReturn != null && reToReturn.getPeers().size() <= re.getPeers().size()) continue;
            reToReturn = re;
        }
        if (reToReturn != null) {
            this.associateRequest(peer, reToReturn);
        }
        return reToReturn;
    }

    private void associateRequest(Peer peer, RequestExtended re) {
        Set<RequestExtended> pendingRequests = null;
        pendingRequests = this.piecePendingRequests.get(re.getIndex());
        if (pendingRequests == null) {
            pendingRequests = new HashSet<RequestExtended>();
            this.piecePendingRequests.put(re.getIndex(), pendingRequests);
        }
        pendingRequests.add(re);
        pendingRequests = this.peerPendingRequests.get(peer);
        if (pendingRequests == null) {
            pendingRequests = new HashSet<RequestExtended>();
            this.peerPendingRequests.put(peer, pendingRequests);
        }
        pendingRequests.add(re);
        this.allPendingRequests.add(re);
        this.orphanPendingRequests.remove(re);
        re.getPeers().add(peer);
    }

    public synchronized void setTorrent(Torrent torrent) {
        this.torrent = torrent;
    }

    public synchronized Torrent getTorrent() {
        return this.torrent;
    }

    public boolean isCompletingPiece(int pieceIndex) {
        return this.completingPieces.contains(pieceIndex);
    }
}

