/*
 * Decompiled with CFR 0.152.
 */
package org.bitlet.wetorrent;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bitlet.wetorrent.Event;
import org.bitlet.wetorrent.Metafile;
import org.bitlet.wetorrent.Tracker;
import org.bitlet.wetorrent.choker.Choker;
import org.bitlet.wetorrent.disk.TorrentDisk;
import org.bitlet.wetorrent.peer.IncomingPeerListener;
import org.bitlet.wetorrent.peer.Peer;
import org.bitlet.wetorrent.peer.PeersManager;
import org.bitlet.wetorrent.peer.message.Have;
import org.bitlet.wetorrent.peer.message.Request;
import org.bitlet.wetorrent.pieceChooser.PieceChooser;
import org.bitlet.wetorrent.pieceChooser.RouletteWheelPieceChooser;
import org.bitlet.wetorrent.util.Utils;
import org.bitlet.wetorrent.util.stream.BandwidthLimiter;
import org.bitlet.wetorrent.util.thread.InterruptableTasksThread;

public class Torrent
extends InterruptableTasksThread {
    public static boolean SHOW_EXCEPTIONS = false;
    public static final short maxUnfulfilledRequestNumber = 6;
    private Metafile metafile;
    private byte[] peerId;
    private String peerIdEncoded;
    private Tracker activeTracker = null;
    private List<List<Tracker>> trackerTiers = new LinkedList<List<Tracker>>();
    private PeersManager peersManager = new PeersManager(this);
    private TorrentDisk torrentDisk;
    private IncomingPeerListener incomingPeerListener;
    private PieceChooser pieceChooser = null;
    private Choker choker = new Choker();
    public static final String agent = "BitLet.org/0.1";
    public static final boolean verbose = false;
    private BandwidthLimiter uploadBandwidthLimiter;
    private boolean stopped = false;

    public BandwidthLimiter getUploadBandwidthLimiter() {
        return this.uploadBandwidthLimiter;
    }

    public Torrent(Metafile metafile, TorrentDisk torrentDisk, IncomingPeerListener incomingPeerListener) throws Exception {
        this(metafile, torrentDisk, incomingPeerListener, null);
    }

    public Torrent(Metafile metafile, TorrentDisk torrentDisk, IncomingPeerListener incomingPeerListener, BandwidthLimiter uploadBandwidthLimiter) throws Exception {
        this(metafile, torrentDisk, incomingPeerListener, uploadBandwidthLimiter, null);
    }

    public Torrent(Metafile metafile, TorrentDisk torrentDisk, IncomingPeerListener incomingPeerListener, BandwidthLimiter uploadBandwidthLimiter, PieceChooser pieceChooser) throws Exception {
        this.uploadBandwidthLimiter = uploadBandwidthLimiter;
        this.incomingPeerListener = incomingPeerListener;
        this.metafile = metafile;
        this.torrentDisk = torrentDisk;
        this.pieceChooser = pieceChooser != null ? pieceChooser : new RouletteWheelPieceChooser();
        this.pieceChooser.setTorrent(this);
        this.peerId = new byte[20];
        Random random = new Random(System.currentTimeMillis());
        random.nextBytes(this.peerId);
        System.arraycopy("-WT-0001".getBytes(), 0, this.peerId, 0, 8);
        this.peerIdEncoded = Utils.byteArrayToURLString(this.peerId);
        this.incomingPeerListener = incomingPeerListener;
        incomingPeerListener.register(this);
        List announceList = metafile.getAnnounceList();
        if (announceList != null) {
            for (Object elem : announceList) {
                List tier = (List)elem;
                LinkedList<Tracker> trackerTier = new LinkedList<Tracker>();
                for (Object trackerElem : tier) {
                    ByteBuffer trackerAnnounce = (ByteBuffer)trackerElem;
                    Tracker tracker = new Tracker(new String(trackerAnnounce.array()));
                    byte[] keyBytes = new byte[4];
                    random.nextBytes(keyBytes);
                    tracker.setKey(Utils.byteArrayToURLString(keyBytes));
                    trackerTier.add(tracker);
                }
                Collections.shuffle(trackerTier);
                this.trackerTiers.add(trackerTier);
            }
        } else {
            LinkedList<Tracker> uninqueTracker = new LinkedList<Tracker>();
            Tracker tracker = new Tracker(metafile.getAnnounce());
            byte[] keyBytes = new byte[4];
            random.nextBytes(keyBytes);
            tracker.setKey(Utils.byteArrayToURLString(keyBytes));
            uninqueTracker.add(tracker);
            this.trackerTiers.add(uninqueTracker);
        }
        this.activeTracker = this.trackerTiers.get(0).get(0);
    }

    public Map trackerRequest(String event) {
        for (List<Tracker> trackers : this.trackerTiers) {
            for (Tracker t : trackers) {
                try {
                    Map responseDictionary = t.trackerRequest(this, event);
                    if (responseDictionary == null) continue;
                    this.activeTracker = t;
                    trackers.remove(t);
                    trackers.add(0, t);
                    return responseDictionary;
                }
                catch (Exception e) {
                }
            }
        }
        return null;
    }

    public synchronized void addEvent(Event event) {
        System.err.println(event.getDescription() + ": " + event.getAuthor());
    }

    public Metafile getMetafile() {
        return this.metafile;
    }

    public TorrentDisk getTorrentDisk() {
        return this.torrentDisk;
    }

    public byte[] getPeerId() {
        return this.peerId;
    }

    public String getPeerIdEncoded() {
        return this.peerIdEncoded;
    }

    public PeersManager getPeersManager() {
        return this.peersManager;
    }

    public void have(int index, Peer peer) {
        if (!this.torrentDisk.isCompleted(index)) {
            peer.setAmInterested(true);
            if (!peer.isAmChoked()) {
                this.addRequests(peer);
            }
        }
    }

    public void bitfield(byte[] bitfield, Peer peer) {
        for (int i = 0; i < this.metafile.getPieces().size(); ++i) {
            if (!peer.hasPiece(i) || this.torrentDisk.isCompleted(i)) continue;
            peer.setAmInterested(true);
            return;
        }
    }

    public void choke(Peer peer) {
        this.choker.choke(peer);
        this.pieceChooser.interrupted(peer);
    }

    public void unchoke(Peer peer) {
        this.pieceChooser.interrupted(peer);
        this.choker.unchoke(peer);
        this.addRequests(peer);
    }

    public void interested(Peer peer) {
        this.choker.interested(peer);
    }

    public void notInterested(Peer peer) {
        this.choker.notInterested(peer);
    }

    public void piece(int index, int begin, byte[] block, Peer peer) {
        try {
            this.torrentDisk.write(index, begin, block);
            this.pieceChooser.piece(index, begin, block, peer);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        if (this.torrentDisk.isCompleted(index)) {
            this.peersManager.sendHave(new Have(index));
        }
        this.addRequests(peer);
    }

    public void interrupted(Peer peer) {
        this.choker.interrupted(peer);
        this.pieceChooser.interrupted(peer);
    }

    private void addRequests(Peer peer) {
        Request request = null;
        int[] piecesFrequencies = this.peersManager.getPiecesFrequencies();
        while (peer.getUnfulfilledRequestNumber() < 6 && (request = this.pieceChooser.getNextBlockRequest(peer, piecesFrequencies)) != null) {
            peer.sendMessage(request);
        }
        if (request == null && peer.getUnfulfilledRequestNumber() == 0) {
            peer.setAmInterested(false);
        }
    }

    public void addPeers(Object peers) throws UnknownHostException {
        if (peers instanceof List) {
            List peersList = (List)peers;
            for (Object elem : peersList) {
                Map peerMap = (Map)elem;
                ByteBuffer addressByteBuffer = (ByteBuffer)peerMap.get(ByteBuffer.wrap("ip".getBytes()));
                InetAddress address = InetAddress.getByName(new String(addressByteBuffer.array()));
                int port = ((Long)peerMap.get(ByteBuffer.wrap("port".getBytes()))).intValue();
                ByteBuffer peerIdByteByteBuffer = (ByteBuffer)peerMap.get(ByteBuffer.wrap("peer id".getBytes()));
                if (peerIdByteByteBuffer == null) {
                    peerIdByteByteBuffer = (ByteBuffer)peerMap.get(ByteBuffer.wrap("peer_id".getBytes()));
                }
                byte[] peerIdByteString = peerIdByteByteBuffer.array();
                this.peersManager.offer(peerIdByteString, address, port);
            }
        } else if (peers instanceof ByteBuffer) {
            byte[] peersString = ((ByteBuffer)peers).array();
            for (int i = 0; i < peersString.length / 6; ++i) {
                byte[] peerByteAddress = new byte[4];
                System.arraycopy(peersString, i * 6, peerByteAddress, 0, 4);
                InetAddress address = InetAddress.getByAddress(peerByteAddress);
                int port = (peersString[i * 6 + 4] & 0xFF) << 8 | peersString[i * 6 + 5] & 0xFF;
                this.peersManager.offer(null, address, port);
            }
        } else {
            System.err.println("Something bad happened");
        }
    }

    public boolean isCompleted() {
        return this.torrentDisk.getCompleted().longValue() == this.metafile.getLength();
    }

    public void tick() {
        long now;
        this.peersManager.tick();
        this.choker.tick();
        Long waitTime = this.activeTracker.getInterval();
        if (this.incomingPeerListener.getReceivedConnection() == 0 || this.peersManager.getActivePeersNumber() < 4) {
            waitTime = this.activeTracker.getMinInterval() != null ? this.activeTracker.getMinInterval() : 60L;
        }
        if ((now = System.currentTimeMillis()) - this.activeTracker.getLastRequestTime() >= waitTime * 1000L && !this.stopped) {
            try {
                Object peers = this.trackerRequest(null).get(ByteBuffer.wrap("peers".getBytes()));
                if (peers != null) {
                    this.addPeers(peers);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public IncomingPeerListener getIncomingPeerListener() {
        return this.incomingPeerListener;
    }

    public void stopDownload() {
        this.stopped = true;
        new Thread(){

            @Override
            public void run() {
                try {
                    Torrent.this.trackerRequest("stopped");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
        this.getPeersManager().interrupt();
    }

    public void startDownload() throws Exception {
        this.stopped = true;
        Map firstResponseDictionary = this.trackerRequest("started");
        if (firstResponseDictionary == null) {
            throw new Exception("Problem while sending tracker request");
        }
        Object peers = firstResponseDictionary.get(ByteBuffer.wrap("peers".getBytes()));
        this.addPeers(peers);
    }
}

