/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.validator;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gcube.common.validator.Util;
import org.gcube.common.validator.ValidationError;
import org.gcube.common.validator.Validator;
import org.gcube.common.validator.annotations.FieldValidator;
import org.gcube.common.validator.annotations.IsValid;
import org.gcube.common.validator.annotations.ValidityChecker;
import org.gcube.common.validator.context.ValidatorContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultValidator
implements Validator {
    @Override
    public List<ValidationError> validate(Object obj) {
        try {
            return this.validateObject(obj, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<ValidationError> validateObject(Object obj, Object parent) throws Exception {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        Class<?> _clazz = obj.getClass();
        for (Field field : Util.getAllFields(_clazz)) {
            ValidatorContext context = new ValidatorContext(parent, field, obj);
            this.validateField(context);
            errors.addAll(context.errors());
        }
        return errors;
    }

    private void validateField(ValidatorContext context) throws Exception {
        Field field = context.field();
        field.setAccessible(true);
        Object object = context.value();
        Object[] objectArray = field.getAnnotations();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object toCheck;
            Class<FieldValidator<?>> managedClass;
            FieldValidator<?> validator;
            Annotation annotation = objectArray[n2];
            if (annotation.annotationType().isAnnotationPresent(ValidityChecker.class) && !(validator = (managedClass = annotation.annotationType().getAnnotation(ValidityChecker.class).managed()).newInstance()).isValid(toCheck = field.get(object))) {
                context.addError(validator.getErrorSuffix());
            }
            ++n2;
        }
        if (field.isAnnotationPresent(IsValid.class) && field.get(object) != null) {
            if (field.getType().isArray()) {
                objectArray = (Object[])field.get(object);
                n = objectArray.length;
                n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    context.addErrors(this.validateObject(o, object));
                    ++n2;
                }
            } else if (field.get(object) instanceof Iterable) {
                for (Object o : (Iterable)field.get(object)) {
                    context.addErrors(this.validateObject(o, object));
                }
            } else if (field.get(object) instanceof Map) {
                for (Map.Entry entry : ((Map)field.get(object)).entrySet()) {
                    context.addErrors(this.validateObject(entry.getValue(), object));
                }
            } else if (!field.getType().isPrimitive()) {
                context.addErrors(this.validateObject(field.get(object), object));
            }
        }
    }
}

